/*
 * Decompiled with CFR 0.152.
 */
package facs;

import facs.BidirectionalColorGradient;
import facs.CanvasSettings;
import facs.ColorGradient;
import facs.scale.LnScale;
import facs.scale.LogScale;
import facs.scale.Scale;
import facs.scale.ScaleArgument;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

final class PlotUtilities {
    private static final int MAJOR_TICK_LENGTH = 7;
    private static final int MINOR_TICK_LENGTH = 4;
    private static final int COLOR_WIDTH = 2;
    private static final int COLOR_HEIGHT = 20;
    private static final int COLOR_GRADIENT_LEVEL_COUNT = 50;
    private static final double COLOR_GRADIENT_WIDTH = 99.0;
    private static final Color NEG_GATE_FILL_COLOR = new Color(1.0f, 0.25f, 0.25f, 0.1f);
    private static final Color POS_GATE_FILL_COLOR = new Color(0.25f, 1.0f, 0.25f, 0.1f);

    private PlotUtilities() {
    }

    public static void drawXAxis(Graphics2D g, String axisLabel, Scale scale, ScaleArgument scaleArgument, double min, double max, CanvasSettings cs) {
        block30: {
            int maxBin;
            int labelY;
            int scaleY;
            double scaleFactor;
            double scaledMin;
            boolean drawLabelsP;
            block31: {
                int bin;
                double value;
                int j;
                double base;
                int i;
                int endDecade;
                int startDecade;
                boolean powerNotationP;
                if (g == null || scale == null || cs == null || Double.isNaN(min) || Double.isNaN(max)) {
                    return;
                }
                if (!cs.drawAnnotation()) {
                    return;
                }
                drawLabelsP = cs.drawScaleLabel();
                boolean drawTicksP = cs.drawScaleTick();
                int plotWidth = cs.getPlotWidth();
                int plotHeight = cs.getPlotHeight();
                g.setColor(cs.getTextColor());
                if (cs.drawAxisLabel() && axisLabel != null && axisLabel.length() > 0) {
                    if (plotWidth < 128) {
                        g.setFont(CanvasSettings.ARIAL_FONT);
                    } else {
                        g.setFont(CanvasSettings.CRITICAL_LABEL_FONT);
                    }
                    FontMetrics metrics = g.getFontMetrics();
                    int fontHeight = metrics.getHeight();
                    int fontWidth = metrics.stringWidth(axisLabel);
                    g.drawString(axisLabel, (plotWidth - fontWidth) / 2, plotHeight + cs.getBottomPad() + 2 - 4);
                }
                if (min > max) {
                    return;
                }
                if (!drawLabelsP && !drawTicksP) break block30;
                g.setFont(CanvasSettings.ARIAL_FONT_TINY);
                boolean bl = powerNotationP = !cs.useLongLabel();
                if (scaleArgument == null) {
                    scaledMin = scale.getValue(min);
                    scaleFactor = (double)plotWidth / (scale.getValue(max) - scaledMin);
                } else {
                    scaledMin = scale.getValue(min, scaleArgument);
                    scaleFactor = (double)plotWidth / (scale.getValue(max, scaleArgument) - scaledMin);
                }
                scaleY = plotHeight + 2;
                labelY = scaleY + 7;
                maxBin = plotWidth - 1;
                if (!powerNotationP && !(scale instanceof LnScale) && !(scale instanceof LogScale)) break block31;
                if (max > 0.0) {
                    startDecade = 0;
                    if (min > 1.0 && (startDecade = (int)Math.floor(Math.log10(min))) < 0) {
                        startDecade = 0;
                    }
                    endDecade = (int)Math.ceil(Math.log10(max));
                    block0: for (i = startDecade; i <= endDecade && !((base = PlotUtilities.getDecade(i)) > max); ++i) {
                        for (j = 1; j < 10; ++j) {
                            value = base * (double)j;
                            if (value < min) continue;
                            if (value > max) continue block0;
                            bin = scaleArgument == null ? (int)((scale.getValue(value) - scaledMin) * scaleFactor) : (int)((scale.getValue(value, scaleArgument) - scaledMin) * scaleFactor);
                            if (bin < 0) {
                                bin = 0;
                            } else if (bin > maxBin) {
                                bin = maxBin;
                            }
                            if (j == 1) {
                                PlotUtilities.drawXMajorScaleTick(g, bin, scaleY);
                                if (!drawLabelsP) continue;
                                if (powerNotationP) {
                                    PlotUtilities.drawXPowerScaleLabel(g, 10, i, bin, labelY);
                                    continue;
                                }
                                PlotUtilities.drawXScaleLabel(g, CanvasSettings.INT_FORMAT.format(value), bin, labelY);
                                continue;
                            }
                            if (i >= endDecade) continue;
                            PlotUtilities.drawXMinorScaleTick(g, bin, scaleY);
                        }
                    }
                }
                if (!(min < 0.0)) break block30;
                startDecade = 0;
                if (max < -1.0 && (startDecade = (int)Math.floor(Math.log10(Math.abs(max)))) < 0) {
                    startDecade = 0;
                }
                endDecade = (int)Math.ceil(Math.log10(Math.abs(min)));
                block2: for (i = startDecade; i <= endDecade && !((base = PlotUtilities.getDecade(i) * -1.0) < min); ++i) {
                    for (j = 1; j < 10; ++j) {
                        value = base * (double)j;
                        if (value > max) continue;
                        if (value < min) continue block2;
                        bin = scaleArgument == null ? (int)((scale.getValue(value) - scaledMin) * scaleFactor) : (int)((scale.getValue(value, scaleArgument) - scaledMin) * scaleFactor);
                        if (bin < 0) {
                            bin = 0;
                        } else if (bin > maxBin) {
                            bin = maxBin;
                        }
                        if (j == 1) {
                            PlotUtilities.drawXMajorScaleTick(g, bin, scaleY);
                            if (!drawLabelsP) continue;
                            if (powerNotationP) {
                                PlotUtilities.drawXPowerScaleLabel(g, -10, i, bin, labelY);
                                continue;
                            }
                            PlotUtilities.drawXScaleLabel(g, CanvasSettings.INT_FORMAT.format(value), bin, labelY);
                            continue;
                        }
                        if (i >= endDecade) continue;
                        PlotUtilities.drawXMinorScaleTick(g, bin, scaleY);
                    }
                }
                break block30;
            }
            double range = max - min;
            int numTicks = 8;
            for (int i = 0; i <= numTicks; ++i) {
                double value = min + (double)i / (double)numTicks * range;
                int bin = scaleArgument == null ? (int)((scale.getValue(value) - scaledMin) * scaleFactor) : (int)((scale.getValue(value, scaleArgument) - scaledMin) * scaleFactor);
                if (bin < 0) {
                    bin = 0;
                } else if (bin > maxBin) {
                    bin = maxBin;
                }
                if (i % 2 == 1) {
                    PlotUtilities.drawXMinorScaleTick(g, bin, scaleY);
                    continue;
                }
                PlotUtilities.drawXMajorScaleTick(g, bin, scaleY);
                if (!drawLabelsP) continue;
                PlotUtilities.drawXScaleLabel(g, CanvasSettings.INT_FORMAT.format(value), bin, labelY);
            }
        }
    }

    public static void drawYAxis(Graphics2D g, String axisLabel, Scale scale, ScaleArgument scaleArgument, double min, double max, CanvasSettings cs) {
        block30: {
            int height;
            int maxBin;
            int labelX;
            int scaleX;
            double scaleFactor;
            double scaledMin;
            boolean drawLabelsP;
            block31: {
                int y;
                int bin;
                double value;
                int j;
                double base;
                int i;
                int endDecade;
                int startDecade;
                boolean powerNotationP;
                if (g == null || scale == null || cs == null || Double.isNaN(min) || Double.isNaN(max)) {
                    return;
                }
                if (!cs.drawAnnotation()) {
                    return;
                }
                drawLabelsP = cs.drawScaleLabel();
                boolean drawTicksP = cs.drawScaleTick();
                int plotWidth = cs.getPlotWidth();
                int plotHeight = cs.getPlotHeight();
                g.setColor(cs.getTextColor());
                if (cs.drawAxisLabel() && axisLabel != null && axisLabel.length() > 0) {
                    if (plotWidth < 128) {
                        g.setFont(CanvasSettings.ARIAL_FONT);
                    } else {
                        g.setFont(CanvasSettings.CRITICAL_LABEL_FONT);
                    }
                    FontMetrics metrics = g.getFontMetrics();
                    int fontHeight = metrics.getHeight();
                    int fontWidth = metrics.stringWidth(axisLabel);
                    g.rotate(-1.5707963267948966);
                    g.drawString(axisLabel, -(plotHeight + fontWidth) / 2, -cs.getLeftPad() + fontHeight / 2 + 2);
                    g.rotate(1.5707963267948966);
                }
                if (min > max) {
                    return;
                }
                if (!drawLabelsP && !drawTicksP) break block30;
                g.setFont(CanvasSettings.ARIAL_FONT_TINY);
                boolean bl = powerNotationP = !cs.useLongLabel();
                if (scaleArgument == null) {
                    scaledMin = scale.getValue(min);
                    scaleFactor = (double)plotHeight / (scale.getValue(max) - scaledMin);
                } else {
                    scaledMin = scale.getValue(min, scaleArgument);
                    scaleFactor = (double)plotHeight / (scale.getValue(max, scaleArgument) - scaledMin);
                }
                scaleX = -2;
                labelX = scaleX - 7 - 4;
                maxBin = plotHeight - 1;
                height = plotHeight - 1;
                if (!powerNotationP && !(scale instanceof LnScale) && !(scale instanceof LogScale)) break block31;
                if (max > 0.0) {
                    startDecade = 0;
                    if (min > 1.0 && (startDecade = (int)Math.floor(Math.log10(min))) < 0) {
                        startDecade = 0;
                    }
                    endDecade = (int)Math.ceil(Math.log10(max));
                    block0: for (i = startDecade; i <= endDecade && !((base = PlotUtilities.getDecade(i)) > max); ++i) {
                        for (j = 1; j < 10; ++j) {
                            value = base * (double)j;
                            if (value < min) continue;
                            if (value > max) continue block0;
                            bin = scaleArgument == null ? (int)((scale.getValue(value) - scaledMin) * scaleFactor) : (int)((scale.getValue(value, scaleArgument) - scaledMin) * scaleFactor);
                            if (bin < 0) {
                                bin = 0;
                            } else if (bin > maxBin) {
                                bin = maxBin;
                            }
                            y = height - bin;
                            if (j == 1) {
                                PlotUtilities.drawYMajorScaleTick(g, scaleX, y);
                                if (!drawLabelsP) continue;
                                if (powerNotationP) {
                                    PlotUtilities.drawYPowerScaleLabel(g, 10, i, labelX, y);
                                    continue;
                                }
                                PlotUtilities.drawYScaleLabel(g, CanvasSettings.INT_FORMAT.format(value), labelX, y);
                                continue;
                            }
                            if (i >= endDecade) continue;
                            PlotUtilities.drawYMinorScaleTick(g, scaleX, y);
                        }
                    }
                }
                if (!(min < 0.0)) break block30;
                startDecade = 0;
                if (max < -1.0 && (startDecade = (int)Math.floor(Math.log10(Math.abs(max)))) < 0) {
                    startDecade = 0;
                }
                endDecade = (int)Math.ceil(Math.log10(Math.abs(min)));
                block2: for (i = startDecade; i <= endDecade && !((base = PlotUtilities.getDecade(i) * -1.0) < min); ++i) {
                    for (j = 1; j < 10; ++j) {
                        value = base * (double)j;
                        if (value > max) continue;
                        if (value < min) continue block2;
                        bin = scaleArgument == null ? (int)((scale.getValue(value) - scaledMin) * scaleFactor) : (int)((scale.getValue(value, scaleArgument) - scaledMin) * scaleFactor);
                        if (bin < 0) {
                            bin = 0;
                        } else if (bin > maxBin) {
                            bin = maxBin;
                        }
                        y = height - bin;
                        if (j == 1) {
                            PlotUtilities.drawYMajorScaleTick(g, scaleX, y);
                            if (!drawLabelsP) continue;
                            if (powerNotationP) {
                                PlotUtilities.drawYPowerScaleLabel(g, 10, i, labelX, y);
                                continue;
                            }
                            PlotUtilities.drawYScaleLabel(g, CanvasSettings.INT_FORMAT.format(value), labelX, y);
                            continue;
                        }
                        if (i >= endDecade) continue;
                        PlotUtilities.drawYMinorScaleTick(g, scaleX, y);
                    }
                }
                break block30;
            }
            double range = max - min;
            int numTicks = 8;
            for (int i = 0; i <= numTicks; ++i) {
                double value = min + (double)i / (double)numTicks * range;
                int bin = scaleArgument == null ? (int)((scale.getValue(value) - scaledMin) * scaleFactor) : (int)((scale.getValue(value, scaleArgument) - scaledMin) * scaleFactor);
                if (bin < 0) {
                    bin = 0;
                } else if (bin > maxBin) {
                    bin = maxBin;
                }
                int y = height - bin;
                if (i % 2 == 1) {
                    PlotUtilities.drawYMinorScaleTick(g, scaleX, y);
                    continue;
                }
                PlotUtilities.drawYMajorScaleTick(g, scaleX, y);
                if (!drawLabelsP) continue;
                PlotUtilities.drawYScaleLabel(g, CanvasSettings.INT_FORMAT.format(value), labelX, y);
            }
        }
    }

    public static void drawPseudoZAxis(Graphics2D g, String axisLabel, Scale scale, ScaleArgument scaleArgument, double min, double max, CanvasSettings cs) {
        if (g == null || scale == null || cs == null || Double.isNaN(min) || Double.isNaN(max)) {
            return;
        }
        if (!cs.drawAnnotation()) {
            return;
        }
        boolean drawLabelsP = cs.drawScaleLabel();
        boolean drawTicksP = cs.drawScaleTick();
        int plotWidth = cs.getPlotWidth();
        int plotHeight = cs.getPlotHeight();
        g.setColor(cs.getTextColor());
        if (cs.drawAxisLabel() && axisLabel != null && axisLabel.length() > 0) {
            if (plotWidth < 128) {
                g.setFont(CanvasSettings.ARIAL_FONT);
            } else {
                g.setFont(CanvasSettings.CRITICAL_LABEL_FONT);
            }
            FontMetrics metrics = g.getFontMetrics();
            int fontHeight = metrics.getHeight();
            String zLabel = "z: ";
            if (cs.getPlotType() == 201) {
                zLabel = zLabel + "MFI ";
            } else if (cs.getPlotType() == 202) {
                zLabel = zLabel + "95th ";
            }
            zLabel = zLabel + axisLabel;
            int fontWidth = metrics.stringWidth(zLabel);
            g.drawString(zLabel, plotWidth / 2 - fontWidth / 2, -10);
        }
    }

    public static void drawXCountAxis(Graphics2D g, int max, int maxX, CanvasSettings cs) {
        if (g == null || cs == null || !cs.drawAnnotation()) {
            return;
        }
        int plotWidth = cs.getPlotWidth();
        int plotHeight = cs.getPlotHeight();
        g.setColor(cs.getTextColor());
        String label = "Counts";
        if (cs.drawAxisLabel()) {
            if (plotWidth < 200) {
                g.setFont(CanvasSettings.ARIAL_FONT_SMALL);
            } else {
                g.setFont(CanvasSettings.ARIAL_FONT);
            }
            FontMetrics metrics = g.getFontMetrics();
            int fontWidth = metrics.stringWidth(label);
            g.drawString(label, (plotWidth - fontWidth) / 2, plotHeight + cs.getBottomPad() - 4);
        }
        if (cs.drawScaleTick()) {
            int scaleY = plotHeight + 2;
            PlotUtilities.drawXMajorScaleTick(g, 0, scaleY);
            PlotUtilities.drawXMajorScaleTick(g, maxX, scaleY);
        }
        if (cs.drawScaleLabel()) {
            g.setFont(CanvasSettings.ARIAL_FONT_TINY);
            int labelY = plotHeight + 2 + 7;
            PlotUtilities.drawXScaleLabel(g, Integer.toString(0), 0, labelY);
            PlotUtilities.drawXScaleLabel(g, Integer.toString(max), maxX, labelY);
        }
    }

    public static void drawYCountAxis(Graphics2D g, int max, int maxY, CanvasSettings cs) {
        if (g == null || cs == null || !cs.drawAnnotation()) {
            return;
        }
        int plotWidth = cs.getPlotWidth();
        int plotHeight = cs.getPlotHeight();
        g.setColor(cs.getTextColor());
        String label = "Counts";
        if (cs.drawAxisLabel()) {
            if (plotWidth < 200) {
                g.setFont(CanvasSettings.ARIAL_FONT_SMALL);
            } else {
                g.setFont(CanvasSettings.ARIAL_FONT);
            }
            FontMetrics metrics = g.getFontMetrics();
            int fontHeight = metrics.getHeight();
            int fontWidth = metrics.stringWidth(label);
            g.rotate(-1.5707963267948966);
            g.drawString(label, -(plotHeight + fontWidth) / 2, -cs.getLeftPad() + fontHeight + 4);
            g.rotate(1.5707963267948966);
        }
        if (cs.drawScaleTick()) {
            int scaleX = -2;
            PlotUtilities.drawYMajorScaleTick(g, scaleX, plotHeight);
            PlotUtilities.drawYMajorScaleTick(g, scaleX, maxY);
        }
        if (cs.drawScaleLabel()) {
            g.setFont(CanvasSettings.ARIAL_FONT_TINY);
            int labelX = -13;
            PlotUtilities.drawYScaleLabel(g, Integer.toString(0), labelX, plotHeight);
            PlotUtilities.drawYScaleLabel(g, Integer.toString(max), labelX, maxY);
        }
    }

    public static double getDecade(int power) {
        if (power == 0) {
            return 1.0;
        }
        double decade = 1.0;
        if (power < 0) {
            power = Math.abs(power);
            for (int i = 0; i < power; ++i) {
                decade /= 10.0;
            }
        } else {
            for (int i = 0; i < power; ++i) {
                decade *= 10.0;
            }
        }
        return decade;
    }

    private static void drawXMajorScaleTick(Graphics g, int x, int y) {
        PlotUtilities.drawScaleTick(g, x, y, false, 7);
    }

    private static void drawYMajorScaleTick(Graphics g, int x, int y) {
        PlotUtilities.drawScaleTick(g, x, y, true, 7);
    }

    private static void drawXMinorScaleTick(Graphics g, int x, int y) {
        PlotUtilities.drawScaleTick(g, x, y, false, 4);
    }

    private static void drawYMinorScaleTick(Graphics g, int x, int y) {
        PlotUtilities.drawScaleTick(g, x, y, true, 4);
    }

    private static void drawScaleTick(Graphics g, int x, int y, boolean yAxisP, int length) {
        if (g == null) {
            return;
        }
        if (yAxisP) {
            g.drawLine(x, y, x - length, y);
        } else {
            g.drawLine(x, y, x, y + length);
        }
    }

    private static void drawXScaleLabel(Graphics g, String label, int x, int y) {
        PlotUtilities.drawScaleLabel(g, label, x, y, false);
    }

    private static void drawYScaleLabel(Graphics g, String label, int x, int y) {
        PlotUtilities.drawScaleLabel(g, label, x, y, true);
    }

    private static void drawScaleLabel(Graphics g, String label, int x, int y, boolean yAxisP) {
        if (g == null || label == null || label.length() <= 0) {
            return;
        }
        FontMetrics metrics = g.getFontMetrics();
        int fontHeight = metrics.getHeight();
        int fontWidth = metrics.stringWidth(label);
        if (yAxisP) {
            g.drawString(label, x - fontWidth, y + fontHeight / 2);
        } else {
            g.drawString(label, x - fontWidth / 2, y + fontHeight);
        }
    }

    private static void drawXPowerScaleLabel(Graphics g, int base, int power, int x, int y) {
        PlotUtilities.drawPowerScaleLabel(g, base, power, x, y, false);
    }

    private static void drawYPowerScaleLabel(Graphics g, int base, int power, int x, int y) {
        PlotUtilities.drawPowerScaleLabel(g, base, power, x, y, true);
    }

    private static void drawPowerScaleLabel(Graphics g, int base, int power, int x, int y, boolean yAxisP) {
        if (g == null) {
            return;
        }
        String baseString = Integer.toString(base);
        String powerString = Integer.toString(power);
        FontMetrics metrics = g.getFontMetrics();
        int fontHeight = metrics.getHeight();
        int baseWidth = metrics.stringWidth(baseString);
        int powerWidth = metrics.stringWidth(powerString);
        if (yAxisP) {
            g.drawString(baseString, x - (baseWidth + powerWidth), y + (int)((double)fontHeight * 0.75));
            g.drawString(powerString, x - powerWidth, y + (int)((double)fontHeight * 0.25));
        } else {
            g.drawString(baseString, x - (baseWidth + powerWidth) / 2, y + fontHeight + fontHeight / 2);
            g.drawString(powerString, x - (baseWidth + powerWidth) / 2 + baseWidth, y + fontHeight);
        }
    }

    public static BufferedImage drawHistogramOverlayLabels(String[] labels, CanvasSettings cs) {
        if (labels == null || cs == null || cs.getPlotType() != 101) {
            return null;
        }
        cs.setRowCount(labels.length);
        int maxLength = 0;
        for (int i = 0; i < labels.length; ++i) {
            if (labels[i] == null || labels[i].length() <= maxLength) continue;
            maxLength = labels[i].length();
        }
        int fontWidth = 12;
        int imageWidth = fontWidth * maxLength;
        BufferedImage image = new BufferedImage(imageWidth, cs.getCanvasHeight(), 1);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(cs.getBackgroundColor());
        g.fillRect(0, 0, imageWidth, cs.getCanvasHeight());
        g.setFont(CanvasSettings.CRITICAL_LABEL_FONT);
        FontMetrics metrics = g.getFontMetrics();
        int fontHeight = metrics.getHeight();
        g.setColor(cs.getTextColor());
        for (int i = 0; i < labels.length; ++i) {
            if (labels[i] == null || labels[i].length() <= 0) continue;
            int topY = cs.getBottomY(i, 0) - fontHeight + 3;
            int labelX = imageWidth - 2;
            g.translate(0, topY);
            PlotUtilities.drawYScaleLabel(g, labels[i], labelX, 0);
            g.translate(0, -topY);
        }
        g.dispose();
        return image;
    }

    public static BufferedImage drawColorGradient(ColorGradient gradient) {
        return PlotUtilities.drawColorGradient(gradient, 20);
    }

    public static BufferedImage drawColorGradient(ColorGradient gradient, int barHeight) {
        if (gradient == null) {
            return null;
        }
        boolean bidirectionalP = gradient instanceof BidirectionalColorGradient;
        int xOffset = 30;
        int yOffset = 1;
        int levelCount = 50;
        if (bidirectionalP) {
            levelCount += 49;
        }
        int scaleImageWidth = levelCount * 2 + 2 * xOffset;
        int scaleImageHeight = barHeight + 30;
        BufferedImage image = new BufferedImage(scaleImageWidth, scaleImageHeight, 1);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.white);
        g.fillRect(0, 0, scaleImageWidth, scaleImageHeight);
        double gradientMin = gradient.getMinimum();
        double gradientMax = gradient.getMaximum();
        double increment = Math.abs(gradientMax - gradientMin) / (double)(levelCount - 1);
        for (int i = 0; i < levelCount; ++i) {
            g.setColor(gradient.getColor(gradientMin + (double)i * increment));
            g.fillRect(xOffset + i * 2, yOffset, 2, barHeight);
        }
        g.setColor(Color.black);
        g.drawRect(xOffset - 1, 0, levelCount * 2 + 1, barHeight + 1);
        if (!Double.isNaN(gradientMin) && !Double.isNaN(gradientMin)) {
            int minX = xOffset;
            int maxX = xOffset + levelCount * 2 - 1;
            int tickY = yOffset + barHeight + 1;
            int labelY = yOffset + barHeight + 1 + 4;
            PlotUtilities.drawXMinorScaleTick(g, minX, tickY);
            PlotUtilities.drawXScaleLabel(g, CanvasSettings.DOUBLE_FORMAT.format(gradientMin), minX, labelY);
            PlotUtilities.drawXMinorScaleTick(g, maxX, tickY);
            PlotUtilities.drawXScaleLabel(g, CanvasSettings.DOUBLE_FORMAT.format(gradientMax), maxX, labelY);
            if (bidirectionalP) {
                double inflection = ((BidirectionalColorGradient)gradient).getInflection();
                double minMinorScaleTickValue = PlotUtilities.middleValue(gradientMin, inflection);
                double maxMinorScaleTickValue = PlotUtilities.middleValue(inflection, gradientMax);
                int inflectionXCoord = PlotUtilities.relativeXCoordinate(inflection, gradientMin, gradientMax, xOffset);
                int minMinorScaleXCoord = PlotUtilities.relativeXCoordinate(minMinorScaleTickValue, gradientMin, gradientMax, xOffset);
                int maxMinorScaleXCoord = PlotUtilities.relativeXCoordinate(maxMinorScaleTickValue, gradientMin, gradientMax, xOffset);
                PlotUtilities.drawXMinorScaleTick(g, inflectionXCoord, tickY);
                PlotUtilities.drawXScaleLabel(g, CanvasSettings.DOUBLE_FORMAT.format(inflection), inflectionXCoord, labelY);
                PlotUtilities.drawXMinorScaleTick(g, minMinorScaleXCoord, tickY);
                PlotUtilities.drawXScaleLabel(g, CanvasSettings.DOUBLE_FORMAT.format(minMinorScaleTickValue), minMinorScaleXCoord, labelY);
                PlotUtilities.drawXMinorScaleTick(g, maxMinorScaleXCoord, tickY);
                PlotUtilities.drawXScaleLabel(g, CanvasSettings.DOUBLE_FORMAT.format(maxMinorScaleTickValue), maxMinorScaleXCoord, labelY);
            } else {
                int middleX = xOffset + 50;
                PlotUtilities.drawXMinorScaleTick(g, middleX, tickY);
                PlotUtilities.drawXScaleLabel(g, CanvasSettings.DOUBLE_FORMAT.format((gradientMin + gradientMax) / 2.0), middleX, labelY);
            }
        }
        g.dispose();
        return image;
    }

    public static int relativeXCoordinate(double value, double min, double max, double offset) {
        double relativePosition = PlotUtilities.range(value, min) / PlotUtilities.range(min, max) * 99.0 * 2.0;
        return (int)Math.round(relativePosition + offset);
    }

    public static double range(double value1, double value2) {
        if (value1 != value2) {
            double min = Math.min(value1, value2);
            double max = Math.max(value1, value2);
            if (min < 0.0 && max <= 0.0) {
                return Math.abs(min) - Math.abs(max);
            }
            if (min >= 0.0 && max > 0.0) {
                return Math.abs(max) - Math.abs(min);
            }
            return Math.abs(min) + Math.abs(max);
        }
        return 0.0;
    }

    public static double middleValue(double valueOne, double valueTwo) {
        if (valueOne < valueTwo) {
            return valueTwo - PlotUtilities.range(valueOne, valueTwo) / 2.0;
        }
        if (valueOne > valueTwo) {
            return valueOne - PlotUtilities.range(valueOne, valueTwo) / 2.0;
        }
        return valueOne;
    }
}

