/*
 * Decompiled with CFR 0.152.
 */
package cytospade;

import cytospade.fcsFile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpadeContext {
    private File path;
    private WorkflowKind workflowKind;
    private File[] fcsFiles;
    private File[] gmlFiles;
    private String[] selectedClusteringMarkers;
    private HashMap analysisPanels = new HashMap();
    private int arcsinh = 5;
    private int targetClusters = 200;
    private DownsampleKind downsampleKind;
    private int targetDownsampleEvents = 5000;
    private int targetDownsamplePctile = 5;
    private double nodeSizeScaleFactor = 1.2;
    private NormalizationKind normalizationKind = NormalizationKind.GLOBAL;
    private SymmetryType symmetryType = SymmetryType.ASYMMETRIC;

    public SpadeContext() {
        this.selectedClusteringMarkers = new String[0];
    }

    public File getPath() {
        return this.path;
    }

    public void setPath(File path) {
        this.path = path;
        this.analysisPanels.clear();
        this.selectedClusteringMarkers = new String[0];
        this.gmlFiles = path.listFiles(new FilenameFilter(){

            public boolean accept(File f, String name) {
                return name.endsWith(".medians.gml");
            }
        });
        if (this.gmlFiles.length > 0) {
            this.fcsFiles = path.listFiles(new FilenameFilter(){

                public boolean accept(File f, String name) {
                    return name.endsWith(".cluster.fcs");
                }
            });
            if (this.gmlFiles.length != this.fcsFiles.length) {
                throw new IllegalArgumentException("Missing fcs or gml files");
            }
            Arrays.sort(this.fcsFiles);
            Arrays.sort(this.gmlFiles);
            for (int i = 0; i < this.gmlFiles.length; ++i) {
                if (this.gmlFiles[i].getName().contains(this.fcsFiles[i].getName())) continue;
                throw new IllegalArgumentException("Missing counterpart for " + this.gmlFiles[i]);
            }
            this.workflowKind = WorkflowKind.ANALYSIS;
        } else {
            this.fcsFiles = path.listFiles(new FilenameFilter(){

                public boolean accept(File f, String name) {
                    return name.endsWith(".fcs");
                }
            });
            if (this.fcsFiles.length == 0) {
                throw new IllegalArgumentException("No FCS files found in directory");
            }
            Arrays.sort(this.fcsFiles);
            this.workflowKind = WorkflowKind.PROCESSING;
        }
    }

    public WorkflowKind getWorkflowKind() {
        return this.workflowKind;
    }

    public File[] getFCSFiles() {
        return this.fcsFiles;
    }

    public File[] getFCSFilesNotInPanel() {
        HashSet<File> f = new HashSet<File>(Arrays.asList(this.fcsFiles));
        Iterator it = this.analysisPanels.entrySet().iterator();
        while (it.hasNext()) {
            AnalysisPanel p = (AnalysisPanel)it.next().getValue();
            f.removeAll(Arrays.asList(p.panel_files));
        }
        Object[] files = f.toArray(new File[0]);
        Arrays.sort(files);
        return files;
    }

    public File[] getGMLFiles() {
        return this.gmlFiles;
    }

    public String[] getPotentialClusteringMarkers() {
        return SpadeContext.getCommonMarkers(this.fcsFiles);
    }

    public String[] getSelectedClusteringMarkers() {
        return this.selectedClusteringMarkers;
    }

    public void setSelectedClusteringMarkers(String[] selectedClusteringMarkers) {
        this.selectedClusteringMarkers = selectedClusteringMarkers;
    }

    public int getArcsinh() {
        return this.arcsinh;
    }

    public void setArcsinh(int arcsinh) {
        this.arcsinh = arcsinh;
    }

    public double getNodeSizeScaleFactor() {
        return this.nodeSizeScaleFactor;
    }

    public void setNodeSizeScaleFactor(double nodeSizeScaleFactor) {
        this.nodeSizeScaleFactor = nodeSizeScaleFactor;
    }

    public NormalizationKind getNormalizationKind() {
        return this.normalizationKind;
    }

    public void setNormalizationKind(NormalizationKind normalizationKind) {
        this.normalizationKind = normalizationKind;
    }

    public void setSymmetry(SymmetryType symmetryType) {
        this.symmetryType = symmetryType;
    }

    public SymmetryType getSymmetry() {
        return this.symmetryType;
    }

    public int getTargetClusters() {
        return this.targetClusters;
    }

    public void setTargetClusters(int targetClusters) {
        this.targetClusters = targetClusters;
    }

    public DownsampleKind getDownsampleKind() {
        return this.downsampleKind;
    }

    public void setDownsampleKind(DownsampleKind downsampleKind) {
        this.downsampleKind = downsampleKind;
    }

    public int getTargetDownsamplePctile() {
        return this.targetDownsamplePctile;
    }

    public void setTargetDownsamplePctile(int targetDownsamplePctile) {
        this.targetDownsamplePctile = targetDownsamplePctile;
    }

    public int getTargetDownsampleEvents() {
        return this.targetDownsampleEvents;
    }

    public void setTargetDownsampleEvents(int targetDownsampleEvents) {
        this.targetDownsampleEvents = targetDownsampleEvents;
    }

    public void addAnalysisPanel(String name, AnalysisPanel panel) {
        this.analysisPanels.put(name, panel);
    }

    public void removeAnalysisPanel(String name) {
        this.analysisPanels.remove(name);
    }

    public AnalysisPanel getAnalysisPanel(String name) {
        return (AnalysisPanel)this.analysisPanels.get(name);
    }

    public String[] getAnalysisPanelsNames() {
        return this.analysisPanels.keySet().toArray(new String[0]);
    }

    public String getContextAsFormattedString() {
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setGroupingUsed(false);
        StringBuilder str = new StringBuilder();
        str.append("Directory: ").append(this.getPath()).append("\n").append("Clustering Parameters:\n").append("  Transformation:  flowCore::arcsinh(a=0.0, b=").append(nf.format(1.0 / (double)this.getArcsinh())).append(")\n");
        switch (this.getDownsampleKind()) {
            case PERCENTILE: {
                str.append("  Downsample Percentile:  ").append(this.getTargetDownsamplePctile()).append("\n");
                break;
            }
            default: {
                str.append("  Target Downsampled Cells:  ").append(this.getTargetDownsampleEvents()).append("\n");
            }
        }
        str.append("  Target Number of Clusters:  ").append(this.getTargetClusters()).append("\n").append("  Clustering Markers:  ").append(SpadeContext.join(Arrays.asList(this.getSelectedClusteringMarkers()), ", ")).append("\n").append("Panels:\n");
        if (this.analysisPanels.isEmpty()) {
            str.append("  Default:\n").append("    Panel Files:  All\n").append("    Median Markers:  All\n").append("    Reference Files:  None\n").append("    Fold-change Markers:  None\n");
        } else {
            for (Map.Entry me : this.analysisPanels.entrySet()) {
                AnalysisPanel p = (AnalysisPanel)me.getValue();
                str.append("  ").append(me.getKey()).append(":\n").append("    Panel Files:  ").append(SpadeContext.join(Arrays.asList(p.panel_files), ", ")).append("\n").append("    Median Markers:  All\n").append("    Reference Files:  ").append(SpadeContext.join(Arrays.asList(p.reference_files), ", ")).append("\n").append("    Fold-change Markers:  ").append(SpadeContext.join(Arrays.asList(p.fold_markers), ", ")).append("\n");
            }
        }
        return str.toString();
    }

    public void authorMakePivot(String filename) throws IOException {
        FileWriter fstream = new FileWriter(new File(this.getPath(), filename).getAbsolutePath());
        BufferedWriter out = new BufferedWriter(fstream);
        out.write("OUTPUT_DIR='./'\nfiles <- dir(OUTPUT_DIR,pattern=glob2rx(\"*.anno.Rsave\"))\nparams <- unique(as.vector(sapply(files, function(f) { load(f); colnames(anno); })))\ndir.create(paste(OUTPUT_DIR,'pivot',sep=''),recursive=TRUE,showWarnings=FALSE)\nfor (p in params) {\n cat('Generating table for',p,\"\\n\")\n pivot <- c(); names <- c();\n for (f in files) { load(f); if (p %in% colnames(anno)) { pivot <- cbind(pivot, anno[,p]); names <- c(names, f); }}\n pivot <- cbind(0:(nrow(pivot)-1),pivot); colnames(pivot) <- c(\"cytoscape_id\", names);\n if (!is.null(pivot) && ncol(pivot) > 0) { write.csv(pivot, file=paste(OUTPUT_DIR,'pivot/',p,'_pivot','.csv',sep=''), row.names=TRUE) }\n}\n");
        out.close();
    }

    public void authorPlotSpade(String filename) throws IOException {
        FileWriter fstream = new FileWriter(new File(this.getPath(), filename).getAbsolutePath());
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setGroupingUsed(false);
        BufferedWriter out = new BufferedWriter(fstream);
        out.write("LIBRARY_PATH=NULL\nlibrary(\"spade\",lib.loc=LIBRARY_PATH)\n");
        out.write(String.format("NODE_SIZE_SCALE_FACTOR=%s\n", nf.format(this.getNodeSizeScaleFactor())));
        out.write("NORMALIZE=\"" + this.getNormalizationKind().toString().toLowerCase() + "\"\n");
        out.write("OUTPUT_DIR=\"./\"\nLAYOUT_TABLE <- read.table(paste(OUTPUT_DIR,\"layout.table\",sep=\"\"))\nMST_GRAPH <- read.graph(paste(OUTPUT_DIR,\"mst.gml\",sep=\"\"),format=\"gml\")\nSPADE.plot.trees(MST_GRAPH,OUTPUT_DIR,file_pattern=\"*fcs*Rsave\",layout=as.matrix(LAYOUT_TABLE),out_dir=paste(OUTPUT_DIR,\"pdf\",sep=\"\"),size_scale_factor=NODE_SIZE_SCALE_FACTOR,normalize=NORMALIZE)\n");
        out.close();
    }

    public void authorRunSpade(String filename) throws IOException {
        FileWriter fstream = new FileWriter(new File(this.getPath(), filename).getAbsolutePath());
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setGroupingUsed(false);
        BufferedWriter out = new BufferedWriter(fstream);
        out.write("#!/usr/bin/env Rscript\n# ^^set this to your Rscript path\n#\n# runSPADE:  R wrapper script for SPADE tree construction\n# Erin Simonds - esimonds@stanford.edu\n# Version 2.5 - June 29, 2012\n# Autogenerated by CytoSPADE\n#\n# Command line instructions:\n#   1) Make sure the first line of this file is your Rscript path (found in the same directory as R)\n#\n#   2) Move the entire directory containing this script and the FCS file(s) to be analyzed to the computer on which you will run SPADE\n#\n#   3) In a command shell, navigate to the folder containing this script and the FCS file(s) to be analyzed\n#\n#   4) Make this script executable.  At the command line, run:\n#\t$ chmod +x runSPADE.R\n#\n#   5a) For normal use (not in a load sharing or compute cluster): At the command line, run:\n#\t$ ./runSPADE.R [-num_threads=X] [-file_to_process=Y]\n#\twhere X is the number of threads you wish to use (default = 1)\n#\tY is the name of the file to process (default = use file(s) specified in this script)\n#\t\tNote that parameters in brackets may be omitted.\n#\n#   5b) For Sun Gridengine: At the command line, run:\n#\t$ qsub -cwd -j y -b y -m e -M username@domain.ext [-pe threaded A] ./runSPADE.R [-num_threads=X] [-file_to_process=Y]\n#\twhere username@domain.ext is your e-mail address to e-mail when the job is done,\n#\tA is the number of slots to reserve with Gridengine,\n#\tX is the number of threads to use in SPADE (usually the same as A) (default = 1).\n#\tY is the name of the file to process (default = use file(s) specified in this script)\n#\t\tNote that parameters in brackets may be omitted.\n#\n#   5c) For Platform LSF: At the command line, run:\n#\t$ bsub [-n A -R \"span[hosts=1]\"] ./runSPADE.R [-num_threads=X] [-file_to_process=Y]\n#\tA is the number of slots to reserve with LSF,\n#\tX is the number of threads to use in SPADE (usually the same as A) (default = 1).\n#\tY is the name of the file to process (default = use file(s) specified in this script)\n#\t\tNote that parameters in brackets may be omitted. (Note that the brackets surrounding \"hosts=1\" do not indicate an optional parameter.)\n#\n# Interactive instructions:\n#   1) Move the entire directory containing this script and the FCS file(s) to be analyzed to the computer on which you will run SPADE\n#   2) In an interactive R session, change the working directory to the folder created in step 1\n#   3) At the R command line, run: source(\"runSPADE.R\")\n#\n");
        out.write("#BEGIN AUTOGENERATED DATA\n");
        out.write("FILE_TO_PROCESS=\".\"\n");
        out.write("CLUSTERING_MARKERS=c(");
        for (int i = 0; i < this.selectedClusteringMarkers.length; ++i) {
            if (i > 0) {
                out.write(44);
            }
            String m = this.selectedClusteringMarkers[i];
            out.write(String.format("\"%s\"", SpadeContext.getShortNameFromFormattedName(m)));
        }
        out.write(")\n");
        if (!this.analysisPanels.isEmpty()) {
            out.write("PANELS=list(\n");
            Iterator it = this.analysisPanels.entrySet().iterator();
            while (it.hasNext()) {
                int i;
                out.write("list(\n");
                AnalysisPanel p = (AnalysisPanel)it.next().getValue();
                out.write("panel_files=c(");
                for (i = 0; i < p.panel_files.length; ++i) {
                    if (i > 0) {
                        out.write(",");
                    }
                    out.write("\"" + p.panel_files[i].getName() + "\"");
                }
                out.write("),\n");
                out.write("median_cols=NULL,\n");
                if (p.reference_files.length > 0) {
                    out.write("reference_files=c(");
                    for (i = 0; i < p.reference_files.length; ++i) {
                        if (i > 0) {
                            out.write(",");
                        }
                        out.write("\"" + p.reference_files[i].getName() + "\"");
                    }
                    out.write("),\n");
                } else {
                    out.write("reference_files=NULL,\n");
                }
                if (p.fold_markers.length > 0) {
                    out.write("fold_cols=c(");
                    for (i = 0; i < p.fold_markers.length; ++i) {
                        if (i > 0) {
                            out.write(",");
                        }
                        String m = p.fold_markers[i];
                        out.write(String.format("\"%s\"", SpadeContext.getShortNameFromFormattedName(m)));
                    }
                    out.write(")\n");
                } else {
                    out.write("fold_cols=NULL\n");
                }
                if (it.hasNext()) {
                    out.write("),\n");
                    continue;
                }
                out.write(")");
            }
            out.write(")\n");
        } else {
            out.write("PANELS=NULL\n");
        }
        out.write("TRANSFORMS=flowCore::arcsinhTransform(a=0, b=" + nf.format(1.0 / (double)this.getArcsinh()) + ")\n");
        switch (this.getDownsampleKind()) {
            case PERCENTILE: {
                out.write("DOWNSAMPLED_EVENTS=NULL\n");
                out.write("DOWNSAMPLING_TARGET_PCTILE=" + nf.format((double)this.getTargetDownsamplePctile() / 100.0) + "\n");
                break;
            }
            default: {
                out.write(String.format("DOWNSAMPLED_EVENTS=%d\n", this.getTargetDownsampleEvents()));
                out.write("DOWNSAMPLING_TARGET_PCTILE=NULL\n");
            }
        }
        out.write(String.format("TARGET_CLUSTERS=%d\n", this.getTargetClusters()));
        out.write("CLUSTERING_SAMPLES=50000\n");
        out.write("DOWNSAMPLING_EXCLUDE_PCTILE=0.01\n");
        out.write("NODE_SIZE_SCALE_FACTOR=1.2\n");
        out.write("NORMALIZE=\"global\"\n");
        out.write("OUTPUT_DIR=\"output/\"\n");
        out.write("#END AUTOGENERATED DATA\n");
        out.write("LIBRARY_PATH=NULL\nNUM_THREADS <- 1\nfor (e in commandArgs()) {\n\tta <- strsplit(e,\"=\",fixed=TRUE)\n\tif( ta[[1]][1] == \"-num_threads\") {\n\t\tNUM_THREADS <- ta[[1]][2]\n\t}\n\tif( ta[[1]][1] == \"-file_to_process\") {\n\t\tFILE_TO_PROCESS <- ta[[1]][2]\n\t}\n}\nSys.setenv(\"OMP_NUM_THREADS\"=NUM_THREADS)\nlibrary(\"spade\",lib.loc=LIBRARY_PATH)\nLAYOUT_FUNCTION=layout.kamada.kawai\nSPADE.driver(FILE_TO_PROCESS, file_pattern=\"*.fcs\", out_dir=OUTPUT_DIR, cluster_cols=CLUSTERING_MARKERS, panels=PANELS, transforms=TRANSFORMS, layout=LAYOUT_FUNCTION, downsampling_samples=DOWNSAMPLED_EVENTS, downsampling_target_pctile=DOWNSAMPLING_TARGET_PCTILE, downsampling_exclude_pctile=DOWNSAMPLING_EXCLUDE_PCTILE, k=TARGET_CLUSTERS, clustering_samples=CLUSTERING_SAMPLES)\nLAYOUT_TABLE <- read.table(paste(OUTPUT_DIR,\"layout.table\",sep=\"\"))\nMST_GRAPH <- read.graph(paste(OUTPUT_DIR,\"mst.gml\",sep=\"\"),format=\"gml\")\nSPADE.plot.trees(MST_GRAPH,OUTPUT_DIR,file_pattern=\"*fcs*Rsave\",layout=as.matrix(LAYOUT_TABLE),out_dir=paste(OUTPUT_DIR,\"pdf\",sep=\"\"),size_scale_factor=NODE_SIZE_SCALE_FACTOR)\nSys.unsetenv(\"OMP_NUM_THREADS\")\n");
        out.close();
    }

    public static String[] getAllMarkers(Object[] fcs_files) {
        HashSet<String> common_markers = null;
        for (Object f : fcs_files) {
            fcsFile fcs;
            try {
                fcs = new fcsFile(((File)f).getAbsolutePath(), false);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "Error: " + e);
                continue;
            }
            HashSet<String> file_markers = new HashSet<String>();
            for (int i = 0; i < fcs.getNumChannels(); ++i) {
                file_markers.add(SpadeContext.getFCSChannelFormattedName(fcs, i));
            }
            if (common_markers == null) {
                common_markers = file_markers;
                continue;
            }
            common_markers.addAll(file_markers);
        }
        Object[] markers = common_markers.toArray(new String[0]);
        Arrays.sort(markers);
        return markers;
    }

    public static String[] getCommonMarkers(Object[] fcs_files) {
        HashSet<String> common_markers = null;
        for (Object f : fcs_files) {
            fcsFile fcs;
            try {
                fcs = new fcsFile(((File)f).getAbsolutePath(), false);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "Error: " + e);
                continue;
            }
            HashSet<String> file_markers = new HashSet<String>();
            for (int i = 0; i < fcs.getNumChannels(); ++i) {
                file_markers.add(SpadeContext.getFCSChannelFormattedName(fcs, i));
            }
            if (common_markers == null) {
                common_markers = file_markers;
                continue;
            }
            common_markers.retainAll(file_markers);
        }
        Object[] markers = common_markers.toArray(new String[0]);
        Arrays.sort(markers);
        return markers;
    }

    public static String getFCSChannelFormattedName(fcsFile fcs, int channel_id) {
        String desc = fcs.getChannelName(channel_id);
        return fcs.getChannelShortName(channel_id) + (desc.isEmpty() ? "" : "::" + desc);
    }

    public static String getShortNameFromFormattedName(String name) {
        int divider = name.indexOf("::");
        return divider == -1 ? name : name.substring(0, divider);
    }

    private static String join(Iterable<? extends Object> pColl, String separator) {
        Iterator<? extends Object> oIter;
        if (pColl == null || !(oIter = pColl.iterator()).hasNext()) {
            return "";
        }
        StringBuilder oBuilder = new StringBuilder(String.valueOf(oIter.next()));
        while (oIter.hasNext()) {
            oBuilder.append(separator).append(oIter.next());
        }
        return oBuilder.toString();
    }

    public static class AnalysisPanel {
        public File[] panel_files;
        public Object[] median_markers;
        public File[] reference_files;
        public String[] fold_markers;

        public AnalysisPanel(Object[] panel_files) {
            this(panel_files, null, null, null);
        }

        public AnalysisPanel(Object[] panel_files, Object[] median_markers, Object[] reference_files, Object[] fold_markers) {
            int i;
            this.panel_files = new File[panel_files.length];
            for (i = 0; i < panel_files.length; ++i) {
                this.panel_files[i] = (File)panel_files[i];
            }
            if (median_markers == null) {
                this.median_markers = null;
            } else {
                this.median_markers = new File[median_markers.length];
                for (i = 0; i < panel_files.length; ++i) {
                    this.median_markers[i] = (File)median_markers[i];
                }
            }
            if (reference_files == null) {
                this.reference_files = new File[0];
            } else {
                this.reference_files = new File[reference_files.length];
                for (i = 0; i < reference_files.length; ++i) {
                    this.reference_files[i] = (File)reference_files[i];
                }
            }
            if (fold_markers == null) {
                this.fold_markers = new String[0];
            } else {
                this.fold_markers = new String[fold_markers.length];
                for (i = 0; i < fold_markers.length; ++i) {
                    this.fold_markers[i] = (String)fold_markers[i];
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SymmetryType {
        SYMMETRIC,
        ASYMMETRIC;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NormalizationKind {
        LOCAL,
        GLOBAL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DownsampleKind {
        EVENTS,
        PERCENTILE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WorkflowKind {
        PROCESSING,
        ANALYSIS;

    }
}

