/*
 * Decompiled with CFR 0.152.
 */
package cytospade;

import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.logger.CyLogger;
import cytospade.fcsFile;
import giny.model.GraphPerspective;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.stat.inference.TTestImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FCSOperations {
    private fcsFile fcsInputFile = null;
    private Array2DRowRealMatrix eventsInitl = null;
    private int numNodesSelected = 0;
    private Array2DRowRealMatrix eventsSlctd = null;

    public FCSOperations(File inputFile) throws FileNotFoundException, IOException {
        this(new fcsFile(inputFile, true));
    }

    public FCSOperations(fcsFile inputFile) {
        this.fcsInputFile = inputFile;
        this.eventsInitl = new Array2DRowRealMatrix(this.fcsInputFile.getCompensatedEventList());
    }

    public fcsFile getFCSFile() {
        return this.fcsInputFile;
    }

    public String getChannelShortName(int i) {
        return this.fcsInputFile.getChannelShortName(i);
    }

    public int getChannelCount() {
        return this.fcsInputFile.getChannelCount();
    }

    public int getEventCount() {
        return this.fcsInputFile.getEventCount();
    }

    public double[] getEvents(String channel) {
        return this.eventsInitl.getDataRef()[this.fcsInputFile.getChannelIdFromShortName(channel)];
    }

    public double getEventMax(String channel) {
        return this.fcsInputFile.getChannelRange(this.fcsInputFile.getChannelIdFromShortName(channel));
    }

    public void updateSelectedNodes() {
        int[] selectedClust = this.getSelectedNodes();
        this.numNodesSelected = selectedClust.length;
        this.eventsSlctd = this.numNodesSelected == 0 ? null : this.populateSelectedEvents(selectedClust);
    }

    public int getSelectedNodesCount() {
        return this.numNodesSelected;
    }

    public int getSelectedEventCount() {
        return this.eventsSlctd == null ? 0 : this.eventsSlctd.getColumnDimension();
    }

    public double[] getSelectedEvents(String channel) {
        return this.getSelectedNodesCount() > 0 ? this.eventsSlctd.getDataRef()[this.fcsInputFile.getChannelIdFromShortName(channel)] : new double[]{};
    }

    public List<AttributeValuePair> computeTStat() {
        ArrayList<AttributeValuePair> stats = new ArrayList<AttributeValuePair>();
        for (int i = 0; i < this.fcsInputFile.getNumChannels(); ++i) {
            String name = this.fcsInputFile.getChannelShortName(i);
            if (name.contentEquals("Time") || name.contentEquals("time") || name.contentEquals("cluster") || name.contentEquals("density")) continue;
            stats.add(new AttributeValuePair(name, this.tTest(this.eventsSlctd, this.eventsInitl, i)));
        }
        Collections.sort(stats);
        Collections.reverse(stats);
        return stats;
    }

    private int[] getSelectedNodes() {
        ArrayList<CyNode> selectedNodes = new ArrayList<CyNode>();
        CyNetwork currentNetwork = Cytoscape.getCurrentNetwork();
        for (CyNode node : currentNetwork.getSelectedNodes()) {
            GraphPerspective nestedNetwork = node.getNestedNetwork();
            if (nestedNetwork == null) {
                selectedNodes.add(node);
                continue;
            }
            selectedNodes.addAll(nestedNetwork.nodesList());
        }
        int[] selectedNodes_i = new int[selectedNodes.size()];
        for (int i = 0; i < selectedNodes.size(); ++i) {
            selectedNodes_i[i] = Integer.parseInt(((CyNode)selectedNodes.get(i)).getIdentifier()) + 1;
        }
        return selectedNodes_i;
    }

    private Array2DRowRealMatrix populateSelectedEvents(int[] selectedClust) {
        int clusterColumn = this.fcsInputFile.getChannelIdFromShortName("cluster");
        ArrayList<Integer> columns = new ArrayList<Integer>();
        for (int i = 0; i < this.eventsInitl.getColumnDimension(); ++i) {
            int cluster = (int)this.eventsInitl.getEntry(clusterColumn, i);
            for (int j = 0; j < selectedClust.length; ++j) {
                if (cluster != selectedClust[j]) continue;
                columns.add(i);
            }
        }
        int[] rows = new int[this.eventsInitl.getRowDimension()];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = i;
        }
        return (Array2DRowRealMatrix)this.eventsInitl.getSubMatrix(rows, ArrayUtils.toPrimitive((Integer[])columns.toArray(new Integer[0])));
    }

    private double tTest(Array2DRowRealMatrix selectedEvents, Array2DRowRealMatrix allEvents, int attribute) {
        TTestImpl tTest = new TTestImpl();
        try {
            return tTest.t(selectedEvents.getDataRef()[attribute], allEvents.getDataRef()[attribute]);
        }
        catch (IllegalArgumentException ex) {
            CyLogger.getLogger((String)FCSOperations.class.getName()).error(null, (Throwable)ex);
            return 0.0;
        }
    }

    public class nameValuePair
    implements Comparable {
        public double value;
        public String name;

        public nameValuePair(String name, double value) {
            this.name = name;
            this.value = value;
        }

        public int compareTo(Object t) {
            nameValuePair rhs = (nameValuePair)t;
            if (this.value < rhs.value) {
                return -1;
            }
            if (this.value > rhs.value) {
                return 1;
            }
            return 0;
        }
    }

    public class AttributeValuePair
    implements Comparable {
        public double value;
        public String attribute;

        public AttributeValuePair(String name, double value) {
            this.attribute = name;
            this.value = value;
        }

        public int compareTo(Object t) {
            AttributeValuePair rhs = (AttributeValuePair)t;
            if (Math.abs(this.value) < Math.abs(rhs.value)) {
                return -1;
            }
            if (Math.abs(this.value) > Math.abs(rhs.value)) {
                return 1;
            }
            return 0;
        }
    }
}

