/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.location;

import org.biojava3.core.sequence.location.template.Point;
import org.biojava3.core.util.Equals;
import org.biojava3.core.util.Hashcoder;

public class SimplePoint
implements Point {
    private int position;
    private boolean unknown;
    private boolean uncertain;

    protected SimplePoint() {
    }

    public SimplePoint(int position) {
        this.position = position;
    }

    public SimplePoint(int position, boolean unknown, boolean uncertain) {
        this.position = position;
        this.unknown = unknown;
        this.uncertain = uncertain;
    }

    @Override
    public Integer getPosition() {
        return this.position;
    }

    protected void setPosition(int position) {
        this.position = position;
    }

    @Override
    public boolean isUnknown() {
        return this.unknown;
    }

    protected void setUnknown(boolean unknown) {
        this.unknown = unknown;
    }

    @Override
    public boolean isUncertain() {
        return this.uncertain;
    }

    protected void setUncertain(boolean uncertain) {
        this.uncertain = uncertain;
    }

    @Override
    public Point reverse(int length) {
        int translatedPosition = this.reverse(this.getPosition(), length);
        return new SimplePoint(translatedPosition, this.isUnknown(), this.isUncertain());
    }

    @Override
    public Point offset(int distance) {
        int offsetPosition = this.getPosition() + distance;
        return new SimplePoint(offsetPosition, this.isUnknown(), this.isUncertain());
    }

    protected int reverse(int position, int length) {
        return length - position + 1;
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (Equals.classEqual(this, obj)) {
            SimplePoint p = (SimplePoint)obj;
            equals = Equals.equal(this.getPosition(), p.getPosition()) && Equals.equal(this.isUncertain(), p.isUncertain()) && Equals.equal(this.isUnknown(), p.isUnknown());
        }
        return equals;
    }

    public int hashCode() {
        int r = 9;
        r = Hashcoder.hash(r, this.getPosition());
        r = Hashcoder.hash(r, this.isUncertain());
        r = Hashcoder.hash(r, this.isUnknown());
        return r;
    }

    public String toString() {
        return Integer.toString(this.getPosition());
    }

    @Override
    public int compareTo(Point o) {
        return this.getPosition().compareTo(o.getPosition());
    }

    @Override
    public boolean isLower(Point point) {
        return this.compareTo(point) < 0;
    }

    @Override
    public boolean isHigher(Point point) {
        return this.compareTo(point) > 0;
    }

    @Override
    public Point clonePoint() {
        return this.offset(0);
    }
}

