/*
 * Decompiled with CFR 0.152.
 */
package de.proteinms.xtandemparser.xtandem;

import de.proteinms.xtandemparser.xtandem.Protein;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ProteinMap
implements Serializable {
    private HashMap<String, Protein> iProteinMap = null;

    public ProteinMap(ArrayList<String> aProteinIDList, HashMap aRawProteinMap) {
        if (aProteinIDList != null && aRawProteinMap != null) {
            this.initMap(aProteinIDList, aRawProteinMap);
        }
    }

    private void initMap(ArrayList<String> aProteinIDList, HashMap<String, String> aProteinMap) {
        this.iProteinMap = new HashMap();
        if (aProteinIDList != null) {
            Iterator<String> iter = aProteinIDList.iterator();
            while (iter.hasNext()) {
                Double expectValue;
                String proteinID = iter.next().toString();
                String proteinUID = aProteinMap.get("uid" + proteinID).toString();
                String proteinLabel = aProteinMap.get("label" + proteinID).toString();
                String proteinDescription = aProteinMap.get("description" + proteinID) != null ? aProteinMap.get("description" + proteinID).toString() : proteinLabel;
                try {
                    expectValue = Double.parseDouble(aProteinMap.get("expect" + proteinID).toString());
                }
                catch (NumberFormatException e) {
                    expectValue = null;
                }
                Double summedScore = Double.parseDouble(aProteinMap.get("sumI" + proteinID).toString());
                Protein protein = new Protein(proteinID, proteinUID, proteinLabel, proteinDescription, expectValue, summedScore);
                this.iProteinMap.put(proteinID, protein);
            }
        }
    }

    public Protein getProtein(String aProteinID) {
        if (this.iProteinMap != null) {
            return this.iProteinMap.get(aProteinID);
        }
        return null;
    }

    public Iterator getProteinIDIterator() {
        return this.iProteinMap.keySet().iterator();
    }
}

