/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io;

import com.compomics.util.protein.DualEnzyme;
import com.compomics.util.protein.Enzyme;
import com.compomics.util.protein.RegExEnzyme;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class MascotEnzymeReader {
    Logger logger = Logger.getLogger(MascotEnzymeReader.class);
    private HashMap iEnzymes = null;

    public MascotEnzymeReader(String aEnzymeFile) throws IOException {
        this(new FileInputStream(aEnzymeFile));
    }

    public MascotEnzymeReader(InputStream aEnzymeStream) throws IOException {
        try {
            InputStream in = aEnzymeStream;
            BufferedReader lBr = new BufferedReader(new InputStreamReader(in));
            this.iEnzymes = this.readAllEntries(lBr);
            lBr.close();
            in.close();
        }
        catch (IOException ioe) {
            throw new IOException("Unable to load Mascot enzyme file from stream: " + ioe.getMessage());
        }
    }

    private HashMap readAllEntries(BufferedReader aBr) throws IOException {
        HashMap<String, Enzyme> entries = new HashMap<String, Enzyme>();
        String line = aBr.readLine();
        String title = null;
        String cleavage = null;
        String restrict = null;
        String position = null;
        while (line != null) {
            if ((line = line.trim()).equals("*") || line.equals("")) {
                if (line.equals("*") && cleavage != null && position != null) {
                    if (title.toLowerCase().startsWith("dual")) {
                        StringTokenizer st = new StringTokenizer(cleavage.toUpperCase(), "X");
                        if (st.countTokens() != 2) {
                            String error = null;
                            error = st.countTokens() > 2 ? " more than one " : "out the ";
                            this.logger.error("Dual enzyme detected (title starts with 'dual', regardless of case) but with" + error + "'X' separator between N-terminal cleavables and C-terminal cleavables.\nTreating it as a regular enzyme.");
                            entries.put(title, new Enzyme(title, cleavage, restrict, position));
                        } else {
                            String ntermCleavage = st.nextToken().trim();
                            String ctermCleavage = st.nextToken().trim();
                            entries.put(title, new DualEnzyme(title, ntermCleavage, ctermCleavage, restrict, position));
                        }
                    } else if (title.toLowerCase().startsWith("regex")) {
                        Pattern.compile(cleavage, 2);
                        entries.put(title, new RegExEnzyme(title, cleavage, restrict, position));
                    } else {
                        entries.put(title, new Enzyme(title, cleavage, restrict, position));
                    }
                    title = null;
                    cleavage = null;
                    restrict = null;
                    position = null;
                }
                line = aBr.readLine();
                continue;
            }
            String insensitive = line.toUpperCase();
            if (insensitive.indexOf("TITLE") >= 0) {
                int start = line.indexOf(":") + 1;
                title = line.substring(start).trim();
            } else if (insensitive.indexOf("CLEAVAGE") >= 0) {
                int start = line.indexOf(":") + 1;
                cleavage = line.substring(start).trim();
            } else if (insensitive.indexOf("RESTRICT") >= 0) {
                int start = line.indexOf(":") + 1;
                restrict = line.substring(start).trim();
            } else if (insensitive.indexOf("CTERM") >= 0) {
                position = "Cterm";
            } else if (insensitive.indexOf("NTERM") >= 0) {
                position = "Nterm";
            }
            line = aBr.readLine();
        }
        return entries;
    }

    public String[] getEnzymeNames() {
        Set s = this.iEnzymes.keySet();
        int liSize = s.size();
        String[] result = new String[liSize];
        s.toArray(result);
        return result;
    }

    public Enzyme getEnzyme(String aTitle) {
        Enzyme e = (Enzyme)this.iEnzymes.get(aTitle);
        Enzyme result = null;
        if (e != null) {
            result = (Enzyme)e.clone();
        }
        return result;
    }
}

