/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identifications.idfilereaders;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.PeptideAssumption;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.io.identifications.IdfileReader;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.experiment.refinementparameters.MsAmandaScore;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;

public class MsAmandaIdfileReader
extends ExperimentObject
implements IdfileReader {
    private String softwareName = "MS Amanda";
    private String softwareVersion = null;
    private File msAmandaCsvFile;

    public MsAmandaIdfileReader() {
    }

    public MsAmandaIdfileReader(File msAmandaCsvFile) throws FileNotFoundException, IOException {
        this(msAmandaCsvFile, null);
    }

    public MsAmandaIdfileReader(File msAmandaCsvFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException {
        this.msAmandaCsvFile = msAmandaCsvFile;
    }

    @Override
    public String getExtension() {
        return ".csv";
    }

    @Override
    public HashSet<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler) throws IOException, IllegalArgumentException, Exception {
        String line;
        HashSet<SpectrumMatch> foundPeptides = new HashSet<SpectrumMatch>();
        BufferedRandomAccessFile bufferedRandomAccessFile = new BufferedRandomAccessFile(this.msAmandaCsvFile, "r", 102400);
        if (waitingHandler != null) {
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(100);
        }
        long progressUnit = bufferedRandomAccessFile.length() / 100L;
        String headerString = bufferedRandomAccessFile.readLine();
        String[] headers = headerString.split("\t");
        int scanNumberIndex = -1;
        int titleIndex = -1;
        int sequenceIndex = -1;
        int modificationsIndex = -1;
        int proteinAccessionsIndex = -1;
        int amandaScoreIndex = -1;
        int rankIndex = -1;
        int mzIndex = -1;
        int chargeIndex = -1;
        int rtIndex = -1;
        int filenameIndex = -1;
        for (int i = 0; i < headers.length; ++i) {
            String header = headers[i];
            if (header.equalsIgnoreCase("Scan Number")) {
                scanNumberIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("Title")) {
                titleIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("Sequence")) {
                sequenceIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("Modifications")) {
                modificationsIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("Protein Accessions")) {
                proteinAccessionsIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("Amanda Score")) {
                amandaScoreIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("Rank")) {
                rankIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("m/z")) {
                mzIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("Charge")) {
                chargeIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("RT")) {
                rtIndex = i;
                continue;
            }
            if (!header.equalsIgnoreCase("Filename")) continue;
            filenameIndex = i;
        }
        if (scanNumberIndex == -1 || titleIndex == -1 || sequenceIndex == -1 || modificationsIndex == -1 || proteinAccessionsIndex == -1 || amandaScoreIndex == -1 || rankIndex == -1 || mzIndex == -1 || chargeIndex == -1 || filenameIndex == -1) {
            throw new IllegalArgumentException("Mandatory columns are missing in the MS Amanda csv file. Please check the file!");
        }
        String currentSpectrumTitle = null;
        SpectrumMatch currentMatch = null;
        while ((line = bufferedRandomAccessFile.readLine()) != null) {
            double msAmandaScore;
            String[] elements = line.split("\t");
            if (line.trim().isEmpty()) continue;
            String spectrumTitle = elements[titleIndex];
            String peptideSequence = elements[sequenceIndex].toUpperCase();
            String modifications = elements[modificationsIndex].trim();
            String scoreAsText = elements[amandaScoreIndex];
            try {
                msAmandaScore = Double.valueOf(scoreAsText);
            }
            catch (NumberFormatException e) {
                scoreAsText = scoreAsText.replaceAll("\\.", "");
                scoreAsText = scoreAsText.replaceAll(",", "\\.");
                msAmandaScore = Double.valueOf(scoreAsText);
            }
            double msAmandaEValue = Math.pow(10.0, -msAmandaScore);
            int rank = Integer.valueOf(elements[rankIndex]);
            int charge = Integer.valueOf(elements[chargeIndex]);
            String fileName = elements[filenameIndex];
            if (currentMatch == null || currentSpectrumTitle != null && !currentSpectrumTitle.equalsIgnoreCase(spectrumTitle)) {
                if (currentMatch != null) {
                    foundPeptides.add(currentMatch);
                }
                currentMatch = new SpectrumMatch(Spectrum.getSpectrumKey(fileName, spectrumTitle));
                currentSpectrumTitle = spectrumTitle;
            }
            ArrayList<ModificationMatch> utilitiesModifications = new ArrayList<ModificationMatch>();
            if (!modifications.isEmpty()) {
                String[] ptms;
                for (String ptm : ptms = modifications.split(";")) {
                    try {
                        String residue = ptm.substring(0, 1);
                        int location = Integer.parseInt(ptm.substring(1, ptm.indexOf("(")));
                        String rest = ptm.substring(ptm.indexOf("(") + 1, ptm.length() - 1).toLowerCase();
                        String[] details = rest.split("\\|");
                        String ptmName = details[0];
                        String ptmMass = details[1];
                        String ptmFixedStatus = details[2];
                        if (!ptmFixedStatus.equalsIgnoreCase("variable")) continue;
                        utilitiesModifications.add(new ModificationMatch(ptmMass + "@" + residue, true, location));
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Error parsing ptm: " + ptm + "!");
                    }
                }
            }
            Peptide peptide = new Peptide(peptideSequence, utilitiesModifications);
            Charge peptideCharge = new Charge(1, charge);
            PeptideAssumption peptideAssumption = new PeptideAssumption(peptide, rank, Advocate.msAmanda.getIndex(), peptideCharge, msAmandaEValue, Util.getFileName(this.msAmandaCsvFile));
            MsAmandaScore scoreParam = new MsAmandaScore(msAmandaScore);
            peptideAssumption.addUrParam(scoreParam);
            currentMatch.addHit(Advocate.msAmanda.getIndex(), peptideAssumption, true);
            if (waitingHandler == null || progressUnit == 0L) continue;
            waitingHandler.setSecondaryProgressCounter((int)(bufferedRandomAccessFile.getFilePointer() / progressUnit));
            if (!waitingHandler.isRunCanceled()) continue;
            bufferedRandomAccessFile.close();
            break;
        }
        if (currentMatch != null) {
            foundPeptides.add(currentMatch);
        }
        bufferedRandomAccessFile.close();
        return foundPeptides;
    }

    @Override
    public void close() throws IOException {
        this.msAmandaCsvFile = null;
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        ArrayList<String> versions = new ArrayList<String>();
        versions.add(this.softwareVersion);
        result.put(this.softwareName, versions);
        return result;
    }
}

