/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.ions;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.ions.ElementaryIon;
import com.compomics.util.pride.CvTerm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

public class ReporterIon
extends Ion {
    static final long serialVersionUID = 1109011048958734120L;
    private static HashMap<String, ReporterIon> implementedIons = new HashMap();
    public static final ReporterIon iTRAQ113 = new ReporterIon("iTRAQ113", 113.1075);
    public static final ReporterIon iTRAQ114 = new ReporterIon("iTRAQ114", 114.111);
    public static final ReporterIon iTRAQ115 = new ReporterIon("iTRAQ115", 115.1079);
    public static final ReporterIon iTRAQ116 = new ReporterIon("iTRAQ116", 116.1113);
    public static final ReporterIon iTRAQ117 = new ReporterIon("iTRAQ117", 117.11465);
    public static final ReporterIon iTRAQ118 = new ReporterIon("iTRAQ118", 118.1117);
    public static final ReporterIon iTRAQ119 = new ReporterIon("iTRAQ119", 119.115);
    public static final ReporterIon iTRAQ121 = new ReporterIon("iTRAQ121", 121.1217);
    public static final ReporterIon iTRAQ_145 = new ReporterIon("iTRAQ145", 145.1);
    public static final ReporterIon iTRAQ_305 = new ReporterIon("iTRAQ305", 305.2);
    public static final ReporterIon TMT126_old = new ReporterIon("TMT126", 126.127491);
    public static final ReporterIon TMT127_old = new ReporterIon("TMT127", 127.1308594);
    public static final ReporterIon TMT128_old = new ReporterIon("TMT128", 128.1341553);
    public static final ReporterIon TMT129_old = new ReporterIon("TMT129", 129.1375046);
    public static final ReporterIon TMT130_old = new ReporterIon("TMT130", 130.1408768);
    public static final ReporterIon TMT131_old = new ReporterIon("TMT131", 131.1444851);
    public static final ReporterIon TMT126_hcd = new ReporterIon("TMT126", 126.127726);
    public static final ReporterIon TMT126_etd = new ReporterIon("TMT114", 114.127725);
    public static final ReporterIon TMT127_hcd = new ReporterIon("TMT127", 127.124761);
    public static final ReporterIon TMT127_etd = new ReporterIon("TMT115", 115.12476);
    public static final ReporterIon TMT127N_hcd = new ReporterIon("TMT127N", 127.124761);
    public static final ReporterIon TMT127C_hcd = new ReporterIon("TMT127C", 127.131081);
    public static final ReporterIon TMT128_hcd = new ReporterIon("TMT128", 128.134433);
    public static final ReporterIon TMT128_etd = new ReporterIon("TMT116", 116.134433);
    public static final ReporterIon TMT128N_hcd = new ReporterIon("TMT128N", 128.128116);
    public static final ReporterIon TMT128C_hcd = new ReporterIon("TMT128C", 128.134436);
    public static final ReporterIon TMT129_hcd = new ReporterIon("TMT129", 129.131471);
    public static final ReporterIon TMT129_etd = new ReporterIon("TMT117", 117.131468);
    public static final ReporterIon TMT129N_hcd = new ReporterIon("TMT129N", 129.131471);
    public static final ReporterIon TMT129C_hcd = new ReporterIon("TMT129C", 129.13779);
    public static final ReporterIon TMT130_hcd = new ReporterIon("TMT130", 130.134825);
    public static final ReporterIon TMT130_etd = new ReporterIon("TMT118", 118.141141);
    public static final ReporterIon TMT130N_hcd = new ReporterIon("TMT130N", 130.134825);
    public static final ReporterIon TMT130C_hcd = new ReporterIon("TMT130C", 130.141145);
    public static final ReporterIon TMT131_hcd = new ReporterIon("TMT131", 131.13818);
    public static final ReporterIon TMT131_etd = new ReporterIon("TMT119", 119.138176);
    public static final ReporterIon TMT_230 = new ReporterIon("TMT230", 230.2);
    public static final ReporterIon TMT_226 = new ReporterIon("TMT226", 226.2);
    public static final ReporterIon ACE_K_126 = new ReporterIon("aceK126", 126.0);
    public static final ReporterIon ACE_K_143 = new ReporterIon("aceK143", 143.0);
    public static final ReporterIon PHOSPHO_Y = new ReporterIon("pY216", 216.0);
    private String name;

    public ReporterIon(String name, double mass) {
        this(name, mass, true);
    }

    public ReporterIon(String name, double mass, boolean save) {
        this.type = Ion.IonType.REPORTER_ION;
        this.name = name;
        this.theoreticMass = mass;
        if (save) {
            implementedIons.put(name, this);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMass(double referenceMass) {
        this.theoreticMass = referenceMass;
    }

    @Override
    public CvTerm getPrideCvTerm() {
        return null;
    }

    public boolean isSameAs(ReporterIon anotherReporterIon) {
        return this.theoreticMass == anotherReporterIon.getTheoreticMass();
    }

    public int getIndex() {
        return (int)this.getTheoreticMass();
    }

    @Override
    public int getSubType() {
        ArrayList<String> ionList = new ArrayList<String>(ReporterIon.getImplementedIons());
        Collections.sort(ionList);
        return ionList.indexOf(this.name);
    }

    @Override
    public String getSubTypeAsString() {
        return this.getName();
    }

    public static ReporterIon getReporterIon(int subType) {
        ArrayList<String> ionList = new ArrayList<String>(ReporterIon.getImplementedIons());
        Collections.sort(ionList);
        String name = ionList.get(subType);
        return ReporterIon.getReporterIon(name);
    }

    public static ReporterIon getReporterIon(String name) {
        return implementedIons.get(name);
    }

    public static Set<String> getImplementedIons() {
        return implementedIons.keySet();
    }

    public static ArrayList<Integer> getPossibleSubtypes() {
        ArrayList<Integer> possibleTypes = new ArrayList<Integer>(implementedIons.size());
        for (int i = 0; i < implementedIons.size(); ++i) {
            possibleTypes.add(i);
        }
        return possibleTypes;
    }

    @Override
    public ArrayList<NeutralLoss> getNeutralLosses() {
        return new ArrayList<NeutralLoss>();
    }

    @Override
    public boolean isSameAs(Ion anotherIon) {
        if (anotherIon instanceof ReporterIon) {
            ReporterIon otherIon = (ReporterIon)anotherIon;
            return this.isSameAs(otherIon);
        }
        return false;
    }

    @Override
    public double getTheoreticMass() {
        return this.theoreticMass - ElementaryIon.proton.getTheoreticMass();
    }
}

