/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.util.mascot.index;

import com.compomics.mascotdatfile.util.mascot.index.ByteOffset;
import com.compomics.mascotdatfile.util.mascot.index.FileIndexer;
import com.compomics.mascotdatfile.util.mascot.index.Reader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Controller {
    private static Logger logger = Logger.getLogger(Controller.class);
    private static String iSeparatorA = "=";
    private static String iSeparatorB = ":";
    private Reader iReader = null;
    private FileIndexer iIndex = new FileIndexer();

    public Controller(String aFileName) {
        this.iReader = new Reader(aFileName, this);
    }

    public Controller(File aFile) {
        this.iReader = new Reader(aFile, this);
    }

    public Controller(BufferedReader aBufferedReader) {
        this.iReader = new Reader(aBufferedReader, this);
    }

    protected void addLineIndex(int aLineNumber, long aByte) {
        this.iIndex.addLineIndex(aLineNumber, aByte);
    }

    protected void addPeptideLineIndex(Integer[] aPeptideNumbers) {
        this.iIndex.addPeptideLineIndex(aPeptideNumbers);
    }

    protected void addDecoyPeptideLineIndex(Integer[] aPeptideNumbers) {
        this.iIndex.addDecoyPeptideLineIndex(aPeptideNumbers);
    }

    protected void addSectionIndex(String aSectionName, ByteOffset aByteIndex) {
        this.iIndex.addSectionIndex(aSectionName, aByteIndex);
    }

    public String readSection(String aSection) {
        ByteOffset lIndex = this.iIndex.getSectionIndex(aSection);
        if (lIndex == null) {
            return null;
        }
        int lLength = Long.valueOf(lIndex.getStopByte() - lIndex.getStartByte()).intValue();
        return this.iReader.readInterval(lIndex.getStartByte(), lLength);
    }

    public HashMap readSectionAsHashMap(String aSection) {
        String s = this.readSection(aSection);
        if (s == null) {
            return null;
        }
        return this.processSectionToHashMap(this.readSection(aSection));
    }

    public String readPeptideHit(int aQueryNumber, int aPeptideHitNumber) {
        long lIndex = this.iIndex.getPeptideLineIndex(aQueryNumber, aPeptideHitNumber);
        if (lIndex != -1L) {
            String s = this.iReader.readLine(lIndex);
            return s.substring(s.indexOf(61) + 1);
        }
        return null;
    }

    public Vector<String> readPeptideHitBlock(int aQueryNumber, int aPetideHitNumber) {
        Vector<String> peptideHitBlock = new Vector<String>();
        peptideHitBlock.setSize(0);
        String peptideBlockPart = null;
        boolean continueReading = false;
        int counter = 0;
        long lIndex = this.iIndex.getPeptideLineIndex(aQueryNumber, aPetideHitNumber);
        if (lIndex != -1L) {
            String s = this.iReader.readLine(lIndex);
            peptideBlockPart = s.substring(0, s.indexOf(61));
            peptideHitBlock.add(s);
            counter = s.length() + this.iReader.getNewLineCharacterSize();
            continueReading = true;
            while (continueReading) {
                s = this.iReader.readLine(lIndex + (long)counter);
                if (!s.contains(peptideBlockPart)) {
                    continueReading = false;
                    continue;
                }
                peptideHitBlock.add(s);
                counter = counter + s.length() + this.iReader.getNewLineCharacterSize();
            }
        }
        return peptideHitBlock;
    }

    public String readDecoyPeptideHit(int aQueryNumber, int aPeptideHitNumber) {
        long lIndex = this.iIndex.getDecoyPeptideLineIndex(aQueryNumber, aPeptideHitNumber);
        if (lIndex != -1L) {
            String s = this.iReader.readLine(lIndex);
            return s.substring(s.indexOf(61) + 1);
        }
        return null;
    }

    public int getNumberOfQueries(int aQueryNumber) {
        return this.iIndex.getNumberOfPeptides(aQueryNumber);
    }

    public String readSummary(int aQueryNumber, int aSummaryIndex) {
        String s = this.iReader.readLine(this.iIndex.getSummaryLineIndex(aQueryNumber, aSummaryIndex));
        return s.substring(s.indexOf(61) + 1);
    }

    public String readDecoySummary(int aQueryNumber, int aSummaryIndex) {
        String s = this.iReader.readLine(this.iIndex.getDecoySummaryLineIndex(aQueryNumber, aSummaryIndex));
        return s.substring(s.indexOf(61) + 1);
    }

    private HashMap processSectionToHashMap(String aContent) {
        HashMap<String, String> lhmResult = new HashMap<String, String>();
        try {
            BufferedReader lbr = new BufferedReader(new StringReader(aContent));
            String line = null;
            while ((line = lbr.readLine()) != null) {
                String key = null;
                String value = null;
                if (line.equals("")) continue;
                if (line.startsWith("h") && line.indexOf("_text=") >= 0 || line.startsWith("\"") && line.endsWith("\"")) {
                    key = line.substring(0, line.indexOf("=")).trim();
                    if (line.length() > line.indexOf("=") + 1) {
                        value = line.substring(line.indexOf("=") + 1).trim();
                    }
                } else {
                    String sep = this.analyseSeparator(line);
                    if (sep != null) {
                        StringTokenizer lst = new StringTokenizer(line, sep);
                        key = lst.nextToken().trim();
                        value = null;
                        if (lst.hasMoreTokens()) {
                            value = lst.nextToken().trim();
                        }
                    }
                }
                lhmResult.put(key, value);
            }
            lbr.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return lhmResult;
    }

    private String analyseSeparator(String aLine) {
        if (aLine.indexOf(iSeparatorA) > 0) {
            return iSeparatorA;
        }
        if (aLine.indexOf(iSeparatorB) > 0) {
            return iSeparatorB;
        }
        return null;
    }

    public int getNumberOfQueries() {
        return this.iIndex.getNumberOfQueries();
    }

    public void close() {
        try {
            this.iReader.close();
            Reader.cleanOldFiles();
        }
        catch (IOException e) {
            System.err.println("Failed to finish the Reader.");
            e.printStackTrace();
        }
    }

    public int getNumberOfPeptideHits(int aQueryNumber) {
        return this.iIndex.getNumberOfPeptides(aQueryNumber);
    }

    public int getNumberOfDecoyPeptideHits(int aQueryNumber) {
        return this.iIndex.getNumberOfDecoyPeptides(aQueryNumber);
    }

    public String toString() {
        return "Controller{iReader=" + this.iReader + ", iIndex=" + this.iIndex + '}';
    }
}

