/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.util.io;

import com.compomics.mascotdatfile.util.io.IndexElementExtension;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlElementExtension {
    private static Logger logger = Logger.getLogger(XmlElementExtension.class);
    public String iValue;
    public Vector<XmlElementExtension> iChildren = new Vector();
    public HashMap iAttributes = new HashMap();
    public String iTitle;
    public IndexElementExtension iIndexElementExtension;
    private boolean iChild;
    private boolean iParsed;
    private String iXmlString;

    public XmlElementExtension(String aXmlString, IndexElementExtension aIndexElementExtension, boolean aChild) {
        this.iIndexElementExtension = aIndexElementExtension;
        this.iChild = aChild;
        if (aChild) {
            this.iParsed = false;
            this.iXmlString = aXmlString;
        } else {
            this.parse(aXmlString);
            this.iParsed = true;
        }
    }

    public void parse(String lXmlString) {
        StringTokenizer lTok = new StringTokenizer(lXmlString, "\n");
        int lLineCounter = 0;
        int lLineNumber = lTok.countTokens();
        String lChildrenString = "";
        String lChildrenStopper = "";
        boolean lChildDetected = false;
        while (lTok.hasMoreElements()) {
            String lLine = (String)lTok.nextElement();
            lLine = lLine.trim();
            if (lLineCounter == 0) {
                boolean lTitleSetting = true;
                boolean lInAttributeKey = false;
                boolean lInAttributeValue = false;
                this.iTitle = "";
                String key = "";
                String value = "";
                for (int i = 1; i < lLine.length(); ++i) {
                    if (lTitleSetting) {
                        if (lLine.charAt(i) == ' ' || lLine.charAt(i) == '>') {
                            lTitleSetting = false;
                            lInAttributeKey = true;
                            continue;
                        }
                        this.iTitle = this.iTitle + lLine.charAt(i);
                        continue;
                    }
                    if (lInAttributeKey && lLine.charAt(i) != ' ') {
                        if (lLine.charAt(i) == '=') continue;
                        if (lLine.charAt(i) == '\"') {
                            lInAttributeKey = false;
                            lInAttributeValue = true;
                            continue;
                        }
                        key = key + lLine.charAt(i);
                        continue;
                    }
                    if (!lInAttributeValue) continue;
                    if (lLine.charAt(i) != '\"') {
                        value = value + lLine.charAt(i);
                        continue;
                    }
                    lInAttributeValue = false;
                    lInAttributeKey = true;
                    this.iAttributes.put(key, value);
                    key = "";
                    value = "";
                }
            } else if (lLineCounter + 1 != lLineNumber) {
                if (lLine.startsWith("<")) {
                    if (lChildDetected) {
                        if (lLine.indexOf(lChildrenStopper) > -1) {
                            this.iChildren.add(new XmlElementExtension(lChildrenString + "\r\n     " + lLine, this.iIndexElementExtension, true));
                            lChildDetected = false;
                        } else {
                            lChildrenString = lChildrenString + "\r\n     " + lLine;
                        }
                    } else {
                        int lStart = lLine.indexOf("<") + 1;
                        int lEnd = lLine.indexOf(" ", lStart);
                        if (lEnd == -1) {
                            lEnd = lLine.indexOf(">", lStart);
                        }
                        String lChildName = lLine.substring(lStart, lEnd);
                        if (lLine.endsWith("/>") || lLine.endsWith("/" + lChildName + ">")) {
                            this.iChildren.add(new XmlElementExtension(lLine, this.iIndexElementExtension, true));
                        } else {
                            lChildDetected = true;
                            lChildrenString = lLine;
                            lChildrenStopper = "</";
                            lChildrenStopper = lChildrenStopper + lChildName;
                        }
                    }
                } else {
                    this.iValue = lLine;
                }
            }
            ++lLineCounter;
        }
    }

    public String getValue() {
        if (!this.iParsed) {
            this.parse(this.iXmlString);
            this.iParsed = true;
            this.iXmlString = null;
        }
        return this.iValue;
    }

    public Vector<XmlElementExtension> getChildren() {
        if (!this.iParsed) {
            this.parse(this.iXmlString);
            this.iParsed = true;
            this.iXmlString = null;
        }
        return this.iChildren;
    }

    public String getAttribute(String aKey) {
        if (!this.iParsed) {
            this.parse(this.iXmlString);
            this.iParsed = true;
            this.iXmlString = null;
        }
        return (String)this.iAttributes.get(aKey);
    }

    public Vector<XmlElementExtension> getChildByTitle(String aTitle) {
        boolean lFindGrandChildren;
        String lTitleToFind;
        if (!this.iParsed) {
            this.parse(this.iXmlString);
            this.iParsed = true;
            this.iXmlString = null;
        }
        if (aTitle.indexOf("/") == -1) {
            lTitleToFind = aTitle;
            lFindGrandChildren = false;
        } else {
            lTitleToFind = aTitle.substring(0, aTitle.indexOf("/"));
            lFindGrandChildren = true;
        }
        Vector<XmlElementExtension> lChilds = new Vector<XmlElementExtension>();
        for (int i = 0; i < this.iChildren.size(); ++i) {
            if (!this.iChildren.get(i).getTitle().equalsIgnoreCase(lTitleToFind)) continue;
            if (lFindGrandChildren) {
                Vector<XmlElementExtension> lGrandChildren = this.iChildren.get(i).getChildByTitle(aTitle.substring(aTitle.indexOf("/") + 1));
                for (int j = 0; j < lGrandChildren.size(); ++j) {
                    lChilds.add(lGrandChildren.get(j));
                }
                continue;
            }
            lChilds.add(this.iChildren.get(i));
        }
        return lChilds;
    }

    public String getTitle() {
        if (!this.iParsed) {
            this.parse(this.iXmlString);
            this.iParsed = true;
            this.iXmlString = null;
        }
        return this.iTitle;
    }

    public IndexElementExtension getIndexElement() {
        return this.iIndexElementExtension;
    }

    public HashMap getAttributes() {
        return this.iAttributes;
    }
}

