/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.research.tool.spectrumviewer.spectrumviewer_model;

import com.compomics.mascotdatfile.util.interfaces.MascotDatfileInf;
import com.compomics.mascotdatfile.util.mascot.PeptideHit;
import com.compomics.mascotdatfile.util.mascot.Query;
import java.util.List;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class DatfileTreeModel
implements TreeModel {
    private static Logger logger = Logger.getLogger(DatfileTreeModel.class);
    private MascotDatfileInf iMascotDatfile = null;
    private String iRoot = null;
    private List iFilteredQueries = null;
    private double iFilterSettingThreshold = 0.05;

    public DatfileTreeModel(MascotDatfileInf aMascotDatfile, String aRoot) {
        this.iMascotDatfile = aMascotDatfile;
        this.iRoot = aRoot;
    }

    public Object getRoot() {
        return this.iRoot;
    }

    public Object getChild(Object parent, int index) {
        Object result = new Object();
        if (parent instanceof String) {
            if (this.iFilteredQueries == null) {
                this.CalculateFilteredQueries();
            }
            result = this.iFilteredQueries.get(index);
        } else if (parent instanceof Query) {
            int lQueryNumber = ((Query)parent).getQueryNumber();
            List<PeptideHit> lPeptidehits = this.iMascotDatfile.getQueryToPeptideMap().getPeptideHitsAboveIdentityThreshold(lQueryNumber, this.iFilterSettingThreshold);
            result = lPeptidehits.get(index);
        }
        return result;
    }

    public int getChildCount(Object parent) {
        int lChildCount = 0;
        if (parent instanceof String) {
            if (this.iFilteredQueries == null) {
                this.CalculateFilteredQueries();
            }
            lChildCount = this.iFilteredQueries.size();
        } else if (parent instanceof Query) {
            int lQueryNumber = ((Query)parent).getQueryNumber();
            List<PeptideHit> lPeptidehits = this.iMascotDatfile.getQueryToPeptideMap().getPeptideHitsAboveIdentityThreshold(lQueryNumber, this.iFilterSettingThreshold);
            lChildCount = lPeptidehits.size();
        }
        return lChildCount;
    }

    public boolean isLeaf(Object node) {
        boolean isLeaf = false;
        if (node instanceof PeptideHit) {
            isLeaf = true;
        }
        return isLeaf;
    }

    public int getIndexOfChild(Object parent, Object child) {
        int lChildCount = this.getChildCount(parent);
        int result = 0;
        for (int i = 0; i < lChildCount; ++i) {
            if (!this.getChild(parent, i).equals(child)) continue;
            result = i;
        }
        return result;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public void addTreeModelListener(TreeModelListener l) {
    }

    public void removeTreeModelListener(TreeModelListener l) {
    }

    public void setFilterSettingThreshold(double aFilterSettingThreshold) {
        this.iFilterSettingThreshold = aFilterSettingThreshold;
    }

    public double getFilterSettingThreshold() {
        return this.iFilterSettingThreshold;
    }

    public String getFilterSettingThresholdString() {
        return new Double((1.0 - this.iFilterSettingThreshold) * 100.0).intValue() + "%";
    }

    private List CalculateFilteredQueries() {
        this.iFilteredQueries = this.iMascotDatfile.getQueryToPeptideMap().getIdentifiedQueries(this.iFilterSettingThreshold, this.iMascotDatfile.getQueryList());
        return this.iFilteredQueries;
    }
}

