/*
 * Decompiled with CFR 0.152.
 */
package cn.bgi;

import java.io.File;
import java.io.FileInputStream;
import java.util.LinkedHashMap;
import org.biojava3.core.sequence.ProteinSequence;
import org.biojava3.core.sequence.compound.AminoAcidCompound;
import org.biojava3.core.sequence.features.FeatureInterface;
import org.biojava3.core.sequence.io.GenbankReaderHelper;

public class createSAVdb {
    public static void main(String[] args) throws Exception {
        String testfile = "E:\\work\\java\\git\\sapFinder\\sapFinder\\xushx\\human.protein.v139.gpff";
        createSAVdb.createSAPdbFromdbSNP(testfile);
    }

    public static void createSAPdbFromdbSNP(String inputfile) throws Exception {
        File proFile = new File(inputfile);
        LinkedHashMap<String, ProteinSequence> protSequences = GenbankReaderHelper.readGenbankProteinSequence(new FileInputStream(proFile));
        System.out.println(protSequences.size());
        for (ProteinSequence sequence : protSequences.values()) {
            System.out.println(sequence.getAccession());
            System.out.println(sequence.getDescription());
            System.out.println(((AminoAcidCompound)sequence.getAsList().get(0)).getDescription());
            int i = 0;
            while (i < sequence.getFeaturesByType("variation").size()) {
                FeatureInterface varset = sequence.getFeaturesByType("variation").get(i);
                System.out.println(varset.getLocations());
                System.out.println(varset.getDescription());
                ++i;
            }
            System.out.println(sequence.getSequenceAsString());
        }
    }

    public static void createSAPdbFromCOSMIC() {
    }

    public static void createSAPdbFromNGS(String vcf, String db, String outdir, String crap) {
    }

    public static String getSAVpepSeq(String proseq, int pos, char aa, int enzyme) {
        char[] aas = proseq.toCharArray();
        aas[pos] = aa;
        proseq = String.copyValueOf(aas);
        proseq = proseq.toUpperCase();
        int n1 = -1;
        int n2 = -1;
        if (enzyme == 1) {
            n1 = 0;
            int miss1 = 0;
            int i = pos - 1;
            while (i >= 0) {
                n1 = i;
                char a = proseq.charAt(i);
                if (a == 'K' || a == 'R') {
                    ++miss1;
                }
                if (miss1 >= 2) break;
                --i;
            }
            n2 = proseq.length() - 1;
            int miss2 = 0;
            int i2 = pos;
            while (i2 < proseq.length()) {
                n2 = i2;
                char a = proseq.charAt(i2);
                if (a == 'K' || a == 'R') {
                    ++miss2;
                }
                if (miss2 < 2) {
                    ++i2;
                    continue;
                }
                break;
            }
        } else {
            System.err.println("Currently, we can't handle the enzyme: " + enzyme + "!");
            System.exit(0);
        }
        String savPepSeq = proseq.substring(n1, ++n2);
        return savPepSeq;
    }
}

