/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Scanner;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class StringManipulationHelper {
    private static final String UNIX_NEWLINE = "\n";

    private StringManipulationHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream stream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line).append(UNIX_NEWLINE);
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public static boolean equalsToIgnoreEndline(String expected, String actual) {
        if (expected == null && actual == null) {
            return true;
        }
        if (expected != null ^ actual != null) {
            return false;
        }
        Scanner scanner1 = new Scanner(expected);
        Scanner scanner2 = new Scanner(actual);
        while (scanner1.hasNextLine()) {
            String line2;
            String line1 = scanner1.nextLine();
            if (line1.equals(line2 = scanner2.nextLine())) continue;
            return false;
        }
        return !scanner2.hasNextLine();
    }

    public static boolean equalsToXml(String expected, String actual) {
        Document expectedDocument = null;
        Document actualDocument = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            expectedDocument = documentBuilder.parse(new ByteArrayInputStream(expected.getBytes()));
            actualDocument = documentBuilder.parse(new ByteArrayInputStream(actual.getBytes()));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new RuntimeException("Couldn't Parse XML", e);
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new RuntimeException("Couldn't Parse XML", e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Couldn't Parse XML", e);
        }
        DocumentType doctype1 = expectedDocument.getDoctype();
        DocumentType doctype2 = actualDocument.getDoctype();
        if (doctype1 == null ^ doctype2 == null) {
            return false;
        }
        if (doctype1 != null) {
            NamedNodeMap expectedNotations = doctype1.getNotations();
            NamedNodeMap actualNotations = doctype2.getNotations();
            if (expectedNotations.getLength() == actualNotations.getLength()) {
                for (int i = 0; i < expectedNotations.getLength(); ++i) {
                    Node node = expectedNotations.item(i);
                    node.isEqualNode(null);
                }
            } else {
                return false;
            }
        }
        throw new UnsupportedOperationException("not yet implemented");
    }
}

