/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.matches;

import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.IdentificationMatch;
import com.compomics.util.experiment.identification.PeptideAssumption;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.TagAssumption;
import com.compomics.util.experiment.identification.protein_inference.proteintree.ProteinTree;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class SpectrumMatch
extends IdentificationMatch {
    static final long serialVersionUID = 3227760855215444318L;
    private String spectrumKey;
    private HashMap<Integer, HashMap<Double, ArrayList<PeptideAssumption>>> assumptions = new HashMap();
    private HashMap<Integer, HashMap<Double, ArrayList<SpectrumIdentificationAssumption>>> assumptionsMap = new HashMap();
    private HashMap<Integer, PeptideAssumption> firstHits = new HashMap();
    private HashMap<Integer, SpectrumIdentificationAssumption> firstHitsMap = new HashMap();
    private PeptideAssumption bestAssumption;
    private TagAssumption bestTagAsssumption;
    private ArrayList<Integer> advocates = new ArrayList();
    private Integer spectrumNumber = null;

    public SpectrumMatch() {
    }

    public SpectrumMatch(String spectrumKey, SpectrumIdentificationAssumption assumption) {
        int advocateId = assumption.getAdvocate();
        this.assumptionsMap.put(advocateId, new HashMap());
        this.assumptionsMap.get(advocateId).put(assumption.getScore(), new ArrayList());
        this.assumptionsMap.get(advocateId).get(assumption.getScore()).add(assumption);
        this.firstHitsMap.put(advocateId, assumption);
        this.advocates.add(advocateId);
        this.spectrumKey = spectrumKey;
    }

    public SpectrumMatch(String spectrumKey) {
        this.spectrumKey = spectrumKey;
    }

    public PeptideAssumption getBestPeptideAssumption() {
        return this.bestAssumption;
    }

    public void setBestPeptideAssumption(PeptideAssumption bestAssumption) {
        this.bestAssumption = bestAssumption;
    }

    public TagAssumption getBestTagAssumption() {
        return this.bestTagAsssumption;
    }

    public void setBestTagAssumption(TagAssumption bestTagAsssumption) {
        this.bestTagAsssumption = bestTagAsssumption;
    }

    @Override
    public String getKey() {
        return this.spectrumKey;
    }

    public HashMap<Double, ArrayList<SpectrumIdentificationAssumption>> getAllAssumptions(int advocateId) {
        if (this.assumptionsMap == null) {
            this.update();
        }
        return this.assumptionsMap.get(advocateId);
    }

    private void update() {
        this.assumptionsMap = new HashMap(this.assumptions.size());
        for (int advocate : this.assumptions.keySet()) {
            HashMap advocateMapping = new HashMap(this.assumptions.get(advocate).size());
            for (double score : this.assumptions.get(advocate).keySet()) {
                advocateMapping.put(score, new ArrayList(this.assumptions.get(advocate).get(score)));
            }
            this.assumptionsMap.put(advocate, advocateMapping);
        }
        this.firstHitsMap = new HashMap<Integer, PeptideAssumption>(this.firstHits);
    }

    public ArrayList<SpectrumIdentificationAssumption> getAllAssumptions() {
        if (this.assumptionsMap == null) {
            this.update();
        }
        ArrayList<SpectrumIdentificationAssumption> result = new ArrayList<SpectrumIdentificationAssumption>();
        for (HashMap<Double, ArrayList<SpectrumIdentificationAssumption>> seMap : this.assumptionsMap.values()) {
            for (double eValue : seMap.keySet()) {
                result.addAll((Collection<SpectrumIdentificationAssumption>)seMap.get(eValue));
            }
        }
        return result;
    }

    public void addHit(int otherAdvocateId, SpectrumIdentificationAssumption otherAssumption, boolean ascendingScore) {
        if (!this.firstHitsMap.containsKey(otherAdvocateId) || !ascendingScore && this.firstHitsMap.get(otherAdvocateId).getScore() > otherAssumption.getScore() || ascendingScore && this.firstHitsMap.get(otherAdvocateId).getScore() < otherAssumption.getScore()) {
            this.firstHitsMap.put(otherAdvocateId, otherAssumption);
        }
        if (!this.assumptionsMap.containsKey(otherAdvocateId)) {
            this.assumptionsMap.put(otherAdvocateId, new HashMap());
        }
        if (!this.assumptionsMap.get(otherAdvocateId).containsKey(otherAssumption.getScore())) {
            this.assumptionsMap.get(otherAdvocateId).put(otherAssumption.getScore(), new ArrayList());
        }
        this.assumptionsMap.get(otherAdvocateId).get(otherAssumption.getScore()).add(otherAssumption);
        if (!this.advocates.contains(otherAdvocateId)) {
            this.advocates.add(otherAdvocateId);
        }
    }

    public SpectrumIdentificationAssumption getFirstHit(int advocateId) {
        if (this.firstHitsMap == null) {
            this.update();
        }
        return this.firstHitsMap.get(advocateId);
    }

    public ArrayList<SpectrumIdentificationAssumption> getFirstHits(int advocateId) {
        HashMap<Double, ArrayList<SpectrumIdentificationAssumption>> advocateHitMap = this.assumptionsMap.get(advocateId);
        if (advocateHitMap != null) {
            ArrayList<Double> eValues = new ArrayList<Double>(advocateHitMap.keySet());
            double bestScore = Collections.min(eValues);
            return advocateHitMap.get(bestScore);
        }
        return new ArrayList<SpectrumIdentificationAssumption>();
    }

    public void setFirstHit(int advocateId, SpectrumIdentificationAssumption bestAssumption) {
        this.firstHitsMap.put(advocateId, bestAssumption);
    }

    public ArrayList<Integer> getAdvocates() {
        return this.advocates;
    }

    @Override
    public IdentificationMatch.MatchType getType() {
        return IdentificationMatch.MatchType.Spectrum;
    }

    public void setKey(String newKey) {
        this.spectrumKey = newKey;
    }

    public Integer getSpectrumNumber() {
        return this.spectrumNumber;
    }

    public void setSpectrumNumber(Integer spectrumNumber) {
        this.spectrumNumber = spectrumNumber;
    }

    public void removeAssumption(SpectrumIdentificationAssumption assumption) {
        ArrayList<Integer> seToRemove = new ArrayList<Integer>();
        for (int se : this.assumptionsMap.keySet()) {
            ArrayList<Double> eValueToRemove = new ArrayList<Double>();
            for (double eValue : this.assumptionsMap.get(se).keySet()) {
                this.assumptionsMap.get(se).get(eValue).remove(assumption);
                if (!this.assumptionsMap.get(se).get(eValue).isEmpty()) continue;
                eValueToRemove.add(eValue);
            }
            for (double eValue : eValueToRemove) {
                this.assumptionsMap.get(se).remove(eValue);
            }
            if (!this.assumptionsMap.get(se).isEmpty()) continue;
            seToRemove.add(se);
        }
        for (int se : seToRemove) {
            this.assumptionsMap.remove(se);
        }
    }

    public boolean hasAssumption() {
        if (this.assumptionsMap == null) {
            this.update();
        }
        for (int se : this.assumptionsMap.keySet()) {
            for (ArrayList<SpectrumIdentificationAssumption> assumptionsAtScore : this.assumptionsMap.get(se).values()) {
                if (assumptionsAtScore.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAssumption(int advocateId) {
        if (this.assumptionsMap == null) {
            this.update();
        }
        if (this.assumptionsMap.containsKey(advocateId)) {
            for (ArrayList<SpectrumIdentificationAssumption> assumptionsAtEvalue : this.assumptionsMap.get(advocateId).values()) {
                if (assumptionsAtEvalue.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public SpectrumMatch getPeptidesFromTags(ProteinTree proteinTree, AminoAcidPattern.MatchingType matchingType, Double massTolerance, boolean scoreInAscendingOrder, ArrayList<String> fixedModifications, ArrayList<String> variableModifications, boolean ascendingScore, boolean reportFixedPtms) throws IOException, InterruptedException, ClassNotFoundException, SQLException {
        SpectrumMatch spectrumMatch = new SpectrumMatch(this.spectrumKey);
        for (int advocateId : this.assumptionsMap.keySet()) {
            int rank = 1;
            ArrayList<Double> scores = new ArrayList<Double>(this.assumptionsMap.get(advocateId).keySet());
            if (scoreInAscendingOrder) {
                Collections.sort(scores);
            } else {
                Collections.sort(scores, Collections.reverseOrder());
            }
            for (double score : scores) {
                ArrayList<SpectrumIdentificationAssumption> originalAssumptions = this.assumptionsMap.get(advocateId).get(score);
                for (SpectrumIdentificationAssumption assumption : originalAssumptions) {
                    if (!(assumption instanceof TagAssumption)) continue;
                    TagAssumption tagAssumption = (TagAssumption)assumption;
                    HashMap<Peptide, HashMap<String, ArrayList<Integer>>> proteinMapping = proteinTree.getProteinMapping(tagAssumption.getTag(), matchingType, massTolerance, fixedModifications, variableModifications, true, reportFixedPtms);
                    for (Peptide peptide : proteinMapping.keySet()) {
                        PeptideAssumption peptideAssumption = new PeptideAssumption(peptide, rank, advocateId, assumption.getIdentificationCharge(), score, assumption.getIdentificationFile());
                        peptideAssumption.addUrParam(tagAssumption);
                        spectrumMatch.addHit(advocateId, peptideAssumption, ascendingScore);
                    }
                }
            }
        }
        return spectrumMatch;
    }
}

