/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software.autoupdater;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class MavenJarFile
extends JarFile {
    private Properties mavenProperties = new Properties();
    private String absoluteFilePath;
    private URI jarPath;

    public MavenJarFile(URI jarPath) throws IOException {
        super(new File(jarPath));
        this.jarPath = jarPath;
        this.absoluteFilePath = new File(jarPath).getAbsolutePath();
        Enumeration<JarEntry> entries = this.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().contains("pom.properties")) continue;
            this.mavenProperties.load(this.getInputStream(entry));
            break;
        }
    }

    public MavenJarFile(File aJarFile) throws IOException {
        this(aJarFile.toURI());
    }

    public String getArtifactId() {
        return this.mavenProperties.getProperty("artifactId");
    }

    public String getGroupId() {
        return this.mavenProperties.getProperty("groupId");
    }

    public String getVersionNumber() {
        return this.mavenProperties.getProperty("version");
    }

    public String getAbsoluteFilePath() {
        return this.absoluteFilePath;
    }

    public URI getJarPath() {
        return this.jarPath;
    }
}

