/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.util.mascot.index;

import com.compomics.mascotdatfile.util.interfaces.QueryToPeptideMapInf;
import com.compomics.mascotdatfile.util.mascot.ModificationList;
import com.compomics.mascotdatfile.util.mascot.PeptideHit;
import com.compomics.mascotdatfile.util.mascot.ProteinHit;
import com.compomics.mascotdatfile.util.mascot.ProteinMap;
import com.compomics.mascotdatfile.util.mascot.Query;
import com.compomics.mascotdatfile.util.mascot.index.Controller;
import com.compomics.mascotdatfile.util.mascot.index.SummaryIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryToPeptideMap_Index
implements QueryToPeptideMapInf {
    private static Logger logger = Logger.getLogger(QueryToPeptideMap_Index.class);
    protected Controller iController = null;
    protected ProteinMap iProteinMap = null;
    protected ModificationList iModificationList = null;
    private String lQMatchString;
    private String lQPlugholeString;

    public QueryToPeptideMap_Index(Controller aController, ProteinMap aProteinMap, ModificationList aModificationList) {
        this.iController = aController;
        this.iModificationList = aModificationList;
        this.iProteinMap = aProteinMap;
    }

    @Override
    public PeptideHit getPeptideHitOfOneQuery(int aQueryNumber, int aPeptideHitNumber) {
        this.lQMatchString = this.iController.readSummary(aQueryNumber, SummaryIndex.QMATCH);
        double lQmatch = Double.parseDouble(this.lQMatchString);
        this.lQPlugholeString = this.iController.readSummary(aQueryNumber, SummaryIndex.QPLUGHOLE);
        double lQplughole = Double.parseDouble(this.lQPlugholeString);
        Vector<String> peptideBlock = this.iController.readPeptideHitBlock(aQueryNumber, aPeptideHitNumber);
        if (!peptideBlock.isEmpty()) {
            String s = ((String)peptideBlock.get(0)).substring(((String)peptideBlock.get(0)).indexOf(61) + 1);
            String substitution = null;
            for (String blockPart : peptideBlock) {
                if (!blockPart.contains("subst")) continue;
                substitution = blockPart.substring(blockPart.indexOf(61) + 1);
            }
            return PeptideHit.parsePeptideHit(s, this.iProteinMap, this.iModificationList, new double[]{lQplughole, lQmatch}, substitution);
        }
        return null;
    }

    @Override
    public List<PeptideHit> getAllPeptideHits(int aQueryNumber) {
        ArrayList<PeptideHit> peptideHits = new ArrayList<PeptideHit>();
        int iNumberOfPeptideHits = this.getNumberOfPeptideHits(aQueryNumber);
        for (int i = 0; i < iNumberOfPeptideHits; ++i) {
            PeptideHit lPeptideHit = this.getPeptideHitOfOneQuery(aQueryNumber, i + 1);
            if (lPeptideHit == null) continue;
            peptideHits.add(lPeptideHit);
        }
        return peptideHits;
    }

    @Override
    public int getNumberOfPeptideHits(int aQueryNumber) {
        return this.iController.getNumberOfPeptideHits(aQueryNumber);
    }

    @Override
    public int getNumberOfQueries() {
        return this.iController.getNumberOfQueries();
    }

    @Override
    public List<PeptideHit> getBestPeptideHits() {
        return this.getPeptideHits(1);
    }

    @Override
    public List<PeptideHit> getPeptideHits(int aPeptideHitNumber) {
        int numberOfQueriesInMascotDatFile = this.iController.getNumberOfQueries();
        ArrayList<PeptideHit> lBestPeptideHits = new ArrayList<PeptideHit>(numberOfQueriesInMascotDatFile);
        for (int i = 1; i <= numberOfQueriesInMascotDatFile; ++i) {
            lBestPeptideHits.add(this.getPeptideHitOfOneQuery(i, aPeptideHitNumber));
        }
        return lBestPeptideHits;
    }

    @Override
    public PeptideHit getPeptideHitOfOneQuery(int aQueryNumber) throws IndexOutOfBoundsException {
        return this.getAllPeptideHits(aQueryNumber).get(0);
    }

    @Override
    public List<PeptideHit> getAllPeptideHitsAboveIdentityThreshold() {
        return this.getAllPeptideHitsAboveIdentityThreshold(0.05);
    }

    @Override
    public List<PeptideHit> getAllPeptideHitsAboveIdentityThreshold(double aConfidence) {
        List<PeptideHit> lAllBestPeptideHits = this.getBestPeptideHits();
        Iterator<PeptideHit> itr = lAllBestPeptideHits.iterator();
        while (itr.hasNext()) {
            PeptideHit peptideHit = itr.next();
            if (peptideHit != null) {
                if (peptideHit.scoresAboveIdentityThreshold(aConfidence)) continue;
                itr.remove();
                continue;
            }
            itr.remove();
        }
        return lAllBestPeptideHits;
    }

    @Override
    public List<PeptideHit> getPeptideHitsAboveIdentityThreshold(int aQueryNumber) {
        return this.getPeptideHitsAboveIdentityThreshold(aQueryNumber, 0.05);
    }

    @Override
    public List<PeptideHit> getPeptideHitsAboveIdentityThreshold(int aQueryNumber, double aConfidenceInterval) {
        List<PeptideHit> lPeptideHits = this.getAllPeptideHits(aQueryNumber);
        if (lPeptideHits != null) {
            Iterator<PeptideHit> itr = lPeptideHits.iterator();
            while (itr.hasNext()) {
                PeptideHit peptideHit = itr.next();
                if (peptideHit != null) {
                    if (peptideHit.scoresAboveIdentityThreshold(aConfidenceInterval)) continue;
                    itr.remove();
                    continue;
                }
                itr.remove();
            }
            return lPeptideHits;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getIdentifiedQueries(double aConfidence, List<Query> aCompleteQueryList) {
        ArrayList<Query> lIdentifiedQueries = new ArrayList<Query>();
        for (int i = 0; i < aCompleteQueryList.size(); ++i) {
            int lQueryNumber = i + 1;
            List<PeptideHit> lTempPeptideHits = this.getPeptideHitsAboveIdentityThreshold(lQueryNumber, aConfidence);
            if (lTempPeptideHits.size() <= 0) continue;
            lIdentifiedQueries.add(aCompleteQueryList.get(i));
        }
        return lIdentifiedQueries;
    }

    @Override
    public void buildProteinMap() {
        int numberOfQueriesInDatFile = this.iController.getNumberOfQueries();
        for (int i = 0; i < numberOfQueriesInDatFile; ++i) {
            int lQueryIndex = i + 1;
            List<PeptideHit> peptideHitsForQuery = this.getAllPeptideHits(lQueryIndex);
            for (int j = 0; j < peptideHitsForQuery.size(); ++j) {
                int lPeptideIndex = j + 1;
                PeptideHit lPeptideHit = peptideHitsForQuery.get(j);
                if (lPeptideHit == null) continue;
                int lNumberOfProteinHits = lPeptideHit.getProteinHits().size();
                for (int k = 0; k < lNumberOfProteinHits; ++k) {
                    ProteinHit lProteinHit = (ProteinHit)lPeptideHit.getProteinHits().get(k);
                    this.iProteinMap.addProteinSource(lProteinHit.getAccession(), lQueryIndex, lPeptideIndex);
                }
            }
        }
    }
}

