/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.util.mascot;

import com.compomics.mascotdatfile.util.exception.MascotDatfileException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ModificationConversion {
    private static Logger logger = Logger.getLogger(ModificationConversion.class);
    private static ModificationConversion singleton = null;
    private HashMap iConversionMap;
    private Connection iConnection;

    public static String getShortType(String aType) {
        String result = (String)ModificationConversion.getInstance().getConversionMap().get(aType);
        if (result == null) {
            result = "#" + aType + "#";
        }
        return result;
    }

    public static String getShortType(String aType, Connection iConnection) {
        String result = (String)ModificationConversion.getInstance(iConnection).getConversionMap().get(aType);
        if (result == null) {
            result = "#" + aType + "#";
        }
        return result;
    }

    public static ModificationConversion getInstance() {
        if (singleton == null) {
            singleton = new ModificationConversion();
        }
        return singleton;
    }

    public static ModificationConversion getInstance(Connection iConnection) {
        if (singleton == null) {
            singleton = new ModificationConversion(iConnection);
        }
        return singleton;
    }

    private ModificationConversion() {
    }

    private ModificationConversion(Connection iConnection) {
        this.iConnection = iConnection;
    }

    public HashMap getConversionMap() {
        if (this.iConversionMap == null && this.iConnection != null) {
            this.initModificationConversionMap(this.iConnection);
        } else if (this.iConversionMap == null) {
            this.initModificationConversionMap();
        }
        return this.iConversionMap;
    }

    private void initModificationConversionMap(Connection iConnection) {
        try {
            this.iConversionMap = new HashMap();
            String lKey = "";
            String lValue = "";
            PreparedStatement stat = iConnection.prepareStatement("select modification,conversion from modification_conversion");
            ResultSet rs = stat.executeQuery();
            while (rs.next()) {
                lKey = rs.getString("modification");
                lValue = rs.getString("conversion");
                this.iConversionMap.put(lKey, lValue);
            }
        }
        catch (SQLException sqle) {
            logger.error(sqle);
        }
    }

    private void initModificationConversionMap() {
        this.iConversionMap = new HashMap();
        try {
            BufferedReader lBuf = null;
            String path = "" + this.getClass().getProtectionDomain().getCodeSource().getLocation();
            path = path.substring(5, path.lastIndexOf("/"));
            if (path.endsWith("/lib")) {
                path = path.substring(0, path.length() - 4);
            }
            path = path + "/resources/modificationConversion.txt";
            File lFile = new File(path = path.replace("%20", " "));
            if (lFile.exists()) {
                lBuf = new BufferedReader(new InputStreamReader(new FileInputStream(lFile)));
                logger.debug("Using modificationConversion from disk (/resources/modificationConversion.txt)");
            } else {
                InputStream isRessource = ClassLoader.getSystemResourceAsStream("modificationConversion.txt");
                if (isRessource == null) {
                    isRessource = this.getClass().getClassLoader().getResourceAsStream("modificationConversion.txt");
                }
                lBuf = new BufferedReader(new InputStreamReader(isRessource));
            }
            if (lBuf == null) {
                throw new FileNotFoundException("Unable to load modifiactionConversion.txt file from the /resources/ directory or from the classpath!!");
            }
            String line = null;
            while ((line = lBuf.readLine()) != null) {
                char lIllegalChar;
                if (line.trim().startsWith("#") || line.trim().equals("")) continue;
                StringTokenizer lst = new StringTokenizer(line, "=");
                String lKey = lst.nextToken().trim();
                String lValue = lst.nextToken().trim();
                if (lValue.indexOf(lIllegalChar = '-') != -1) {
                    ModificationConversion.illegalShortName(lKey, lValue, lIllegalChar);
                }
                if (lValue.indexOf(lIllegalChar = '#') != -1) {
                    ModificationConversion.illegalShortName(lKey, lValue, lIllegalChar);
                }
                this.iConversionMap.put(lKey, lValue);
            }
            lBuf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MascotDatfileException("Unable to load file for modification conversion!\nThe file 'modificationConversion.txt' should be present in your classpath!");
        }
    }

    public void setModificationConversionMap(HashMap iConversionMap) {
        this.iConversionMap = iConversionMap;
    }

    private static void illegalShortName(String aKey, String aValue, char aIllegalCharacter) throws RuntimeException {
        throw new MascotDatfileException("Illegal character ' " + aIllegalCharacter + "' used in \"" + aValue + "\" for Mascot modification \"" + aKey + "\".\nPlease remove all illegal charaters ('" + aIllegalCharacter + "') in the short names from ModificationCoverion.txt");
    }
}

