/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.util;

import java.io.IOException;
import java.io.PushbackReader;
import psidev.psi.mi.xml.PsimiXmlVersion;

public class PsimiXmlVersionDetector {
    private static final String LEVEL_ATT = "level";
    private static final String VERSION_ATT = "version";
    private static final String MINOR_VERSION_ATT = "minorVersion";
    public static final int BUFFER_SIZE = 512;

    public PsimiXmlVersion detectVersion(PushbackReader reader) throws IOException {
        char[] buffer = new char[512];
        int c = reader.read(buffer, 0, 512);
        String sb = String.valueOf(buffer);
        String levelStr = this.readElementValue(sb, LEVEL_ATT);
        String versionStr = this.readElementValue(sb, VERSION_ATT);
        String minorVersionStr = this.readElementValue(sb, MINOR_VERSION_ATT);
        reader.unread(buffer, 0, c);
        if ("2".equals(levelStr) && "5".equals(versionStr)) {
            if ("3".equals(minorVersionStr)) {
                return PsimiXmlVersion.VERSION_253;
            }
            if ("4".equals(minorVersionStr)) {
                return PsimiXmlVersion.VERSION_254;
            }
            return PsimiXmlVersion.VERSION_25_UNDEFINED;
        }
        throw new IllegalArgumentException("Version not supported: Level=" + levelStr + " Version=" + versionStr + " MinorVersion=" + minorVersionStr);
    }

    public String detectNamespace(PushbackReader reader) throws IOException {
        char[] buffer = new char[512];
        int c = reader.read(buffer, 0, 512);
        String sb = String.valueOf(buffer);
        String namespace2 = this.readElementValue(sb, "xmlns");
        reader.unread(buffer, 0, c);
        return namespace2;
    }

    private String readElementValue(String sb, String elementName) {
        String value = null;
        if (sb.indexOf(elementName) > -1) {
            int verindex = sb.lastIndexOf(elementName + "=") + (elementName + "=\"").length();
            String textFromElement = sb.substring(verindex);
            value = textFromElement.substring(0, textFromElement.indexOf("\""));
        }
        return value;
    }
}

