/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.six;

import org.ivis.layout.LGraph;
import org.ivis.layout.LNode;
import org.ivis.layout.cise.CiSEEdge;
import org.ivis.layout.cise.CiSEGraphManager;
import org.ivis.layout.cise.CiSELayout;
import org.ivis.layout.cise.CiSENode;
import org.ivis.layout.six.SixCircularCircle;
import org.ivis.layout.six.SixCircularNode;

public class SixCircularLayout
extends CiSELayout {
    @Override
    public LGraph newGraph(Object vGraph) {
        return new SixCircularCircle(null, this.graphManager, vGraph);
    }

    @Override
    public LNode newNode(Object vNode) {
        return new SixCircularNode(this.graphManager, vNode);
    }

    @Override
    public void initParameters() {
        super.initParameters();
        if (!this.isSubLayout) {
            this.repulsionConstant *= 3.5;
        }
    }

    @Override
    public boolean layout() {
        if (!this.convertToClusteredGraph()) {
            return false;
        }
        this.graphManager.getRoot().calcEstimatedSize();
        this.doStep1();
        this.doStep2();
        this.doStep3();
        this.doStep4();
        return true;
    }

    @Override
    public void doStep3() {
        CiSEGraphManager gm = (CiSEGraphManager)this.getGraphManager();
        for (LNode node : gm.getRoot().getNodes()) {
            if (node.getChild() == null) continue;
            SixCircularCircle circle = (SixCircularCircle)node.getChild();
            circle.calculateOptimalOrientation();
        }
    }

    @Override
    public void doStep4() {
        this.initSpringEmbedder();
        this.runSpringEmbedder();
    }

    private void runSpringEmbedder() {
        this.totalDisplacement = 1000.0;
        this.totalIterations = 0;
        do {
            ++this.totalIterations;
            if (this.totalIterations % 100 == 0) {
                if (this.isConverged()) break;
                this.coolingFactor = this.initialCoolingFactor * ((double)(this.maxIterations - this.totalIterations) / (double)this.maxIterations);
            }
            this.totalDisplacement = 0.0;
            this.calcSpringForces();
            this.calcRepulsionForces();
            this.moveNodes();
            this.animate();
        } while (this.totalIterations < this.maxIterations);
    }

    @Override
    public void calcSpringForces() {
        Object[] lEdges = this.getAllEdges();
        for (int i = 0; i < lEdges.length; ++i) {
            CiSEEdge edge = (CiSEEdge)lEdges[i];
            this.calcSpringForce(edge, edge.idealLength);
        }
    }

    @Override
    public void calcRepulsionForces() {
        CiSENode[] lNodes = this.getOnCircleNodes();
        for (int i = 0; i < lNodes.length; ++i) {
            SixCircularNode nodeA = (SixCircularNode)lNodes[i];
            for (int j = i + 1; j < lNodes.length; ++j) {
                SixCircularNode nodeB = (SixCircularNode)lNodes[j];
                assert (nodeA.getOnCircleNodeExt() != null);
                assert (nodeB.getOnCircleNodeExt() != null);
                if (nodeA.getOwner() != nodeB.getOwner()) continue;
                this.calcRepulsionForce(nodeA, nodeB);
            }
        }
        assert (this.getInCircleNodes().length == 0);
    }

    @Override
    public void moveNodes() {
        CiSENode[] lNodes = this.getOnCircleNodes();
        for (int i = 0; i < lNodes.length; ++i) {
            SixCircularNode node = (SixCircularNode)lNodes[i];
            node.move();
        }
    }
}

