/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.avsdf;

import java.util.Iterator;
import java.util.Stack;
import org.ivis.layout.LGraph;
import org.ivis.layout.LGraphManager;
import org.ivis.layout.LNode;
import org.ivis.layout.avsdf.AVSDFNode;

public class AVSDFCircle
extends LGraph {
    private AVSDFNode[] inOrder;
    private int currentIndex = 0;
    private int nodeSeperation;
    private Stack<AVSDFNode> stack = new Stack();
    private double perimeter = 0.0;
    private double centerX = 0.0;
    private double centerY = 0.0;
    private double radius = 0.0;

    public AVSDFCircle(LNode parent, LGraphManager graphMgr, Object vObject) {
        super(parent, graphMgr, vObject);
    }

    public void initOrdering() {
        this.inOrder = new AVSDFNode[this.getNodes().size()];
    }

    public AVSDFNode[] getOrder() {
        return this.inOrder;
    }

    public double getCenterX() {
        return this.centerX;
    }

    public double getCenterY() {
        return this.centerY;
    }

    public double getRadius() {
        return this.radius;
    }

    public int getSize() {
        return this.getNodes().size();
    }

    public int getTotalCrossingOfCircle() {
        int crossingNumber = 0;
        for (int i = 0; i < this.inOrder.length; ++i) {
            int nodeCrossing = this.inOrder[i].getTotalCrossingOfEdges();
            if (nodeCrossing == -1) {
                return -1;
            }
            crossingNumber += nodeCrossing;
        }
        return crossingNumber / 4;
    }

    public boolean hasFinishedOrdering() {
        return this.currentIndex == this.getNodes().size();
    }

    public int getNodeSeperation() {
        return this.nodeSeperation;
    }

    public void setNodeSeperation(int nodeSeperation) {
        this.nodeSeperation = nodeSeperation;
    }

    public void correctAngles() {
        this.currentIndex = 0;
        for (int i = 0; i < this.inOrder.length; ++i) {
            this.putInOrder(this.inOrder[i]);
        }
    }

    public void putInOrder(AVSDFNode node) {
        assert (this.getNodes().contains(node)) : "The node must be a member of LGraph";
        this.inOrder[this.currentIndex] = node;
        node.setIndex(this.currentIndex);
        if (this.currentIndex == 0) {
            node.setAngle(0.0);
        } else {
            node.setAngle(this.inOrder[this.currentIndex - 1].getAngle() + Math.PI * 2 * (node.getHalfTheDiagonal() + (double)this.nodeSeperation + this.inOrder[this.currentIndex - 1].getHalfTheDiagonal()) / this.perimeter);
        }
        ++this.currentIndex;
    }

    public AVSDFNode findNodeToPlace() {
        AVSDFNode sDegreeNode = null;
        if (this.stack.empty()) {
            sDegreeNode = this.findUnorderedSmallestDegreeNode();
        } else {
            boolean foundUnorderNode = false;
            while (!foundUnorderNode && !this.stack.isEmpty()) {
                sDegreeNode = this.stack.pop();
                foundUnorderNode = !sDegreeNode.isOrdered();
            }
            if (!foundUnorderNode) {
                sDegreeNode = null;
            }
        }
        if (sDegreeNode == null) {
            sDegreeNode = this.findUnorderedSmallestDegreeNode();
        }
        if (sDegreeNode != null) {
            AVSDFNode[] neighbors = sDegreeNode.getNeigborsSortedByDegree();
            for (int i = neighbors.length - 1; i >= 0; --i) {
                if (neighbors[i].isOrdered()) continue;
                this.stack.push(neighbors[i]);
            }
        }
        return sDegreeNode;
    }

    public void calculateRadius() {
        double totalDiagonal = 0.0;
        for (LNode node : this.getNodes()) {
            double temp = node.getWidth() * node.getWidth() + node.getHeight() * node.getHeight();
            totalDiagonal += Math.sqrt(temp);
        }
        this.perimeter = totalDiagonal + (double)(this.getNodes().size() * this.nodeSeperation);
        double a = this.perimeter / (Math.PI * 2);
        this.getParent().setWidth(2.0 * a);
        this.getParent().setHeight(2.0 * a);
        this.getParent().setCenter(this.getParent().getWidth(), this.getParent().getHeight());
        this.centerX = this.getParent().getCenterX();
        this.centerY = this.getParent().getCenterY();
        this.radius = this.getParent().getHeight() / 2.0;
    }

    public void calculateEdgeCrossingsOfNodes() {
        for (AVSDFNode node : this.getNodes()) {
            node.calculateTotalCrossing();
        }
    }

    public void loadOldIndicesOfNodes() {
        for (int i = 0; i < this.getSize(); ++i) {
            this.inOrder[i].setIndex(i);
        }
    }

    public void reOrderVertices() {
        Iterator iter = this.getNodes().iterator();
        while (iter.hasNext()) {
            AVSDFNode node;
            this.inOrder[node.getIndex()] = node = (AVSDFNode)iter.next();
        }
    }

    private AVSDFNode findUnorderedSmallestDegreeNode() {
        int minDegree = Integer.MAX_VALUE;
        AVSDFNode sDegreeNode = null;
        for (AVSDFNode node : this.getNodes()) {
            if (node.getDegree() >= minDegree || node.isOrdered()) continue;
            minDegree = node.getDegree();
            sDegreeNode = node;
        }
        return sDegreeNode;
    }
}

