/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.query.algorithm;

import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.query.model.Edge;
import org.biopax.paxtools.query.model.GraphObject;
import org.biopax.paxtools.query.model.Node;

public class Prune {
    private Set<GraphObject> result;
    private Set<Node> ST;

    public Prune(Set<GraphObject> result, Set<Node> ST) {
        this.result = result;
        this.ST = ST;
    }

    public Set<GraphObject> run() {
        for (GraphObject go : new HashSet<GraphObject>(this.result)) {
            if (!(go instanceof Node)) continue;
            this.checkNodeRecursive((Node)go);
        }
        return this.result;
    }

    private void checkNodeRecursive(Node node) {
        if (this.isDangling(node)) {
            this.removeNode(node);
            for (Edge edge : node.getUpstream()) {
                this.checkNodeRecursive(edge.getSourceNode());
            }
            for (Edge edge : node.getDownstream()) {
                this.checkNodeRecursive(edge.getTargetNode());
            }
            for (Node parent : node.getUpperEquivalent()) {
                this.checkNodeRecursive(parent);
            }
            for (Node child : node.getLowerEquivalent()) {
                this.checkNodeRecursive(child);
            }
        }
    }

    private void removeNode(Node node) {
        this.result.remove(node);
        for (Edge edge : node.getUpstream()) {
            this.result.remove(edge);
        }
        for (Edge edge : node.getDownstream()) {
            this.result.remove(edge);
        }
    }

    private boolean isDangling(Node node) {
        if (!this.result.contains(node)) {
            return false;
        }
        if (this.ST.contains(node)) {
            return false;
        }
        boolean hasIncoming = false;
        for (Edge edge : node.getUpstream()) {
            if (!this.result.contains(edge)) continue;
            hasIncoming = true;
            break;
        }
        boolean hasOutgoing = false;
        for (Edge edge : node.getDownstream()) {
            if (!this.result.contains(edge)) continue;
            hasOutgoing = true;
            break;
        }
        if (hasIncoming && hasOutgoing) {
            return false;
        }
        boolean hasParent = false;
        for (Node parent : node.getUpperEquivalent()) {
            if (!this.result.contains(parent)) continue;
            hasParent = true;
            break;
        }
        if (hasParent && (hasIncoming || hasOutgoing)) {
            return false;
        }
        boolean hasChild = false;
        for (Node child : node.getLowerEquivalent()) {
            if (!this.result.contains(child)) continue;
            hasChild = true;
            break;
        }
        return !hasChild || !hasIncoming && !hasOutgoing && !hasParent;
    }
}

