/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level3;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.io.sif.level3.Group;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;

public class GroupMap {
    private Log log = LogFactory.getLog(GroupMap.class);
    private Map<BioPAXElement, Group> map;

    public GroupMap(Map<BioPAXElement, Group> element2GroupMap) {
        this.map = element2GroupMap;
    }

    protected BioPAXElement getEntityReferenceOrGroup(BioPAXElement bpe) {
        BioPAXElement entity2 = this.map.get(bpe);
        if (entity2 == null) {
            if (bpe instanceof EntityReference) {
                entity2 = bpe;
            } else if (bpe instanceof SimplePhysicalEntity) {
                EntityReference er = ((SimplePhysicalEntity)bpe).getEntityReference();
                if (er != null) {
                    entity2 = this.map.get(er);
                    if (entity2 == null) {
                        entity2 = er;
                    }
                } else if (this.log.isWarnEnabled()) {
                    this.log.warn("SimplePhysicalEntity with ID " + bpe.getRDFId() + " has NULL EntityReference");
                }
            }
        }
        return entity2;
    }

    public Map<BioPAXElement, Group> getMap() {
        return this.map;
    }
}

