/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level3;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.io.sif.level3.InteractionRuleL3Adaptor;
import org.biopax.paxtools.io.sif.level3.InteractionSetL3;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Controller;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Process;

public class ControlsTogetherRule
extends InteractionRuleL3Adaptor {
    private static List<BinaryInteractionType> binaryInteractionTypes = Arrays.asList(BinaryInteractionType.CO_CONTROL);
    Log log = LogFactory.getLog(ControlsTogetherRule.class);
    BioPAXElement current;

    @Override
    public void inferInteractionsFromPE(InteractionSetL3 l3, PhysicalEntity pe, Model model) {
        this.current = l3.getGroupMap().getEntityReferenceOrGroup(pe);
        if (this.current != null) {
            for (Interaction inter : pe.getParticipantOf()) {
                if (!(inter instanceof Control)) continue;
                Control ctrl = (Control)inter;
                this.iterateControllers(ctrl, l3);
                this.proceedUpwards(ctrl, l3);
                this.proceedDownwards(ctrl, l3);
            }
        } else if (this.log.isInfoEnabled()) {
            this.log.info("Null ER or Group. Skipping" + pe);
        }
    }

    private void proceedDownwards(Control ctrl, InteractionSetL3 interactionSet) {
        for (Process prcss : ctrl.getControlled()) {
            if (prcss instanceof Control) {
                this.searchDownwards((Control)prcss, interactionSet);
            }
            for (Control cnt : prcss.getControlledOf()) {
                if (cnt == ctrl) continue;
                this.searchUpwards(cnt, interactionSet);
            }
        }
    }

    private void searchDownwards(Control ctrl, InteractionSetL3 interactionSet) {
        this.iterateControllers(ctrl, interactionSet);
        this.proceedDownwards(ctrl, interactionSet);
    }

    private void searchUpwards(Control ctrl, InteractionSetL3 interactionSet) {
        this.iterateControllers(ctrl, interactionSet);
        this.proceedUpwards(ctrl, interactionSet);
    }

    private void iterateControllers(Control ctrl, InteractionSetL3 interactionSet) {
        for (Controller pe : ctrl.getController()) {
            BioPAXElement owner;
            if (!(pe instanceof PhysicalEntity) || this.current.equals(owner = interactionSet.getGroupMap().getEntityReferenceOrGroup(pe))) continue;
            this.createAndAdd(this.current, owner, interactionSet, BinaryInteractionType.CO_CONTROL, new BioPAXElement[0]);
        }
    }

    private void proceedUpwards(Control ctrl, InteractionSetL3 interactionSet) {
        for (Control cnt : ctrl.getControlledOf()) {
            this.searchUpwards(cnt, interactionSet);
        }
    }

    @Override
    public List<BinaryInteractionType> getRuleTypes() {
        return binaryInteractionTypes;
    }
}

