/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level2;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.io.sif.InteractionSet;
import org.biopax.paxtools.io.sif.MaximumInteractionThresholdExceedException;
import org.biopax.paxtools.io.sif.SimpleInteraction;
import org.biopax.paxtools.io.sif.level2.ComponentRule;
import org.biopax.paxtools.io.sif.level2.InteractionRuleL2Adaptor;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.InteractionParticipant;
import org.biopax.paxtools.model.level2.control;
import org.biopax.paxtools.model.level2.conversion;
import org.biopax.paxtools.model.level2.interaction;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;

public class ParticipatesRule
extends InteractionRuleL2Adaptor {
    private static List<BinaryInteractionType> binaryInteractionTypes = Arrays.asList(BinaryInteractionType.INTERACTS_WITH, BinaryInteractionType.REACTS_WITH);
    private long threshold;
    private static Log log = LogFactory.getLog(ComponentRule.class);
    boolean suppressExceptions = false;
    private boolean skipInteractions;
    private boolean skipConversions;

    public ParticipatesRule() {
        this(Integer.MAX_VALUE);
    }

    public ParticipatesRule(int threshold) {
        this(threshold, false);
    }

    public ParticipatesRule(int threshold, boolean suppressExceptions) {
        this.threshold = threshold;
        this.suppressExceptions = suppressExceptions;
    }

    @Override
    public void initOptionsNotNull(Map options) {
        this.skipConversions = options.containsKey((Object)BinaryInteractionType.REACTS_WITH) && options.get((Object)BinaryInteractionType.REACTS_WITH).equals(false);
        this.skipInteractions = options.containsKey((Object)BinaryInteractionType.INTERACTS_WITH) && options.get((Object)BinaryInteractionType.INTERACTS_WITH).equals(false);
    }

    @Override
    public void inferInteractionsFromPE(InteractionSet interactionSet, physicalEntity pe, Model model) {
        if (this.skipConversions && this.skipInteractions) {
            return;
        }
        Set<interaction> interactions = pe.getAllInteractions();
        for (interaction interaction2 : interactions) {
            BinaryInteractionType type;
            if (interaction2 instanceof control) continue;
            if (interaction2 instanceof conversion) {
                if (this.skipConversions) continue;
                type = BinaryInteractionType.REACTS_WITH;
            } else {
                if (this.skipInteractions) continue;
                type = BinaryInteractionType.INTERACTS_WITH;
            }
            Set<InteractionParticipant> ips = interaction2.getPARTICIPANTS();
            if ((long)ips.size() > this.threshold) {
                log.warn("The size of participants is too large! Skipping");
                if (this.suppressExceptions) {
                    return;
                }
                throw new MaximumInteractionThresholdExceedException(pe.toString());
            }
            for (InteractionParticipant ip : ips) {
                this.processParticipant(interactionSet, pe, ip, type, interaction2);
            }
        }
    }

    private void processParticipant(InteractionSet interactionSet, physicalEntity pe, InteractionParticipant ip, BinaryInteractionType type, interaction interaction2) {
        physicalEntity pe2 = null;
        if (ip instanceof physicalEntity) {
            pe2 = (physicalEntity)ip;
        } else if (ip instanceof physicalEntityParticipant) {
            pe2 = ((physicalEntityParticipant)ip).getPHYSICAL_ENTITY();
        }
        if (pe2 != null) {
            this.createInteraction(pe, pe2, interactionSet, type, interaction2);
        }
    }

    private void createInteraction(physicalEntity pe, physicalEntity pe2, InteractionSet set, BinaryInteractionType type, interaction interaction2) {
        if (!pe2.equals(pe)) {
            SimpleInteraction si = new SimpleInteraction(pe, pe2, type);
            si.addMediator(interaction2);
            set.add(si);
        }
    }

    @Override
    public List<BinaryInteractionType> getRuleTypes() {
        return binaryInteractionTypes;
    }
}

