/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level2;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.io.sif.InteractionSet;
import org.biopax.paxtools.io.sif.MaximumInteractionThresholdExceedException;
import org.biopax.paxtools.io.sif.SimpleInteraction;
import org.biopax.paxtools.io.sif.level2.InteractionRuleL2Adaptor;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.complex;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;

public class ComponentRule
extends InteractionRuleL2Adaptor {
    private static List<BinaryInteractionType> binaryInteractionTypes = Arrays.asList(BinaryInteractionType.COMPONENT_OF, BinaryInteractionType.IN_SAME_COMPONENT);
    private long threshold;
    private static Log log = LogFactory.getLog(ComponentRule.class);
    boolean suppressExceptions;
    private boolean componentOf;
    private boolean inSameComponent;

    public ComponentRule() {
        this(Integer.MAX_VALUE, false);
    }

    public ComponentRule(int threshold) {
        this(threshold, false);
    }

    public ComponentRule(int threshold, boolean suppressExceptions) {
        this.threshold = threshold;
        this.suppressExceptions = suppressExceptions;
    }

    @Override
    public void inferInteractionsFromPE(InteractionSet interactionSet, physicalEntity A, Model model) {
        if (!(A instanceof complex)) {
            for (physicalEntityParticipant pep : A.isPHYSICAL_ENTITYof()) {
                if (pep.isCOMPONENTof() == null) continue;
                complex comp = pep.isCOMPONENTof();
                this.processComplex(interactionSet, A, comp);
            }
        }
    }

    private void processComplex(InteractionSet interactionSet, physicalEntity A, complex comp) {
        if (this.componentOf) {
            SimpleInteraction si = new SimpleInteraction(A, comp, BinaryInteractionType.COMPONENT_OF);
            si.addMediator(comp);
            interactionSet.add(si);
        }
        boolean mostOuter = true;
        for (physicalEntityParticipant pep : comp.isPHYSICAL_ENTITYof()) {
            if (pep.isCOMPONENTof() == null) continue;
            complex outer = pep.isCOMPONENTof();
            mostOuter = false;
            this.processComplex(interactionSet, A, outer);
        }
        if (mostOuter && this.inSameComponent) {
            this.processComplexMembers(interactionSet, A, comp, 0);
        }
    }

    private void processComplexMembers(InteractionSet interactionSet, physicalEntity pe, complex comp, int size) {
        Set<physicalEntityParticipant> components = comp.getCOMPONENTS();
        if ((long)(size += components.size()) > this.threshold) {
            log.warn("This complex is too large. Skipping");
            if (this.suppressExceptions) {
                return;
            }
            throw new MaximumInteractionThresholdExceedException(pe.toString());
        }
        for (physicalEntityParticipant pep : components) {
            physicalEntity member = pep.getPHYSICAL_ENTITY();
            if (pe == member) continue;
            if (member instanceof complex) {
                this.processComplexMembers(interactionSet, pe, (complex)member, size);
                continue;
            }
            SimpleInteraction si = new SimpleInteraction(pe, member, BinaryInteractionType.IN_SAME_COMPONENT);
            si.addMediator(comp);
            interactionSet.add(si);
        }
    }

    @Override
    public List<BinaryInteractionType> getRuleTypes() {
        return binaryInteractionTypes;
    }

    @Override
    public void initOptionsNotNull(Map options) {
        this.componentOf = !options.containsKey((Object)BinaryInteractionType.COMPONENT_OF) || options.get((Object)BinaryInteractionType.COMPONENT_OF).equals(Boolean.TRUE);
        this.inSameComponent = !options.containsKey((Object)BinaryInteractionType.IN_SAME_COMPONENT) || options.get((Object)BinaryInteractionType.IN_SAME_COMPONENT).equals(Boolean.TRUE);
    }
}

