/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.biopax.paxtools.impl.level3.ChemicalStructureImpl;
import org.biopax.paxtools.impl.level3.EntityReferenceImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.ChemicalStructure;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Boost;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

@Entity
@Proxy(proxyClass=SmallMoleculeReference.class)
@Indexed
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class SmallMoleculeReferenceImpl
extends EntityReferenceImpl
implements SmallMoleculeReference {
    private String chemicalFormula;
    private float molecularWeight = UNKNOWN_FLOAT.floatValue();
    private ChemicalStructure structure;

    @Transient
    public Class<? extends SmallMoleculeReference> getModelInterface() {
        return SmallMoleculeReference.class;
    }

    @Override
    @Field(name="keyword", store=Store.YES, analyze=Analyze.YES)
    @Boost(value=1.1f)
    public String getChemicalFormula() {
        return this.chemicalFormula;
    }

    @Override
    public void setChemicalFormula(String formula) {
        this.chemicalFormula = formula;
    }

    @Override
    public float getMolecularWeight() {
        return this.molecularWeight;
    }

    @Override
    public void setMolecularWeight(float molecularWeight) {
        this.molecularWeight = molecularWeight;
    }

    @Override
    @ManyToOne(targetEntity=ChemicalStructureImpl.class)
    public ChemicalStructure getStructure() {
        return this.structure;
    }

    @Override
    public void setStructure(ChemicalStructure structure) {
        this.structure = structure;
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        if (!(element instanceof SmallMoleculeReference)) {
            return false;
        }
        SmallMoleculeReference that = (SmallMoleculeReference)element;
        return (this.getChemicalFormula() != null ? this.getChemicalFormula().equalsIgnoreCase(that.getChemicalFormula()) : that.getChemicalFormula() == null) && this.getMolecularWeight() == that.getMolecularWeight() && (this.getStructure() != null ? this.getStructure().isEquivalent(that.getStructure()) : that.getStructure() == null) && super.semanticallyEquivalent(element);
    }
}

