/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.biopax.paxtools.controller.AbstractTraverser;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.util.Filter;

public class Fetcher {
    private final EditorMap editorMap;
    private final Filter<PropertyEditor>[] filters;
    public static final Filter<PropertyEditor> nextStepFilter = new Filter<PropertyEditor>(){

        @Override
        public boolean filter(PropertyEditor editor) {
            return !editor.getProperty().equals("nextStep") && !editor.getProperty().equals("NEXT-STEP");
        }
    };
    public static final Filter<PropertyEditor> evidenceFilter = new Filter<PropertyEditor>(){

        @Override
        public boolean filter(PropertyEditor editor) {
            return !editor.getProperty().equals("evidence") && !editor.getProperty().equals("EVIDENCE");
        }
    };

    public Fetcher(EditorMap editorMap, Filter<PropertyEditor> ... filters) {
        this.editorMap = editorMap;
        this.filters = filters;
    }

    public void fetch(BioPAXElement element, Model model) {
        if (!model.containsID(element.getRDFId())) {
            model.add(element);
        }
        Set<BioPAXElement> children = this.fetch(element);
        for (BioPAXElement e2 : children) {
            if (!model.containsID(e2.getRDFId())) {
                model.add(e2);
                continue;
            }
            if (!model.contains(e2)) {
                throw new AssertionError((Object)("fetch(bioPAXElement, model): found different child objects with the same URI: " + e2.getRDFId() + "(replace/merge, or use fetch(bioPAXElement) instead!)"));
            }
        }
    }

    public Set<BioPAXElement> fetch(BioPAXElement element) {
        return this.fetch(element, -1);
    }

    public Set<BioPAXElement> fetch(BioPAXElement element, final int depth) {
        final HashSet<BioPAXElement> children = new HashSet<BioPAXElement>();
        AbstractTraverser traverser = new AbstractTraverser(this.editorMap, (Filter[])this.filters){

            protected void visit(Object range, BioPAXElement domain, Model model, PropertyEditor editor) {
                if (range instanceof BioPAXElement && !children.contains((BioPAXElement)range)) {
                    BioPAXElement bpe = (BioPAXElement)range;
                    children.add(bpe);
                    if (depth < 1 || depth > this.getVisited().size()) {
                        this.traverse(bpe, model);
                    }
                }
            }
        };
        traverser.traverse(element, null);
        return children;
    }

    public <T extends BioPAXElement> Set<T> fetch(BioPAXElement element, final Class<T> filterByType) {
        final HashSet children = new HashSet();
        AbstractTraverser traverser = new AbstractTraverser(this.editorMap, (Filter[])this.filters){

            protected void visit(Object range, BioPAXElement domain, Model model, PropertyEditor editor) {
                if (range instanceof BioPAXElement && !children.contains((BioPAXElement)range)) {
                    BioPAXElement bpe = (BioPAXElement)range;
                    if (filterByType.isInstance(bpe)) {
                        children.add(bpe);
                    }
                    this.traverse(bpe, model);
                }
            }
        };
        traverser.traverse(element, null);
        return children;
    }

    public boolean subgraphContains(BioPAXElement root, final String uri, Class<? extends BioPAXElement> type) {
        final AtomicBoolean found = new AtomicBoolean(false);
        AbstractTraverser traverser = new AbstractTraverser(this.editorMap, (Filter[])this.filters){

            protected void visit(Object range, BioPAXElement domain, Model model, PropertyEditor editor) {
                if (range instanceof BioPAXElement && !found.get()) {
                    if (((BioPAXElement)range).getRDFId().equals(uri)) {
                        found.set(true);
                    } else {
                        this.traverse((BioPAXElement)range, model);
                    }
                }
            }
        };
        traverser.traverse(root, null);
        return found.get();
    }
}

