/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.codenorm.Normalizer;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class UnicodeNormalizer
extends ProxyReceiver {
    private Normalizer normalizer;

    public UnicodeNormalizer(String string) throws XPathException {
        int n;
        if (string.equals("NFC")) {
            n = 2;
        } else if (string.equals("NFD")) {
            n = 0;
        } else if (string.equals("NFKC")) {
            n = 3;
        } else if (string.equals("NFKD")) {
            n = 1;
        } else {
            DynamicError dynamicError = new DynamicError("Unknown normalization form " + string);
            dynamicError.setErrorCode("SESU0011");
            throw dynamicError;
        }
        this.normalizer = new Normalizer((byte)n);
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n4, int n5) throws XPathException {
        super.attribute(n, n2, this.normalizer.normalize(charSequence), n4, n5);
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        if (Whitespace.isWhite(charSequence)) {
            super.characters(charSequence, n, n2);
        } else {
            super.characters(this.normalizer.normalize(charSequence), n, n2);
        }
    }
}

