/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUDebug;
import com.ibm.icu.impl.UCharacterProperty;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Replaceable;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeMatcher;
import java.util.ArrayList;

public final class Utility {
    private static final char APOSTROPHE = '\'';
    private static final char BACKSLASH = '\\';
    private static final int MAGIC_UNSIGNED = Integer.MIN_VALUE;
    private static final char ESCAPE = '\ua5a5';
    static final byte ESCAPE_BYTE = -91;
    public static String LINE_SEPARATOR = System.getProperty("line.separator");
    static final char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] UNESCAPE_MAP = new char[]{'a', '\u0007', 'b', '\b', 'e', '\u001b', 'f', '\f', 'n', '\n', 'r', '\r', 't', '\t', 'v', '\u000b'};
    static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public static final boolean arrayEquals(Object[] source, Object target) {
        if (source == null) {
            return target == null;
        }
        if (!(target instanceof Object[])) {
            return false;
        }
        Object[] targ = (Object[])target;
        return source.length == targ.length && Utility.arrayRegionMatches(source, 0, targ, 0, source.length);
    }

    public static final boolean arrayEquals(int[] source, Object target) {
        if (source == null) {
            return target == null;
        }
        if (!(target instanceof int[])) {
            return false;
        }
        int[] targ = (int[])target;
        return source.length == targ.length && Utility.arrayRegionMatches(source, 0, targ, 0, source.length);
    }

    public static final boolean arrayEquals(double[] source, Object target) {
        if (source == null) {
            return target == null;
        }
        if (!(target instanceof double[])) {
            return false;
        }
        double[] targ = (double[])target;
        return source.length == targ.length && Utility.arrayRegionMatches(source, 0, targ, 0, source.length);
    }

    public static final boolean arrayEquals(byte[] source, Object target) {
        if (source == null) {
            return target == null;
        }
        if (!(target instanceof byte[])) {
            return false;
        }
        byte[] targ = (byte[])target;
        return source.length == targ.length && Utility.arrayRegionMatches(source, 0, targ, 0, source.length);
    }

    public static final boolean arrayEquals(Object source, Object target) {
        if (source == null) {
            return target == null;
        }
        if (source instanceof Object[]) {
            return Utility.arrayEquals((Object[])source, target);
        }
        if (source instanceof int[]) {
            return Utility.arrayEquals((int[])source, target);
        }
        if (source instanceof double[]) {
            return Utility.arrayEquals((int[])source, target);
        }
        if (source instanceof byte[]) {
            return Utility.arrayEquals((byte[])source, target);
        }
        return source.equals(target);
    }

    public static final boolean arrayRegionMatches(Object[] source, int sourceStart, Object[] target, int targetStart, int len) {
        int sourceEnd = sourceStart + len;
        int delta = targetStart - sourceStart;
        for (int i = sourceStart; i < sourceEnd; ++i) {
            if (Utility.arrayEquals(source[i], target[i + delta])) continue;
            return false;
        }
        return true;
    }

    public static final boolean arrayRegionMatches(char[] source, int sourceStart, char[] target, int targetStart, int len) {
        int sourceEnd = sourceStart + len;
        int delta = targetStart - sourceStart;
        for (int i = sourceStart; i < sourceEnd; ++i) {
            if (source[i] == target[i + delta]) continue;
            return false;
        }
        return true;
    }

    public static final boolean arrayRegionMatches(int[] source, int sourceStart, int[] target, int targetStart, int len) {
        int sourceEnd = sourceStart + len;
        int delta = targetStart - sourceStart;
        for (int i = sourceStart; i < sourceEnd; ++i) {
            if (source[i] == target[i + delta]) continue;
            return false;
        }
        return true;
    }

    public static final boolean arrayRegionMatches(double[] source, int sourceStart, double[] target, int targetStart, int len) {
        int sourceEnd = sourceStart + len;
        int delta = targetStart - sourceStart;
        for (int i = sourceStart; i < sourceEnd; ++i) {
            if (source[i] == target[i + delta]) continue;
            return false;
        }
        return true;
    }

    public static final boolean arrayRegionMatches(byte[] source, int sourceStart, byte[] target, int targetStart, int len) {
        int sourceEnd = sourceStart + len;
        int delta = targetStart - sourceStart;
        for (int i = sourceStart; i < sourceEnd; ++i) {
            if (source[i] == target[i + delta]) continue;
            return false;
        }
        return true;
    }

    public static final boolean objectEquals(Object source, Object target) {
        if (source == null) {
            return target == null;
        }
        return source.equals(target);
    }

    public static final String arrayToRLEString(int[] a) {
        StringBuffer buffer = new StringBuffer();
        Utility.appendInt(buffer, a.length);
        int runValue = a[0];
        int runLength = 1;
        for (int i = 1; i < a.length; ++i) {
            int s = a[i];
            if (s == runValue && runLength < 65535) {
                ++runLength;
                continue;
            }
            Utility.encodeRun(buffer, runValue, runLength);
            runValue = s;
            runLength = 1;
        }
        Utility.encodeRun(buffer, runValue, runLength);
        return buffer.toString();
    }

    public static final String arrayToRLEString(short[] a) {
        StringBuffer buffer = new StringBuffer();
        buffer.append((char)(a.length >> 16));
        buffer.append((char)a.length);
        short runValue = a[0];
        int runLength = 1;
        for (int i = 1; i < a.length; ++i) {
            short s = a[i];
            if (s == runValue && runLength < 65535) {
                ++runLength;
                continue;
            }
            Utility.encodeRun(buffer, runValue, runLength);
            runValue = s;
            runLength = 1;
        }
        Utility.encodeRun(buffer, runValue, runLength);
        return buffer.toString();
    }

    public static final String arrayToRLEString(char[] a) {
        StringBuffer buffer = new StringBuffer();
        buffer.append((char)(a.length >> 16));
        buffer.append((char)a.length);
        char runValue = a[0];
        int runLength = 1;
        for (int i = 1; i < a.length; ++i) {
            char s = a[i];
            if (s == runValue && runLength < 65535) {
                ++runLength;
                continue;
            }
            Utility.encodeRun(buffer, (short)runValue, runLength);
            runValue = s;
            runLength = 1;
        }
        Utility.encodeRun(buffer, (short)runValue, runLength);
        return buffer.toString();
    }

    public static final String arrayToRLEString(byte[] a) {
        StringBuffer buffer = new StringBuffer();
        buffer.append((char)(a.length >> 16));
        buffer.append((char)a.length);
        byte runValue = a[0];
        int runLength = 1;
        byte[] state = new byte[2];
        for (int i = 1; i < a.length; ++i) {
            byte b = a[i];
            if (b == runValue && runLength < 255) {
                ++runLength;
                continue;
            }
            Utility.encodeRun(buffer, runValue, runLength, state);
            runValue = b;
            runLength = 1;
        }
        Utility.encodeRun(buffer, runValue, runLength, state);
        if (state[0] != 0) {
            Utility.appendEncodedByte(buffer, (byte)0, state);
        }
        return buffer.toString();
    }

    private static final void encodeRun(StringBuffer buffer, int value, int length) {
        if (length < 4) {
            for (int j = 0; j < length; ++j) {
                if (value == 42405) {
                    Utility.appendInt(buffer, value);
                }
                Utility.appendInt(buffer, value);
            }
        } else {
            if (length == 42405) {
                if (value == 42405) {
                    Utility.appendInt(buffer, 42405);
                }
                Utility.appendInt(buffer, value);
                --length;
            }
            Utility.appendInt(buffer, 42405);
            Utility.appendInt(buffer, length);
            Utility.appendInt(buffer, value);
        }
    }

    private static final void appendInt(StringBuffer buffer, int value) {
        buffer.append((char)(value >>> 16));
        buffer.append((char)(value & 0xFFFF));
    }

    private static final void encodeRun(StringBuffer buffer, short value, int length) {
        if (length < 4) {
            for (int j = 0; j < length; ++j) {
                if (value == 42405) {
                    buffer.append('\ua5a5');
                }
                buffer.append((char)value);
            }
        } else {
            if (length == 42405) {
                if (value == 42405) {
                    buffer.append('\ua5a5');
                }
                buffer.append((char)value);
                --length;
            }
            buffer.append('\ua5a5');
            buffer.append((char)length);
            buffer.append((char)value);
        }
    }

    private static final void encodeRun(StringBuffer buffer, byte value, int length, byte[] state) {
        if (length < 4) {
            for (int j = 0; j < length; ++j) {
                if (value == -91) {
                    Utility.appendEncodedByte(buffer, (byte)-91, state);
                }
                Utility.appendEncodedByte(buffer, value, state);
            }
        } else {
            if (length == -91) {
                if (value == -91) {
                    Utility.appendEncodedByte(buffer, (byte)-91, state);
                }
                Utility.appendEncodedByte(buffer, value, state);
                --length;
            }
            Utility.appendEncodedByte(buffer, (byte)-91, state);
            Utility.appendEncodedByte(buffer, (byte)length, state);
            Utility.appendEncodedByte(buffer, value, state);
        }
    }

    private static final void appendEncodedByte(StringBuffer buffer, byte value, byte[] state) {
        if (state[0] != 0) {
            char c = (char)(state[1] << 8 | value & 0xFF);
            buffer.append(c);
            state[0] = 0;
        } else {
            state[0] = 1;
            state[1] = value;
        }
    }

    public static final int[] RLEStringToIntArray(String s) {
        int length = Utility.getInt(s, 0);
        int[] array = new int[length];
        int ai = 0;
        int i = 1;
        int maxI = s.length() / 2;
        while (ai < length && i < maxI) {
            int c;
            if ((c = Utility.getInt(s, i++)) == 42405) {
                if ((c = Utility.getInt(s, i++)) == 42405) {
                    array[ai++] = c;
                    continue;
                }
                int runLength = c;
                int runValue = Utility.getInt(s, i++);
                for (int j = 0; j < runLength; ++j) {
                    array[ai++] = runValue;
                }
                continue;
            }
            array[ai++] = c;
        }
        if (ai != length || i != maxI) {
            throw new InternalError("Bad run-length encoded int array");
        }
        return array;
    }

    static final int getInt(String s, int i) {
        return s.charAt(2 * i) << 16 | s.charAt(2 * i + 1);
    }

    public static final short[] RLEStringToShortArray(String s) {
        int length = s.charAt(0) << 16 | s.charAt(1);
        short[] array = new short[length];
        int ai = 0;
        for (int i = 2; i < s.length(); ++i) {
            int c = s.charAt(i);
            if (c == 42405) {
                if ((c = s.charAt(++i)) == 42405) {
                    array[ai++] = (short)c;
                    continue;
                }
                int runLength = c;
                short runValue = (short)s.charAt(++i);
                for (int j = 0; j < runLength; ++j) {
                    array[ai++] = runValue;
                }
                continue;
            }
            array[ai++] = (short)c;
        }
        if (ai != length) {
            throw new InternalError("Bad run-length encoded short array");
        }
        return array;
    }

    public static final char[] RLEStringToCharArray(String s) {
        int length = s.charAt(0) << 16 | s.charAt(1);
        char[] array = new char[length];
        int ai = 0;
        for (int i = 2; i < s.length(); ++i) {
            int c = s.charAt(i);
            if (c == 42405) {
                if ((c = s.charAt(++i)) == 42405) {
                    array[ai++] = c;
                    continue;
                }
                int runLength = c;
                char runValue = s.charAt(++i);
                for (int j = 0; j < runLength; ++j) {
                    array[ai++] = runValue;
                }
                continue;
            }
            array[ai++] = c;
        }
        if (ai != length) {
            throw new InternalError("Bad run-length encoded short array");
        }
        return array;
    }

    public static final byte[] RLEStringToByteArray(String s) {
        int length = s.charAt(0) << 16 | s.charAt(1);
        byte[] array = new byte[length];
        boolean nextChar = true;
        int c = 0;
        int node = 0;
        int runLength = 0;
        int i = 2;
        int ai = 0;
        while (ai < length) {
            int b;
            if (nextChar) {
                c = s.charAt(i++);
                b = (byte)(c >> 8);
                nextChar = false;
            } else {
                b = c & 0xFF;
                nextChar = true;
            }
            switch (node) {
                case 0: {
                    if (b == -91) {
                        node = 1;
                        break;
                    }
                    array[ai++] = b;
                    break;
                }
                case 1: {
                    if (b == -91) {
                        array[ai++] = -91;
                        node = 0;
                        break;
                    }
                    runLength = b;
                    if (runLength < 0) {
                        runLength += 256;
                    }
                    node = 2;
                    break;
                }
                case 2: {
                    for (int j = 0; j < runLength; ++j) {
                        array[ai++] = b;
                    }
                    node = 0;
                }
            }
        }
        if (node != 0) {
            throw new InternalError("Bad run-length encoded byte array");
        }
        if (i != s.length()) {
            throw new InternalError("Excess data in RLE byte array string");
        }
        return array;
    }

    public static final String formatForSource(String s) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            if (i > 0) {
                buffer.append('+').append(LINE_SEPARATOR);
            }
            buffer.append("        \"");
            int count = 11;
            while (i < s.length() && count < 80) {
                char c;
                if ((c = s.charAt(i++)) < ' ' || c == '\"' || c == '\\') {
                    if (c == '\n') {
                        buffer.append("\\n");
                        count += 2;
                        continue;
                    }
                    if (c == '\t') {
                        buffer.append("\\t");
                        count += 2;
                        continue;
                    }
                    if (c == '\r') {
                        buffer.append("\\r");
                        count += 2;
                        continue;
                    }
                    buffer.append('\\');
                    buffer.append(HEX_DIGIT[(c & 0x1C0) >> 6]);
                    buffer.append(HEX_DIGIT[(c & 0x38) >> 3]);
                    buffer.append(HEX_DIGIT[c & 7]);
                    count += 4;
                    continue;
                }
                if (c <= '~') {
                    buffer.append(c);
                    ++count;
                    continue;
                }
                buffer.append("\\u");
                buffer.append(HEX_DIGIT[(c & 0xF000) >> 12]);
                buffer.append(HEX_DIGIT[(c & 0xF00) >> 8]);
                buffer.append(HEX_DIGIT[(c & 0xF0) >> 4]);
                buffer.append(HEX_DIGIT[c & 0xF]);
                count += 6;
            }
            buffer.append('\"');
        }
        return buffer.toString();
    }

    public static final String format1ForSource(String s) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\"");
        int i = 0;
        while (i < s.length()) {
            char c;
            if ((c = s.charAt(i++)) < ' ' || c == '\"' || c == '\\') {
                if (c == '\n') {
                    buffer.append("\\n");
                    continue;
                }
                if (c == '\t') {
                    buffer.append("\\t");
                    continue;
                }
                if (c == '\r') {
                    buffer.append("\\r");
                    continue;
                }
                buffer.append('\\');
                buffer.append(HEX_DIGIT[(c & 0x1C0) >> 6]);
                buffer.append(HEX_DIGIT[(c & 0x38) >> 3]);
                buffer.append(HEX_DIGIT[c & 7]);
                continue;
            }
            if (c <= '~') {
                buffer.append(c);
                continue;
            }
            buffer.append("\\u");
            buffer.append(HEX_DIGIT[(c & 0xF000) >> 12]);
            buffer.append(HEX_DIGIT[(c & 0xF00) >> 8]);
            buffer.append(HEX_DIGIT[(c & 0xF0) >> 4]);
            buffer.append(HEX_DIGIT[c & 0xF]);
        }
        buffer.append('\"');
        return buffer.toString();
    }

    public static final String escape(String s) {
        int c;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); i += UTF16.getCharCount(c)) {
            c = UTF16.charAt(s, i);
            if (c >= 32 && c <= 127) {
                if (c == 92) {
                    buf.append("\\\\");
                    continue;
                }
                buf.append((char)c);
                continue;
            }
            boolean four = c <= 65535;
            buf.append(four ? "\\u" : "\\U");
            Utility.hex(c, four ? 4 : 8, buf);
        }
        return buf.toString();
    }

    public static int unescapeAt(String s, int[] offset16) {
        int dig;
        int result = 0;
        int n = 0;
        int minDig = 0;
        int maxDig = 0;
        int bitsPerDigit = 4;
        boolean braces = false;
        int offset = offset16[0];
        int length = s.length();
        if (offset < 0 || offset >= length) {
            return -1;
        }
        int c = UTF16.charAt(s, offset);
        offset += UTF16.getCharCount(c);
        switch (c) {
            case 117: {
                maxDig = 4;
                minDig = 4;
                break;
            }
            case 85: {
                maxDig = 8;
                minDig = 8;
                break;
            }
            case 120: {
                minDig = 1;
                if (offset < length && UTF16.charAt(s, offset) == 123) {
                    ++offset;
                    braces = true;
                    maxDig = 8;
                    break;
                }
                maxDig = 2;
                break;
            }
            default: {
                dig = UCharacter.digit(c, 8);
                if (dig < 0) break;
                minDig = 1;
                maxDig = 3;
                n = 1;
                bitsPerDigit = 3;
                result = dig;
            }
        }
        if (minDig != 0) {
            while (offset < length && n < maxDig && (dig = UCharacter.digit(c = UTF16.charAt(s, offset), bitsPerDigit == 3 ? 8 : 16)) >= 0) {
                result = result << bitsPerDigit | dig;
                offset += UTF16.getCharCount(c);
                ++n;
            }
            if (n < minDig) {
                return -1;
            }
            if (braces) {
                if (c != 125) {
                    return -1;
                }
                ++offset;
            }
            if (result < 0 || result >= 0x110000) {
                return -1;
            }
            if (offset < length && UTF16.isLeadSurrogate((char)result)) {
                int ahead = offset + 1;
                c = s.charAt(offset);
                if (c == 92 && ahead < length) {
                    int[] o = new int[]{ahead};
                    c = Utility.unescapeAt(s, o);
                    ahead = o[0];
                }
                if (UTF16.isTrailSurrogate((char)c)) {
                    offset = ahead;
                    result = UCharacterProperty.getRawSupplementary((char)result, (char)c);
                }
            }
            offset16[0] = offset;
            return result;
        }
        for (int i = 0; i < UNESCAPE_MAP.length; i += 2) {
            if (c == UNESCAPE_MAP[i]) {
                offset16[0] = offset;
                return UNESCAPE_MAP[i + 1];
            }
            if (c < UNESCAPE_MAP[i]) break;
        }
        if (c == 99 && offset < length) {
            c = UTF16.charAt(s, offset);
            offset16[0] = offset + UTF16.getCharCount(c);
            return 0x1F & c;
        }
        offset16[0] = offset;
        return c;
    }

    public static String unescape(String s) {
        StringBuffer buf = new StringBuffer();
        int[] pos = new int[1];
        int i = 0;
        while (i < s.length()) {
            char c;
            if ((c = s.charAt(i++)) == '\\') {
                pos[0] = i;
                int e2 = Utility.unescapeAt(s, pos);
                if (e2 < 0) {
                    throw new IllegalArgumentException("Invalid escape sequence " + s.substring(i - 1, Math.min(i + 8, s.length())));
                }
                UTF16.append(buf, e2);
                i = pos[0];
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String unescapeLeniently(String s) {
        StringBuffer buf = new StringBuffer();
        int[] pos = new int[1];
        int i = 0;
        while (i < s.length()) {
            char c;
            if ((c = s.charAt(i++)) == '\\') {
                pos[0] = i;
                int e2 = Utility.unescapeAt(s, pos);
                if (e2 < 0) {
                    buf.append(c);
                    continue;
                }
                UTF16.append(buf, e2);
                i = pos[0];
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String hex(char ch) {
        StringBuffer temp = new StringBuffer();
        return Utility.hex(ch, temp).toString();
    }

    public static String hex(String s) {
        StringBuffer temp = new StringBuffer();
        return Utility.hex(s, temp).toString();
    }

    public static String hex(StringBuffer s) {
        return Utility.hex(s.toString());
    }

    public static StringBuffer hex(char ch, StringBuffer output) {
        return Utility.appendNumber(output, ch, 16, 4);
    }

    public static StringBuffer hex(int ch, int width, StringBuffer output) {
        return Utility.appendNumber(output, ch, 16, width);
    }

    public static String hex(int ch, int width) {
        StringBuffer buf = new StringBuffer();
        return Utility.appendNumber(buf, ch, 16, width).toString();
    }

    public static String hex(long i, int places) {
        String result;
        boolean negative;
        if (i == Long.MIN_VALUE) {
            return "-8000000000000000";
        }
        boolean bl = negative = i < 0L;
        if (negative) {
            i = -i;
        }
        if ((result = Long.toString(i, 16).toUpperCase()).length() < places) {
            result = "0000000000000000".substring(result.length(), places) + result;
        }
        if (negative) {
            return '-' + result;
        }
        return result;
    }

    public static String hex(long ch) {
        return Utility.hex(ch, 4);
    }

    public static StringBuffer hex(String s, StringBuffer result) {
        for (int i = 0; i < s.length(); ++i) {
            if (i != 0) {
                result.append(',');
            }
            Utility.hex(s.charAt(i), result);
        }
        return result;
    }

    public static void split(String s, char divider, String[] output) {
        int i;
        int last = 0;
        int current = 0;
        for (i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != divider) continue;
            output[current++] = s.substring(last, i);
            last = i + 1;
        }
        output[current++] = s.substring(last, i);
        while (current < output.length) {
            output[current++] = "";
        }
    }

    public static String[] split(String s, char divider) {
        int i;
        int last = 0;
        ArrayList<String> output = new ArrayList<String>();
        for (i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != divider) continue;
            output.add(s.substring(last, i));
            last = i + 1;
        }
        output.add(s.substring(last, i));
        return output.toArray(new String[output.size()]);
    }

    public static int lookup(String source, String[] target) {
        for (int i = 0; i < target.length; ++i) {
            if (!source.equals(target[i])) continue;
            return i;
        }
        return -1;
    }

    public static int skipWhitespace(String str2, int pos) {
        int c;
        while (pos < str2.length() && UCharacterProperty.isRuleWhiteSpace(c = UTF16.charAt(str2, pos))) {
            pos += UTF16.getCharCount(c);
        }
        return pos;
    }

    public static void skipWhitespace(String str2, int[] pos) {
        pos[0] = Utility.skipWhitespace(str2, pos[0]);
    }

    public static String deleteRuleWhiteSpace(String str2) {
        int ch;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < str2.length(); i += UTF16.getCharCount(ch)) {
            ch = UTF16.charAt(str2, i);
            if (UCharacterProperty.isRuleWhiteSpace(ch)) continue;
            UTF16.append(buf, ch);
        }
        return buf.toString();
    }

    public static boolean parseChar(String id, int[] pos, char ch) {
        int start = pos[0];
        Utility.skipWhitespace(id, pos);
        if (pos[0] == id.length() || id.charAt(pos[0]) != ch) {
            pos[0] = start;
            return false;
        }
        pos[0] = pos[0] + 1;
        return true;
    }

    public static int parsePattern(String rule, int pos, int limit, String pattern, int[] parsedInts) {
        int[] p = new int[1];
        int intCount = 0;
        block5: for (int i = 0; i < pattern.length(); ++i) {
            char cpat = pattern.charAt(i);
            switch (cpat) {
                case ' ': {
                    char c;
                    if (pos >= limit) {
                        return -1;
                    }
                    if (!UCharacterProperty.isRuleWhiteSpace(c = rule.charAt(pos++))) {
                        return -1;
                    }
                }
                case '~': {
                    pos = Utility.skipWhitespace(rule, pos);
                    continue block5;
                }
                case '#': {
                    p[0] = pos;
                    parsedInts[intCount++] = Utility.parseInteger(rule, p, limit);
                    if (p[0] == pos) {
                        return -1;
                    }
                    pos = p[0];
                    continue block5;
                }
                default: {
                    char c;
                    if (pos >= limit) {
                        return -1;
                    }
                    if ((c = (char)UCharacter.toLowerCase(rule.charAt(pos++))) == cpat) continue block5;
                    return -1;
                }
            }
        }
        return pos;
    }

    public static int parsePattern(String pat, Replaceable text, int index, int limit) {
        int ipat = 0;
        if (ipat == pat.length()) {
            return index;
        }
        int cpat = UTF16.charAt(pat, ipat);
        while (index < limit) {
            int c = text.char32At(index);
            if (cpat == 126) {
                if (UCharacterProperty.isRuleWhiteSpace(c)) {
                    index += UTF16.getCharCount(c);
                    continue;
                }
                if (++ipat == pat.length()) {
                    return index;
                }
            } else if (c == cpat) {
                int n = UTF16.getCharCount(c);
                index += n;
                if ((ipat += n) == pat.length()) {
                    return index;
                }
            } else {
                return -1;
            }
            cpat = UTF16.charAt(pat, ipat);
        }
        return -1;
    }

    public static int parseInteger(String rule, int[] pos, int limit) {
        int count = 0;
        int value = 0;
        int p = pos[0];
        int radix = 10;
        if (rule.regionMatches(true, p, "0x", 0, 2)) {
            p += 2;
            radix = 16;
        } else if (p < limit && rule.charAt(p) == '0') {
            ++p;
            count = 1;
            radix = 8;
        }
        while (p < limit) {
            int d;
            if ((d = UCharacter.digit(rule.charAt(p++), radix)) < 0) {
                --p;
                break;
            }
            ++count;
            int v = value * radix + d;
            if (v <= value) {
                return 0;
            }
            value = v;
        }
        if (count > 0) {
            pos[0] = p;
        }
        return value;
    }

    public static String parseUnicodeIdentifier(String str2, int[] pos) {
        int p;
        int ch;
        StringBuffer buf = new StringBuffer();
        for (p = pos[0]; p < str2.length(); p += UTF16.getCharCount(ch)) {
            ch = UTF16.charAt(str2, p);
            if (buf.length() == 0) {
                if (UCharacter.isUnicodeIdentifierStart(ch)) {
                    UTF16.append(buf, ch);
                    continue;
                }
                return null;
            }
            if (!UCharacter.isUnicodeIdentifierPart(ch)) break;
            UTF16.append(buf, ch);
        }
        pos[0] = p;
        return buf.toString();
    }

    public static StringBuffer trim(StringBuffer b) {
        int i;
        for (i = 0; i < b.length() && Character.isWhitespace(b.charAt(i)); ++i) {
        }
        b.delete(0, i);
        for (i = b.length() - 1; i >= 0 && Character.isWhitespace(b.charAt(i)); --i) {
        }
        return b.delete(i + 1, b.length());
    }

    public static StringBuffer appendNumber(StringBuffer result, int n) {
        return Utility.appendNumber(result, n, 10, 1);
    }

    private static void recursiveAppendNumber(StringBuffer result, int n, int radix, int minDigits) {
        int digit = n % radix;
        if (n >= radix || minDigits > 1) {
            Utility.recursiveAppendNumber(result, n / radix, radix, minDigits - 1);
        }
        result.append(DIGITS[digit]);
    }

    public static StringBuffer appendNumber(StringBuffer result, int n, int radix, int minDigits) throws IllegalArgumentException {
        if (radix < 2 || radix > 36) {
            throw new IllegalArgumentException("Illegal radix " + radix);
        }
        int abs2 = n;
        if (n < 0) {
            abs2 = -n;
            result.append("-");
        }
        Utility.recursiveAppendNumber(result, abs2, radix, minDigits);
        return result;
    }

    public static int parseNumber(String text, int[] pos, int radix) {
        int ch;
        int d;
        int p;
        int n = 0;
        for (p = pos[0]; p < text.length() && (d = UCharacter.digit(ch = UTF16.charAt(text, p), radix)) >= 0; ++p) {
            if ((n = radix * n + d) >= 0) continue;
            return -1;
        }
        if (p == pos[0]) {
            return -1;
        }
        pos[0] = p;
        return n;
    }

    public static boolean isUnprintable(int c) {
        return c < 32 || c > 126;
    }

    public static boolean escapeUnprintable(StringBuffer result, int c) {
        if (Utility.isUnprintable(c)) {
            result.append('\\');
            if ((c & 0xFFFF0000) != 0) {
                result.append('U');
                result.append(DIGITS[0xF & c >> 28]);
                result.append(DIGITS[0xF & c >> 24]);
                result.append(DIGITS[0xF & c >> 20]);
                result.append(DIGITS[0xF & c >> 16]);
            } else {
                result.append('u');
            }
            result.append(DIGITS[0xF & c >> 12]);
            result.append(DIGITS[0xF & c >> 8]);
            result.append(DIGITS[0xF & c >> 4]);
            result.append(DIGITS[0xF & c]);
            return true;
        }
        return false;
    }

    public static int quotedIndexOf(String text, int start, int limit, String setOfChars) {
        for (int i = start; i < limit; ++i) {
            char c = text.charAt(i);
            if (c == '\\') {
                ++i;
                continue;
            }
            if (c == '\'') {
                while (++i < limit && text.charAt(i) != '\'') {
                }
                continue;
            }
            if (setOfChars.indexOf(c) < 0) continue;
            return i;
        }
        return -1;
    }

    public static void getChars(StringBuffer src, int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin == srcEnd) {
            return;
        }
        src.getChars(srcBegin, srcEnd, dst, dstBegin);
    }

    public static void appendToRule(StringBuffer rule, int c, boolean isLiteral, boolean escapeUnprintable, StringBuffer quoteBuf) {
        if (isLiteral || escapeUnprintable && Utility.isUnprintable(c)) {
            if (quoteBuf.length() > 0) {
                while (quoteBuf.length() >= 2 && quoteBuf.charAt(0) == '\'' && quoteBuf.charAt(1) == '\'') {
                    rule.append('\\').append('\'');
                    quoteBuf.delete(0, 2);
                }
                int trailingCount = 0;
                while (quoteBuf.length() >= 2 && quoteBuf.charAt(quoteBuf.length() - 2) == '\'' && quoteBuf.charAt(quoteBuf.length() - 1) == '\'') {
                    quoteBuf.setLength(quoteBuf.length() - 2);
                    ++trailingCount;
                }
                if (quoteBuf.length() > 0) {
                    rule.append('\'');
                    if (ICUDebug.isJDK14OrHigher) {
                        rule.append(quoteBuf);
                    } else {
                        rule.append(quoteBuf.toString());
                    }
                    rule.append('\'');
                    quoteBuf.setLength(0);
                }
                while (trailingCount-- > 0) {
                    rule.append('\\').append('\'');
                }
            }
            if (c != -1) {
                if (c == 32) {
                    int len = rule.length();
                    if (len > 0 && rule.charAt(len - 1) != ' ') {
                        rule.append(' ');
                    }
                } else if (!escapeUnprintable || !Utility.escapeUnprintable(rule, c)) {
                    UTF16.append(rule, c);
                }
            }
        } else if (quoteBuf.length() == 0 && (c == 39 || c == 92)) {
            rule.append('\\').append((char)c);
        } else if (!(quoteBuf.length() <= 0 && (c < 33 || c > 126 || c >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122) && !UCharacterProperty.isRuleWhiteSpace(c))) {
            UTF16.append(quoteBuf, c);
            if (c == 39) {
                quoteBuf.append((char)c);
            }
        } else {
            UTF16.append(rule, c);
        }
    }

    public static void appendToRule(StringBuffer rule, String text, boolean isLiteral, boolean escapeUnprintable, StringBuffer quoteBuf) {
        for (int i = 0; i < text.length(); ++i) {
            Utility.appendToRule(rule, text.charAt(i), isLiteral, escapeUnprintable, quoteBuf);
        }
    }

    public static void appendToRule(StringBuffer rule, UnicodeMatcher matcher, boolean escapeUnprintable, StringBuffer quoteBuf) {
        if (matcher != null) {
            Utility.appendToRule(rule, matcher.toPattern(escapeUnprintable), true, escapeUnprintable, quoteBuf);
        }
    }

    public static final int compareUnsigned(int source, int target) {
        if ((source += Integer.MIN_VALUE) < (target += Integer.MIN_VALUE)) {
            return -1;
        }
        if (source > target) {
            return 1;
        }
        return 0;
    }

    public static final byte highBit(int n) {
        if (n <= 0) {
            return -1;
        }
        byte bit = 0;
        if (n >= 65536) {
            n >>= 16;
            bit = (byte)(bit + 16);
        }
        if (n >= 256) {
            n >>= 8;
            bit = (byte)(bit + 8);
        }
        if (n >= 16) {
            n >>= 4;
            bit = (byte)(bit + 4);
        }
        if (n >= 4) {
            n >>= 2;
            bit = (byte)(bit + 2);
        }
        if (n >= 2) {
            n >>= 1;
            bit = (byte)(bit + 1);
        }
        return bit;
    }

    public static String valueOf(int[] source) {
        StringBuffer result = new StringBuffer(source.length);
        for (int i = 0; i < source.length; ++i) {
            UTF16.append(result, source[i]);
        }
        return result.toString();
    }

    public static int indexOf(StringBuffer buf, String s) {
        return buf.indexOf(s);
    }

    public static int lastIndexOf(StringBuffer buf, String s) {
        return buf.lastIndexOf(s);
    }

    public static int indexOf(StringBuffer buf, String s, int i) {
        return buf.indexOf(s, i);
    }

    public static int lastIndexOf(StringBuffer buf, String s, int i) {
        return buf.lastIndexOf(s, i);
    }

    public static String replaceAll(String src, String target, String replacement) {
        return src.replaceAll(target, replacement);
    }
}

