/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.syntax;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.PathBlock;
import com.hp.hpl.jena.sparql.core.TriplePath;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementVisitor;
import com.hp.hpl.jena.sparql.syntax.TripleCollector;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;
import java.util.Iterator;

public class ElementPathBlock
extends Element
implements TripleCollector {
    private PathBlock pattern = new PathBlock();

    public boolean isEmpty() {
        return this.pattern.isEmpty();
    }

    public void addTriple(TriplePath tp) {
        this.pattern.add(tp);
    }

    public int mark() {
        return this.pattern.size();
    }

    public void addTriple(Triple t) {
        this.addTriplePath(new TriplePath(t));
    }

    public void addTriple(int index, Triple t) {
        this.addTriplePath(index, new TriplePath(t));
    }

    public void addTriplePath(TriplePath tPath) {
        this.pattern.add(tPath);
    }

    public void addTriplePath(int index, TriplePath tPath) {
        this.pattern.add(index, tPath);
    }

    public PathBlock getPattern() {
        return this.pattern;
    }

    public Iterator patternElts() {
        return this.pattern.iterator();
    }

    public int hashCode() {
        int calcHashCode = 161;
        return calcHashCode ^= this.pattern.hashCode();
    }

    public boolean equalTo(Element el2, NodeIsomorphismMap isoMap) {
        if (!(el2 instanceof ElementPathBlock)) {
            return false;
        }
        ElementPathBlock eg2 = (ElementPathBlock)el2;
        return this.pattern.equiv(eg2.pattern, isoMap);
    }

    public void visit(ElementVisitor v) {
        v.visit(this);
    }
}

