/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.optimizer.heuristic;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphStatisticsHandler;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.engine.optimizer.heuristic.HeuristicBasicPattern;
import com.hp.hpl.jena.sparql.engine.optimizer.heuristic.VariableCounting;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GraphStatisticsHeuristic
extends HeuristicBasicPattern {
    private int size = 0;
    private double minCost = -1.0;
    private GraphStatisticsHandler graphStatisticsHandler = null;
    private VariableCounting vc = new VariableCounting();
    private static Log log = LogFactory.getLog(GraphStatisticsHeuristic.class);

    public GraphStatisticsHeuristic(Graph graph) {
        if (graph == null) {
            log.debug("The graph statistics handler requires the model of the ontology (use variable counting instead)");
            return;
        }
        this.size = graph.size();
        this.minCost = 1.0 / (double)this.size;
        this.graphStatisticsHandler = graph.getStatisticsHandler();
    }

    public double getCost(Triple triple1) {
        if (this.graphStatisticsHandler == null) {
            return this.vc.getCost(triple1);
        }
        Node s = triple1.getSubject();
        Node p = triple1.getPredicate();
        Node o = triple1.getObject();
        double sc = new Double(this.graphStatisticsHandler.getStatistic(s, Node.ANY, Node.ANY)) / (double)this.size;
        double pc = new Double(this.graphStatisticsHandler.getStatistic(Node.ANY, p, Node.ANY)) / (double)this.size;
        double oc = new Double(this.graphStatisticsHandler.getStatistic(Node.ANY, Node.ANY, o)) / (double)this.size;
        log.debug("Cost: " + sc + ", " + s);
        log.debug("Cost: " + pc + ", " + p);
        log.debug("Cost: " + oc + ", " + o);
        if (sc == 0.0 || pc == 0.0 || oc == 0.0) {
            return 0.0;
        }
        double c = sc * pc * oc;
        if (c > this.minCost) {
            return c;
        }
        return this.minCost;
    }

    public double getCost(Triple triple1, Triple triple2) {
        return this.vc.getCost(triple1, triple2);
    }
}

