/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.Transformer;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpPath;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpService;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.Binding1;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.path.PathLib;
import java.util.ListIterator;

public class Substitute {
    public static Op substitute(Op op, Binding b) {
        if (b instanceof BindingRoot) {
            return op;
        }
        return Transformer.transform(new OpSubstituteWorker(b), op);
    }

    public static Op substitute(Op op, Var var, Node node) {
        Binding1 b = new Binding1(null, var, node);
        return Substitute.substitute(op, (Binding)b);
    }

    public static BasicPattern substitute(BasicPattern bgp, Binding binding) {
        if (binding instanceof BindingRoot) {
            return bgp;
        }
        BasicPattern bgp2 = new BasicPattern();
        ListIterator iter = bgp.iterator();
        while (iter.hasNext()) {
            Triple triple = (Triple)iter.next();
            Triple t = Substitute.substitute(triple, binding);
            bgp2.add(t);
        }
        return bgp2;
    }

    public static Triple substitute(Triple triple, Binding binding) {
        Node s = Substitute.substitute(triple.getSubject(), binding);
        Node p = Substitute.substitute(triple.getPredicate(), binding);
        Node o = Substitute.substitute(triple.getObject(), binding);
        Triple t = new Triple(s, p, o);
        return t;
    }

    public static Node substitute(Node n, Binding b) {
        return Var.lookup(b, n);
    }

    private static class OpSubstituteWorker
    extends TransformCopy {
        private Binding binding;

        public OpSubstituteWorker(Binding binding) {
            super(true);
            this.binding = binding;
        }

        public Op transform(OpBGP opBGP) {
            BasicPattern bgp = opBGP.getPattern();
            bgp = Substitute.substitute(bgp, this.binding);
            return new OpBGP(bgp);
        }

        public Op transform(OpQuadPattern quadPattern) {
            Node gNode = quadPattern.getGraphNode();
            Node g = Substitute.substitute(gNode, this.binding);
            BasicPattern triples = new BasicPattern();
            ListIterator iter = quadPattern.getBasicPattern().iterator();
            while (iter.hasNext()) {
                Triple triple = (Triple)iter.next();
                Node s = Substitute.substitute(triple.getSubject(), this.binding);
                Node p = Substitute.substitute(triple.getPredicate(), this.binding);
                Node o = Substitute.substitute(triple.getObject(), this.binding);
                Triple t = new Triple(s, p, o);
                triples.add(t);
            }
            return new OpQuadPattern(g, triples);
        }

        public Op transform(OpPath opPath) {
            return new OpPath(PathLib.substitute(opPath.getTriplePath(), this.binding));
        }

        public Op transform(OpFilter filter, Op op) {
            ExprList exprs = filter.getExprs().copySubstitute(this.binding, true);
            return OpFilter.filter(exprs, op);
        }

        public Op transform(OpGraph op, Op sub) {
            Node n = Substitute.substitute(op.getNode(), this.binding);
            return new OpGraph(n, sub);
        }

        public Op transform(OpService op, Op sub) {
            Node n = Substitute.substitute(op.getService(), this.binding);
            return new OpService(n, sub);
        }
    }
}

