/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.n3.IRIResolver;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.PrefixMapping2;

public class Prologue {
    protected boolean seenBaseURI = false;
    protected PrefixMapping prefixMap = null;
    protected IRIResolver resolver = null;

    public Prologue() {
        this.prefixMap = new PrefixMappingImpl();
    }

    public Prologue(PrefixMapping pmap) {
        this.prefixMap = pmap;
        this.resolver = null;
    }

    public Prologue(PrefixMapping pmap, String base) {
        this.prefixMap = pmap;
        this.setBaseURI(base);
    }

    public Prologue(PrefixMapping pmap, IRIResolver resolver) {
        this.prefixMap = pmap;
        this.resolver = resolver;
    }

    public Prologue(Prologue other) {
        this.prefixMap = other.prefixMap;
        this.resolver = other.resolver;
    }

    public Prologue copy() {
        PrefixMappingImpl prefixMap = new PrefixMappingImpl();
        prefixMap.setNsPrefixes(this.prefixMap);
        return new Prologue((PrefixMapping)prefixMap, this.resolver.getBaseIRI());
    }

    public void usePrologueFrom(Prologue other) {
        this.prefixMap = new PrefixMapping2(other.prefixMap);
        this.seenBaseURI = false;
        if (other.resolver != null) {
            this.resolver = new IRIResolver(other.resolver.getBaseIRI());
        }
    }

    public Prologue sub(PrefixMapping newMappings) {
        return this.sub(newMappings, null);
    }

    public Prologue sub(String base) {
        return this.sub(null, base);
    }

    public Prologue sub(PrefixMapping newMappings, String base) {
        PrefixMapping ext = this.getPrefixMapping();
        if (newMappings != null) {
            ext = new PrefixMapping2(ext, newMappings);
        }
        IRIResolver r = this.resolver;
        if (base != null) {
            r = new IRIResolver(base);
        }
        return new Prologue(ext, r);
    }

    public boolean explicitlySetBaseURI() {
        return this.seenBaseURI;
    }

    public String getBaseURI() {
        if (this.resolver == null) {
            return null;
        }
        return this.resolver.getBaseIRI();
    }

    public void setBaseURI(String baseURI) {
        this.seenBaseURI = true;
        this.resolver = new IRIResolver(baseURI);
    }

    public void setBaseURI(IRIResolver resolver) {
        this.seenBaseURI = true;
        this.resolver = resolver;
    }

    public void setPrefix(String prefix, String expansion) {
        try {
            this.prefixMap.setNsPrefix(prefix, expansion);
        }
        catch (PrefixMapping.IllegalPrefixException ex) {
            ALog.warn(this, "Illegal prefix mapping(ignored): " + prefix + "=>" + expansion);
        }
    }

    public PrefixMapping getPrefixMapping() {
        return this.prefixMap;
    }

    public void setPrefixMapping(PrefixMapping pmap) {
        this.prefixMap = pmap;
    }

    public String getPrefix(String prefix) {
        return this.prefixMap.getNsPrefixURI(prefix);
    }

    public IRIResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(IRIResolver resolver) {
        this.resolver = resolver;
    }

    public String expandQName(String qname) {
        return this.expandPrefixedName(qname);
    }

    public String expandPrefixedName(String qname) {
        String s = this.prefixMap.expandPrefix(qname);
        if (s.equals(qname)) {
            return null;
        }
        return s;
    }

    public String shortForm(String uri) {
        return this.prefixMap.shortForm(uri);
    }
}

