/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.Derivation;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.util.PrintUtil;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class RuleDerivation
implements Derivation {
    protected Rule rule;
    protected Triple conclusion;
    protected List matches;
    protected InfGraph infGraph;

    public RuleDerivation(Rule rule, Triple conclusion, List matches2, InfGraph infGraph) {
        this.rule = rule;
        this.conclusion = conclusion;
        this.matches = matches2;
        this.infGraph = infGraph;
    }

    public String toString() {
        if (this.rule == null) {
            return "DUMMY";
        }
        return "Rule " + this.rule.toShortString();
    }

    public void printTrace(PrintWriter out, boolean bindings) {
        this.printTrace(out, bindings, 0, new HashSet());
    }

    protected void printTrace(PrintWriter out, boolean bindings, int indent, HashSet seen) {
        PrintUtil.printIndent(out, indent);
        out.print(this.toString());
        if (bindings) {
            out.print(" concluded " + PrintUtil.print(this.conclusion));
        }
        out.println(" <-");
        int margin = indent + 4;
        for (int i = 0; i < this.matches.size(); ++i) {
            Triple match = (Triple)this.matches.get(i);
            Iterator derivations = this.infGraph.getDerivation(match);
            if (derivations == null || !derivations.hasNext()) {
                PrintUtil.printIndent(out, margin);
                if (match == null) {
                    ClauseEntry term = this.rule.getBodyElement(i);
                    if (term instanceof Functor) {
                        out.println(((Functor)term).getName() + "()");
                        continue;
                    }
                    out.println("call to built in");
                    continue;
                }
                out.println("Fact " + PrintUtil.print(match));
                continue;
            }
            RuleDerivation derivation = (RuleDerivation)derivations.next();
            if (seen.contains(derivation)) {
                PrintUtil.printIndent(out, margin);
                out.println("Known " + PrintUtil.print(match) + " - already shown");
                continue;
            }
            seen.add(derivation);
            derivation.printTrace(out, bindings, margin, seen);
        }
    }

    public Triple getConclusion() {
        return this.conclusion;
    }

    public List getMatches() {
        return this.matches;
    }

    public Rule getRule() {
        return this.rule;
    }

    public boolean equals(Object other) {
        if (other instanceof RuleDerivation) {
            RuleDerivation otherD = (RuleDerivation)other;
            return this.conclusion.equals(otherD.getConclusion()) && ((Object)this.matches).equals(otherD.getMatches()) && this.rule.equals(otherD.getRule());
        }
        return false;
    }
}

