/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.spring;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.ivis.layout.LNode;

public class SpringNodeDistances {
    public static final int INFINITY = Integer.MAX_VALUE;
    protected List nodesList;
    protected int[][] distances;
    protected boolean directed;
    protected boolean done;
    protected boolean canceled;
    protected int currentProgress;
    protected int lengthOfTask;
    protected String statusMessage;

    public SpringNodeDistances(List nodes_list, int[][] distances) {
        this(nodes_list, distances, false);
    }

    public SpringNodeDistances(List nodes_list, int[][] distances, boolean directed) {
        this.nodesList = nodes_list;
        this.distances = distances == null ? (Object)new int[this.nodesList.size()][] : distances;
        this.directed = directed;
    }

    public SpringNodeDistances(List nodesList) {
        this.nodesList = nodesList;
        this.distances = new int[nodesList.size()][];
        this.directed = false;
    }

    public int getCurrentProgress() {
        return this.currentProgress;
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public String getTaskDescription() {
        return "Calculating Node Distances";
    }

    public String getCurrentStatusMessage() {
        return this.statusMessage;
    }

    public boolean isDone() {
        return this.done;
    }

    public void stop() {
        this.canceled = true;
        this.statusMessage = null;
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    public int[][] calculate() {
        this.currentProgress = 0;
        this.lengthOfTask = this.distances.length;
        this.done = false;
        this.canceled = false;
        LNode[] nodes = new LNode[this.nodesList.size()];
        Integer[] integers = new Integer[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            Integer in;
            LNode from_node = (LNode)this.nodesList.get(i);
            if (from_node == null) continue;
            int index = this.nodesList.indexOf(from_node);
            if (index < 0 || index >= nodes.length) {
                System.err.println("WARNING: GraphLNode \"" + from_node + "\" has an index value that is out of range: " + index + ".  Graph indices should be maintained such " + "that no index is unused.");
                return null;
            }
            if (nodes[index] != null) {
                System.err.println("WARNING: GraphLNode \"" + from_node + "\" has an index value ( " + index + " ) that is the same as " + "that of another GraphLNode ( \"" + nodes[index] + "\" ).  Graph indices should be maintained such " + "that indices are unique.");
                return null;
            }
            nodes[index] = from_node;
            integers[index] = in = new Integer(index);
        }
        LinkedList<Integer> queue = new LinkedList<Integer>();
        boolean[] completed_nodes = new boolean[nodes.length];
        for (int from_node_index = 0; from_node_index < nodes.length; ++from_node_index) {
            if (this.canceled) {
                this.distances = null;
                return this.distances;
            }
            LNode from_node = nodes[from_node_index];
            if (from_node == null) {
                if (this.distances[from_node_index] == null) {
                    this.distances[from_node_index] = new int[nodes.length];
                }
                Arrays.fill(this.distances[from_node_index], Integer.MAX_VALUE);
                continue;
            }
            if (this.distances[from_node_index] == null) {
                this.distances[from_node_index] = new int[nodes.length];
            }
            Arrays.fill(this.distances[from_node_index], Integer.MAX_VALUE);
            this.distances[from_node_index][from_node_index] = 0;
            Arrays.fill(completed_nodes, false);
            queue.add(integers[from_node_index]);
            while (!queue.isEmpty()) {
                if (this.canceled) {
                    this.distances = null;
                    return this.distances;
                }
                int index = (Integer)queue.removeFirst();
                if (completed_nodes[index]) continue;
                completed_nodes[index] = true;
                LNode to_node = nodes[index];
                int to_node_distance = this.distances[from_node_index][index];
                if (index < from_node_index) {
                    for (int i = 0; i < nodes.length; ++i) {
                        int distance_through_to_node;
                        if (this.distances[index][i] == Integer.MAX_VALUE || (distance_through_to_node = to_node_distance + this.distances[index][i]) > this.distances[from_node_index][i]) continue;
                        if (this.distances[index][i] == 1) {
                            completed_nodes[i] = true;
                        }
                        this.distances[from_node_index][i] = distance_through_to_node;
                    }
                    continue;
                }
                Iterator neighbors = to_node.getNeighborsList().iterator();
                while (neighbors.hasNext()) {
                    if (this.canceled) {
                        this.distances = null;
                        return this.distances;
                    }
                    LNode neighbor = (LNode)neighbors.next();
                    int neighbor_index = this.nodesList.indexOf(neighbor);
                    if (neighbor_index < 0) continue;
                    if (nodes[neighbor_index] == null) {
                        this.distances[from_node_index][neighbor_index] = Integer.MAX_VALUE;
                        continue;
                    }
                    if (completed_nodes[neighbor_index]) continue;
                    int neighbor_distance = this.distances[from_node_index][neighbor_index];
                    if (to_node_distance == Integer.MAX_VALUE || neighbor_distance <= to_node_distance + 1) continue;
                    this.distances[from_node_index][neighbor_index] = to_node_distance + 1;
                    queue.addLast(integers[neighbor_index]);
                }
            }
            ++this.currentProgress;
            double percentDone = this.currentProgress * 100 / this.lengthOfTask;
            this.statusMessage = "Completed " + percentDone + "%.";
        }
        this.done = true;
        this.currentProgress = this.lengthOfTask;
        return this.distances;
    }

    public int[][] getDistances() {
        return this.distances;
    }
}

