/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.io.xml;

import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.ivis.io.xml.XmlIOHandler;
import org.ivis.layout.Layout;
import org.ivis.layout.cose.CoSEEdge;
import org.ivis.layout.cose.CoSELayout;
import org.ivis.layout.cose.CoSENode;
import org.ivis.layout.sbgn.SbgnPDEdge;
import org.ivis.layout.sbgn.SbgnPDLayout;
import org.ivis.layout.sbgn.SbgnPDNode;
import org.ivis.layout.sbgn.SbgnProcessNode;
import org.ivis.util.IGeometry;
import org.ivis.util.PointD;
import org.ivis.util.RectangleD;

public class TestApplet
extends Applet
implements MouseListener {
    public final int RUN_COUNT = 1;
    private ArrayList<SbgnPDNode> sbgnNodes;
    private ArrayList<SbgnPDEdge> sbgnEdges;
    private ArrayList<CoSENode> cosenodes;
    private ArrayList<CoSEEdge> coseedges;
    private ArrayList<CoSENode> prodNodes;
    private ArrayList<CoSENode> consNodes;
    private ArrayList<String> fileList;
    private ArrayList<SbgnProcessNode.Orientation> orientationList;
    private Button layoutButton;
    private Button exitButton;
    private double zoomLevel = 2.3;
    private double properlyOrientedCoSEEdgeCnt;
    double totalEdgeCount = 0.0;
    Object myLayout;
    Graphics g2;
    private boolean isDebugOn = false;

    @Override
    public void init() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(dim.width, dim.height);
        this.setBackground(Color.WHITE);
        this.g2 = this.getGraphics();
        this.sbgnNodes = new ArrayList();
        this.sbgnEdges = new ArrayList();
        this.cosenodes = new ArrayList();
        this.coseedges = new ArrayList();
        this.prodNodes = new ArrayList();
        this.consNodes = new ArrayList();
        this.fileList = new ArrayList();
        this.orientationList = new ArrayList();
        this.orientationList.add(SbgnProcessNode.Orientation.LEFT_TO_RIGHT);
        this.orientationList.add(SbgnProcessNode.Orientation.RIGHT_TO_LEFT);
        this.orientationList.add(SbgnProcessNode.Orientation.TOP_TO_BOTTOM);
        this.orientationList.add(SbgnProcessNode.Orientation.BOTTOM_TO_TOP);
        this.layoutButton = new Button("sbgn");
        this.exitButton = new Button("exit");
        this.layoutButton.addMouseListener(this);
        this.exitButton.addMouseListener(this);
        this.add(this.layoutButton);
        this.add(this.exitButton);
        this.fileList.add("org/ivis/io/xml/insuline.xml");
    }

    @Override
    public void paint(Graphics g2) {
        Graphics2D g = (Graphics2D)g2;
        Dimension d = this.getSize();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, (int)d.getWidth(), (int)d.getHeight());
        if (this.sbgnNodes.size() <= 0) {
            g.drawString("Click on a button", 2 * this.getWidth() / 5, (int)((double)this.getHeight() / this.zoomLevel));
        }
        if (this.myLayout instanceof SbgnPDLayout) {
            this.drawNodes(g);
            this.drawEdges(g);
        } else if (this.myLayout instanceof CoSELayout) {
            this.drawCoseNodes(g);
            this.drawCoseEdges(g);
        }
    }

    private void drawCoseNodes(Graphics2D g) {
        for (int i = 0; i < this.cosenodes.size(); ++i) {
            CoSENode node = this.cosenodes.get(i);
            g.setColor(Color.DARK_GRAY);
            g.drawRect((int)(node.getLeft() / this.zoomLevel), (int)(node.getTop() / this.zoomLevel), (int)(node.getWidth() / this.zoomLevel), (int)(node.getHeight() / this.zoomLevel));
        }
    }

    private void drawCoseEdges(Graphics2D g) {
        for (int i = 0; i < this.coseedges.size(); ++i) {
            if (this.coseedges.get((int)i).type.equals("production")) {
                g.setColor(Color.RED);
            } else if (this.coseedges.get((int)i).type.equals("consumption")) {
                g.setColor(Color.GREEN);
            }
            double[] clipPointCoordinates = new double[4];
            RectangleD rectTarget = this.coseedges.get(i).getTarget().getRect();
            RectangleD rectSource = this.coseedges.get(i).getSource().getRect();
            IGeometry.getIntersection(rectTarget, rectSource, clipPointCoordinates);
            g.drawLine((int)(clipPointCoordinates[0] / this.zoomLevel), (int)(clipPointCoordinates[1] / this.zoomLevel), (int)(clipPointCoordinates[2] / this.zoomLevel), (int)(clipPointCoordinates[3] / this.zoomLevel));
            g.setColor(Color.BLACK);
            g.setFont(new Font("TimesRoman", 0, 10));
            int x = (int)((clipPointCoordinates[0] / this.zoomLevel + clipPointCoordinates[2] / this.zoomLevel) / 2.0);
            int y = (int)((clipPointCoordinates[1] / this.zoomLevel + clipPointCoordinates[3] / this.zoomLevel) / 2.0);
        }
    }

    private void drawNodes(Graphics2D g) {
        for (int i = 0; i < this.sbgnNodes.size(); ++i) {
            SbgnPDNode node = this.sbgnNodes.get(i);
            if (node.type != null && node.type.equals("complex") && node.visited) {
                g.setColor(Color.ORANGE);
            } else if (node.type != null && node.type.equals("complex") && !node.visited) {
                g.setColor(Color.BLUE);
            } else if (node.type != null && node.type.equals("input_port")) {
                g.setColor(Color.GREEN);
            } else if (node.type != null && node.type.equals("output_port")) {
                g.setColor(Color.RED);
            } else if (node.type != null && node.isDummyCompound) {
                g.setColor(Color.MAGENTA);
            } else if (node.getChild() != null) {
                g.setColor(Color.PINK);
            } else {
                g.setColor(Color.DARK_GRAY);
            }
            if (node instanceof SbgnProcessNode && ((SbgnProcessNode)node).isHighlighted) {
                SbgnProcessNode processNode = (SbgnProcessNode)node;
            }
            g.drawRect((int)(node.getLeft() / this.zoomLevel), (int)(node.getTop() / this.zoomLevel), (int)(node.getWidth() / this.zoomLevel), (int)(node.getHeight() / this.zoomLevel));
            g.setColor(Color.BLACK);
        }
    }

    private void drawEdges(Graphics2D g) {
        for (int i = 0; i < this.sbgnEdges.size(); ++i) {
            if (this.sbgnEdges.get((int)i).type.equals("production")) {
                if (this.sbgnEdges.get((int)i).isProperlyOriented) {
                    g.setColor(Color.LIGHT_GRAY);
                } else {
                    g.setColor(Color.RED);
                }
            } else if (this.sbgnEdges.get((int)i).type.equals("consumption")) {
                if (this.sbgnEdges.get((int)i).isProperlyOriented) {
                    g.setColor(Color.LIGHT_GRAY);
                } else {
                    g.setColor(Color.GREEN);
                }
            } else if (this.sbgnEdges.get((int)i).type.equals("rigid edge")) {
                g.setColor(Color.BLUE);
            } else {
                g.setColor(Color.BLACK);
            }
            double[] clipPointCoordinates = new double[4];
            RectangleD rectTarget = this.sbgnEdges.get(i).getTarget().getRect();
            RectangleD rectSource = this.sbgnEdges.get(i).getSource().getRect();
            IGeometry.getIntersection(rectTarget, rectSource, clipPointCoordinates);
            g.drawLine((int)(clipPointCoordinates[0] / this.zoomLevel), (int)(clipPointCoordinates[1] / this.zoomLevel), (int)(clipPointCoordinates[2] / this.zoomLevel), (int)(clipPointCoordinates[3] / this.zoomLevel));
            g.setColor(Color.BLACK);
            g.setFont(new Font("TimesRoman", 0, 10));
            int x = (int)((clipPointCoordinates[0] / this.zoomLevel + clipPointCoordinates[2] / this.zoomLevel) / 2.0);
            int y = (int)((clipPointCoordinates[1] / this.zoomLevel + clipPointCoordinates[3] / this.zoomLevel) / 2.0);
        }
    }

    private void calculateAngles() {
        this.properlyOrientedCoSEEdgeCnt = 0.0;
        PointD inputPort = new PointD();
        PointD outputPort = new PointD();
        PointD inputPortTarget = new PointD();
        PointD outputPortTarget = new PointD();
        double bestResult = Double.MIN_VALUE;
        double appropriateEdgeCnt = 0.0;
        double notAppropriateEdgeCnt = 0.0;
        this.totalEdgeCount = 0.0;
        PointD centerPointD = new PointD();
        for (CoSENode node : this.cosenodes) {
            if (!node.type.equals("process")) continue;
            if (this.isDebugOn) {
                System.out.println("\n process node " + node.label);
            }
            centerPointD.x = node.getCenterX();
            centerPointD.y = node.getCenterY();
            this.prodNodes.clear();
            this.consNodes.clear();
            for (Object edgeObj : node.getEdges()) {
                if (((CoSEEdge)edgeObj).type.equals("production")) {
                    this.prodNodes.add((CoSENode)((CoSEEdge)edgeObj).getTarget());
                    continue;
                }
                if (!((CoSEEdge)edgeObj).type.equals("consumption")) continue;
                this.consNodes.add((CoSENode)((CoSEEdge)edgeObj).getSource());
            }
            if (this.isDebugOn) {
                for (CoSENode c : this.prodNodes) {
                    System.out.println("prod: " + c.label);
                }
                for (CoSENode c : this.consNodes) {
                    System.out.println("cons: " + c.label);
                }
                System.out.println();
            }
            bestResult = Double.MIN_VALUE;
            for (SbgnProcessNode.Orientation orient : this.orientationList) {
                if (this.isDebugOn) {
                    System.out.println("trying orientation: " + (Object)((Object)orient));
                }
                appropriateEdgeCnt = 0.0;
                notAppropriateEdgeCnt = 0.0;
                inputPort = this.findPortLocation(true, centerPointD, orient);
                outputPort = this.findPortLocation(false, centerPointD, orient);
                inputPortTarget = this.findPortTargetPoint(true, orient, inputPort, outputPort);
                outputPortTarget = this.findPortTargetPoint(false, orient, inputPort, outputPort);
                if (this.isDebugOn) {
                    System.out.println("consumption nodes");
                }
                for (CoSENode node2 : this.consNodes) {
                    if (this.isAngleAppropriate(node2, inputPort, inputPortTarget)) {
                        appropriateEdgeCnt += 1.0;
                        if (!this.isDebugOn) continue;
                        System.out.println("" + node2.label + " +");
                        continue;
                    }
                    notAppropriateEdgeCnt += 1.0;
                    if (!this.isDebugOn) continue;
                    System.out.println("" + node2.label + " -");
                }
                if (this.isDebugOn) {
                    System.out.println("production nodes");
                }
                for (CoSENode node2 : this.prodNodes) {
                    if (this.isAngleAppropriate(node2, outputPort, outputPortTarget)) {
                        appropriateEdgeCnt += 1.0;
                        if (!this.isDebugOn) continue;
                        System.out.println("" + node2.label + " +");
                        continue;
                    }
                    notAppropriateEdgeCnt += 1.0;
                    if (!this.isDebugOn) continue;
                    System.out.println("" + node2.label + " -");
                }
                if (this.isDebugOn) {
                    System.out.println("best: " + bestResult + " current: " + appropriateEdgeCnt);
                }
                if (!(appropriateEdgeCnt > bestResult)) continue;
                bestResult = appropriateEdgeCnt;
                node.orient = orient;
                node.OKCount = bestResult;
                if (!this.isDebugOn) continue;
                System.out.println("best updated: " + node.OKCount);
            }
            this.properlyOrientedCoSEEdgeCnt += bestResult;
            this.totalEdgeCount += appropriateEdgeCnt + notAppropriateEdgeCnt;
        }
        System.out.println("totalResult: " + this.properlyOrientedCoSEEdgeCnt + " / " + this.totalEdgeCount + ": " + this.properlyOrientedCoSEEdgeCnt / this.totalEdgeCount);
    }

    private boolean isAngleAppropriate(CoSENode node, PointD portNode, PointD targetPoint) {
        PointD nodeCenter = node.getCenter();
        double angleValue = 0.0;
        PointD point1 = new PointD(targetPoint.x - portNode.x, targetPoint.y - portNode.y);
        PointD point2 = new PointD(nodeCenter.x - portNode.x, nodeCenter.y - portNode.y);
        if (Math.abs(point1.x) < 0.0) {
            point1.x = 1.0E-4;
        }
        if (Math.abs(point1.y) < 0.0) {
            point1.y = 1.0E-4;
        }
        angleValue = (point1.x * point2.x + point1.y * point2.y) / (Math.sqrt(point1.x * point1.x + point1.y * point1.y) * Math.sqrt(point2.x * point2.x + point2.y * point2.y));
        double angle = Math.abs(Math.toDegrees(Math.acos(angleValue)));
        if (this.isDebugOn) {
            System.out.println("angle: " + angle);
        }
        return angle < 100.0;
    }

    private PointD findPortLocation(boolean isInputPort, PointD centerPoint, SbgnProcessNode.Orientation orientation) {
        if (orientation.equals((Object)SbgnProcessNode.Orientation.LEFT_TO_RIGHT)) {
            if (isInputPort) {
                return new PointD(centerPoint.x - 10.0, centerPoint.y);
            }
            return new PointD(centerPoint.x + 10.0, centerPoint.y);
        }
        if (orientation.equals((Object)SbgnProcessNode.Orientation.RIGHT_TO_LEFT)) {
            if (isInputPort) {
                return new PointD(centerPoint.x + 10.0, centerPoint.y);
            }
            return new PointD(centerPoint.x - 10.0, centerPoint.y);
        }
        if (orientation.equals((Object)SbgnProcessNode.Orientation.TOP_TO_BOTTOM)) {
            if (isInputPort) {
                return new PointD(centerPoint.x, centerPoint.y - 10.0);
            }
            return new PointD(centerPoint.x, centerPoint.y + 10.0);
        }
        if (orientation.equals((Object)SbgnProcessNode.Orientation.BOTTOM_TO_TOP)) {
            if (isInputPort) {
                return new PointD(centerPoint.x, centerPoint.y + 10.0);
            }
            return new PointD(centerPoint.x, centerPoint.y - 10.0);
        }
        return null;
    }

    private PointD findPortTargetPoint(boolean isInputPort, SbgnProcessNode.Orientation orientation, PointD inputPort, PointD outputPort) {
        double idealEdgeLength = ((CoSELayout)this.myLayout).idealEdgeLength;
        if (orientation.equals((Object)SbgnProcessNode.Orientation.LEFT_TO_RIGHT)) {
            if (isInputPort) {
                return new PointD(inputPort.x - idealEdgeLength, inputPort.y);
            }
            return new PointD(outputPort.x + idealEdgeLength, outputPort.y);
        }
        if (orientation.equals((Object)SbgnProcessNode.Orientation.RIGHT_TO_LEFT)) {
            if (isInputPort) {
                return new PointD(inputPort.x + idealEdgeLength, inputPort.y);
            }
            return new PointD(outputPort.x - idealEdgeLength, outputPort.y);
        }
        if (orientation.equals((Object)SbgnProcessNode.Orientation.TOP_TO_BOTTOM)) {
            if (isInputPort) {
                return new PointD(inputPort.x, inputPort.y - idealEdgeLength);
            }
            return new PointD(outputPort.x, outputPort.y + idealEdgeLength);
        }
        if (orientation.equals((Object)SbgnProcessNode.Orientation.BOTTOM_TO_TOP)) {
            if (isInputPort) {
                return new PointD(inputPort.x, inputPort.y + idealEdgeLength);
            }
            return new PointD(outputPort.x, outputPort.y - idealEdgeLength);
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        try {
            if (e2.getSource() == this.layoutButton) {
                FileWriter writer = new FileWriter("results.csv");
                writer.append("Phase1IterCnt,Phase2IterCnt,SbgnProperEdgeCnt,TotalEdgeCnt,SbgnResult,SbgnExecTime,CoSEProperEdgeCnt,CoSEResult,CoSEExecTime\n");
                this.performSbgnPDLayout(writer);
                writer.flush();
                writer.close();
            } else if (e2.getSource() == this.exitButton) {
                System.exit(0);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private void performCoSELayout(Writer writer) {
        System.out.println("Cose started");
        for (int j = 0; j < this.fileList.size(); ++j) {
            try {
                for (int i = 0; i < 1; ++i) {
                    int k;
                    this.myLayout = new CoSELayout();
                    XmlIOHandler xih = new XmlIOHandler((CoSELayout)this.myLayout);
                    Layout l = xih.test(this.fileList.get(j));
                    Object[] allNodes = ((CoSELayout)this.myLayout).getAllNodes();
                    Object[] allEdges = ((CoSELayout)this.myLayout).getAllEdges();
                    this.cosenodes.clear();
                    this.coseedges.clear();
                    for (k = 0; k < allNodes.length; ++k) {
                        this.cosenodes.add((CoSENode)allNodes[k]);
                    }
                    for (k = 0; k < allEdges.length; ++k) {
                        this.coseedges.add((CoSEEdge)allEdges[k]);
                    }
                    this.calculateAngles();
                    writer.append("" + this.properlyOrientedCoSEEdgeCnt);
                    writer.append(",");
                    writer.append("" + this.properlyOrientedCoSEEdgeCnt / this.totalEdgeCount);
                    writer.append(",");
                    writer.append("" + ((CoSELayout)this.myLayout).executionTime);
                    writer.append("\n");
                }
                continue;
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        this.repaint();
    }

    private void performSbgnPDLayout(Writer writer) {
        int i;
        for (int j = 0; j < this.fileList.size(); ++j) {
            try {
                for (int i2 = 0; i2 < 1; ++i2) {
                    this.myLayout = new SbgnPDLayout();
                    XmlIOHandler xih = new XmlIOHandler((SbgnPDLayout)this.myLayout);
                    Layout l = xih.test(this.fileList.get(j));
                    writer.append("" + ((SbgnPDLayout)this.myLayout).phase1IterationCount);
                    writer.append(',');
                    writer.append("" + ((SbgnPDLayout)this.myLayout).phase2IterationCount);
                    writer.append(',');
                    writer.append("" + ((SbgnPDLayout)this.myLayout).properlyOrientedEdgeCount);
                    writer.append(',');
                    writer.append("" + ((SbgnPDLayout)this.myLayout).totalEdgeCount);
                    writer.append(',');
                    writer.append("" + ((SbgnPDLayout)this.myLayout).properlyOrientedEdgeCount / ((SbgnPDLayout)this.myLayout).totalEdgeCount);
                    writer.append(',');
                    writer.append("" + ((SbgnPDLayout)this.myLayout).executionTime);
                    writer.append('\n');
                }
                continue;
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        Object[] allNodes = ((SbgnPDLayout)this.myLayout).getAllNodes();
        Object[] allEdges = ((SbgnPDLayout)this.myLayout).getAllEdges();
        this.sbgnNodes.clear();
        this.sbgnEdges.clear();
        for (i = 0; i < allNodes.length; ++i) {
            this.sbgnNodes.add((SbgnPDNode)allNodes[i]);
        }
        for (i = 0; i < allEdges.length; ++i) {
            this.sbgnEdges.add((SbgnPDEdge)allEdges[i]);
        }
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e2) {
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }
}

