/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.miner;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.ModificationFeature;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.model.level3.XReferrable;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.pattern.Constraint;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.Pattern;
import org.biopax.paxtools.pattern.constraint.HasAnID;
import org.biopax.paxtools.pattern.miner.IDFetcher;
import org.biopax.paxtools.pattern.miner.Miner;
import org.biopax.paxtools.pattern.miner.SIFInteraction;
import org.biopax.paxtools.pattern.miner.SIFMiner;
import org.biopax.paxtools.pattern.util.Blacklist;
import org.biopax.paxtools.pattern.util.HGNC;
import org.biopax.paxtools.pattern.util.PhysicalEntityChain;

public abstract class MinerAdapter
implements Miner {
    protected String name;
    protected String description;
    protected Pattern pattern;
    protected Blacklist blacklist;
    protected IDFetcher idFetcher;
    private static final PathAccessor FEAT_ACC = new PathAccessor("PhysicalEntity/feature:ModificationFeature");
    private static final PathAccessor TERM_ACC = new PathAccessor("ModificationFeature/modificationType/term");
    private static final PathAccessor SITE_ACC = new PathAccessor("ModificationFeature/featureLocation:SequenceSite/sequencePosition");
    private static final PathAccessor INTERVAL_BEGIN_ACC = new PathAccessor("ModificationFeature/featureLocation:SequenceInterval/sequenceIntervalBegin/sequencePosition");
    private static final PathAccessor INTERVAL_END_ACC = new PathAccessor("ModificationFeature/featureLocation:SequenceInterval/sequenceIntervalEnd/sequencePosition");

    protected MinerAdapter(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public void setBlacklist(Blacklist blacklist) {
        this.blacklist = blacklist;
    }

    public void setIDFetcher(IDFetcher idFetcher) {
        this.idFetcher = idFetcher;
    }

    public abstract Pattern constructPattern();

    @Override
    public Pattern getPattern() {
        if (this.pattern == null) {
            this.pattern = this.constructPattern();
            if (this instanceof SIFMiner && this.idFetcher != null) {
                this.pattern.add((Constraint)new HasAnID(this.idFetcher), ((SIFMiner)((Object)this)).getSourceLabel());
                this.pattern.add((Constraint)new HasAnID(this.idFetcher), ((SIFMiner)((Object)this)).getTargetLabel());
            }
            this.pattern.optimizeConstraintOrder();
        }
        return this.pattern;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return this.getName();
    }

    protected String getGeneSymbol(ProteinReference pr) {
        for (Xref xr : pr.getXref()) {
            String symbol;
            String id;
            String db = xr.getDb();
            if (db == null || !(db = db.toLowerCase()).startsWith("hgnc") || (id = xr.getId()) == null || (symbol = HGNC.getSymbol(id)) == null || symbol.isEmpty()) continue;
            return symbol;
        }
        return null;
    }

    protected String getUniprotNameForHuman(ProteinReference pr) {
        for (String name : pr.getName()) {
            if (!name.endsWith("_HUMAN")) continue;
            return name;
        }
        return null;
    }

    protected String getGeneSymbol(Match m, String label) {
        ProteinReference pr = (ProteinReference)m.get(label, this.getPattern());
        return this.getGeneSymbol(pr);
    }

    protected String getUniprotNameForHuman(Match m, String label) {
        ProteinReference er = (ProteinReference)m.get(label, this.getPattern());
        return this.getUniprotNameForHuman(er);
    }

    public boolean isInhibition(Control ctrl) {
        return ctrl.getControlType() != null && ctrl.getControlType().toString().startsWith("I");
    }

    public String listModifications(Set<ModificationFeature> set) {
        ArrayList<ModificationFeature> list = new ArrayList<ModificationFeature>(set);
        Collections.sort(list, new Comparator<ModificationFeature>(){

            @Override
            public int compare(ModificationFeature o1, ModificationFeature o2) {
                String t1 = MinerAdapter.this.getModificationTerm(o1);
                String t2 = MinerAdapter.this.getModificationTerm(o2);
                Integer l1 = MinerAdapter.this.getPositionStart(o1);
                Integer l2 = MinerAdapter.this.getPositionStart(o2);
                if (t1 == null && t2 == null) {
                    return l1.compareTo(l2);
                }
                if (t1 == null) {
                    return 1;
                }
                if (t2 == null) {
                    return -1;
                }
                if (t1.equals(t2)) {
                    return l1.compareTo(l2);
                }
                return t1.compareTo(t2);
            }
        });
        return this.getInString(list);
    }

    private String getInString(List<ModificationFeature> list) {
        ArrayList<String> text = new ArrayList<String>(list.size());
        for (ModificationFeature mf : list) {
            String s;
            String term = this.getModificationTerm(mf);
            String loc = this.getPositionInString(mf);
            if (term == null || text.contains(s = term + loc)) continue;
            text.add(s);
        }
        String s = "";
        for (String t : text) {
            s = s + "[" + t + "] ";
        }
        return s.trim();
    }

    public String getModificationTerm(ModificationFeature mf) {
        Set vals = TERM_ACC.getValueFromBean(mf);
        if (vals.isEmpty()) {
            return null;
        }
        return vals.iterator().next().toString();
    }

    public int getPositionStart(ModificationFeature mf) {
        Set vals = SITE_ACC.getValueFromBean(mf);
        if (!vals.isEmpty()) {
            return (Integer)vals.iterator().next();
        }
        vals = INTERVAL_BEGIN_ACC.getValueFromBean(mf);
        if (!vals.isEmpty()) {
            return (Integer)vals.iterator().next();
        }
        return -1;
    }

    public String getPositionInString(ModificationFeature mf) {
        int x;
        Set vals = SITE_ACC.getValueFromBean(mf);
        if (!vals.isEmpty() && (x = ((Integer)vals.iterator().next()).intValue()) > 0) {
            return "@" + x;
        }
        vals = INTERVAL_BEGIN_ACC.getValueFromBean(mf);
        if (!vals.isEmpty()) {
            int begin = (Integer)vals.iterator().next();
            vals = INTERVAL_END_ACC.getValueFromBean(mf);
            if (!vals.isEmpty()) {
                int end = (Integer)vals.iterator().next();
                if (begin > 0 && end > 0 && begin <= end) {
                    if (begin == end) {
                        return "@" + begin;
                    }
                    return "@[" + begin + "-" + end + "]";
                }
            }
        }
        return "";
    }

    protected String getModifications(Match m, String label) {
        PhysicalEntity pe = (PhysicalEntity)m.get(label, this.getPattern());
        return this.listModifications(new HashSet<ModificationFeature>(FEAT_ACC.getValueFromBean(pe)));
    }

    protected String getModifications(Match m, String memLabel, String comLabel) {
        PhysicalEntityChain chain = new PhysicalEntityChain((PhysicalEntity)m.get(memLabel, this.getPattern()), (PhysicalEntity)m.get(comLabel, this.getPattern()));
        return this.listModifications(chain.getModifications());
    }

    protected String[] getDeltaModifications(Match m, String memLabel1, String comLabel1, String memLabel2, String comLabel2) {
        PhysicalEntityChain chain1 = new PhysicalEntityChain((PhysicalEntity)m.get(memLabel1, this.getPattern()), (PhysicalEntity)m.get(comLabel1, this.getPattern()));
        PhysicalEntityChain chain2 = new PhysicalEntityChain((PhysicalEntity)m.get(memLabel2, this.getPattern()), (PhysicalEntity)m.get(comLabel2, this.getPattern()));
        Set<ModificationFeature> before = chain1.getModifications();
        HashSet<ModificationFeature> intersect = new HashSet<ModificationFeature>(before);
        Set<ModificationFeature> after = chain2.getModifications();
        intersect.retainAll(after);
        before.removeAll(intersect);
        after.removeAll(intersect);
        String afterMods = this.listModifications(after);
        String beforeMods = this.listModifications(before);
        return new String[]{afterMods, beforeMods};
    }

    public void writeResultAsSIF(Map<BioPAXElement, List<Match>> matches2, OutputStream out, boolean directed, String label1, String label2) throws IOException {
        if (matches2.isEmpty()) {
            return;
        }
        if (this instanceof SIFMiner) {
            this.writeSIFsUsingSIFFramework(matches2, out);
            return;
        }
        HashSet<String> mem = new HashSet<String>();
        String mid = this.getRelationType() == null ? "\t" : "\trelation\t";
        OutputStreamWriter writer = new OutputStreamWriter(out);
        String header = this.getHeader();
        writer.write(header == null ? label1 + mid + label2 : header);
        for (BioPAXElement ele : matches2.keySet()) {
            for (Match m : matches2.get(ele)) {
                String s1 = this.getIdentifier(m, label1);
                String s2 = this.getIdentifier(m, label2);
                if (s1 == null || s2 == null) continue;
                String type = this.getRelationType();
                String sep = type == null ? "\t" : "\t" + type + "\t";
                String relation = s1 + sep + s2;
                String reverse = s2 + sep + s1;
                if (mem.contains(relation) || !directed && mem.contains(reverse)) continue;
                writer.write("\n" + relation);
                mem.add(relation);
                if (directed) continue;
                mem.add(reverse);
            }
        }
        writer.flush();
    }

    public void writeSIFsUsingSIFFramework(Map<BioPAXElement, List<Match>> matches2, OutputStream out) throws IOException {
        HashMap<SIFInteraction, SIFInteraction> sifMap = new HashMap<SIFInteraction, SIFInteraction>();
        for (List<Match> matchList : matches2.values()) {
            for (Match match : matchList) {
                SIFInteraction inter = this.createSIFInteraction(match, new IDFetcher(){

                    @Override
                    public String fetchID(BioPAXElement ele) {
                        if (ele instanceof SmallMoleculeReference) {
                            SmallMoleculeReference smr = (SmallMoleculeReference)ele;
                            if (smr.getDisplayName() != null) {
                                return smr.getDisplayName();
                            }
                            if (!smr.getName().isEmpty()) {
                                return smr.getName().iterator().next();
                            }
                            return null;
                        }
                        if (ele instanceof XReferrable) {
                            for (Xref xr : ((XReferrable)ele).getXref()) {
                                String symbol;
                                String id;
                                String db = xr.getDb();
                                if (db == null || !(db = db.toLowerCase()).startsWith("hgnc") || (id = xr.getId()) == null || (symbol = HGNC.getSymbol(id)) == null || symbol.isEmpty()) continue;
                                return symbol;
                            }
                        }
                        return null;
                    }
                });
                if (!inter.hasIDs()) continue;
                if (sifMap.containsKey(inter)) {
                    ((SIFInteraction)sifMap.get(inter)).mergeWith(inter);
                    continue;
                }
                sifMap.put(inter, inter);
            }
        }
        OutputStreamWriter writer = new OutputStreamWriter(out);
        boolean first = true;
        for (SIFInteraction inter : sifMap.keySet()) {
            if (first) {
                first = false;
            } else {
                writer.write("\n");
            }
            writer.write(inter.toString());
        }
        writer.flush();
    }

    public String getRelationType() {
        if (this instanceof SIFMiner) {
            return ((SIFMiner)((Object)this)).getSIFType().getTag();
        }
        return null;
    }

    public String getHeader() {
        return null;
    }

    public void writeResultDetailed(Map<BioPAXElement, List<Match>> matches2, OutputStream out, int columns) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        String header = this.getHeader();
        if (header != null) {
            writer.write(header);
        } else {
            for (int i = 0; i < columns; ++i) {
                writer.write("col-" + (i + 1));
                if (i >= columns - 1) continue;
                writer.write("\t");
            }
        }
        HashSet<String> mem = new HashSet<String>();
        for (BioPAXElement ele : matches2.keySet()) {
            for (Match m : matches2.get(ele)) {
                String line = "";
                boolean aborted = false;
                for (int i = 0; i < columns; ++i) {
                    String s = this.getValue(m, i);
                    if (s == null) {
                        aborted = true;
                        break;
                    }
                    line = line + s + "\t";
                }
                if (aborted || mem.contains(line = line.trim())) continue;
                writer.write("\n" + line);
                mem.add(line);
            }
        }
        writer.flush();
    }

    public String getValue(Match m, int col) {
        return null;
    }

    public SIFInteraction createSIFInteraction(Match m, IDFetcher fetcher) {
        if (this instanceof SIFMiner) {
            return new SIFInteraction(m.get(((SIFMiner)((Object)this)).getSourceLabel(), this.getPattern()), m.get(((SIFMiner)((Object)this)).getTargetLabel(), this.getPattern()), ((SIFMiner)((Object)this)).getSIFType(), new HashSet<BioPAXElement>(m.get(this.getMediatorLabels(), this.getPattern())), new HashSet<BioPAXElement>(m.get(this.getSourcePELabels(), this.getPattern())), new HashSet<BioPAXElement>(m.get(this.getTargetPELabels(), this.getPattern())), fetcher);
        }
        return null;
    }

    public String[] getMediatorLabels() {
        return null;
    }

    public String[] getSourcePELabels() {
        return null;
    }

    public String[] getTargetPELabels() {
        return null;
    }

    public String getIdentifier(Match m, String label) {
        BioPAXElement el = m.get(label, this.getPattern());
        if (this.idFetcher != null) {
            return this.idFetcher.fetchID(el);
        }
        if (el instanceof ProteinReference) {
            return this.getGeneSymbol((ProteinReference)el);
        }
        if (el instanceof SmallMoleculeReference) {
            return this.getCompoundName((SmallMoleculeReference)el);
        }
        return null;
    }

    public String getCompoundName(SmallMoleculeReference smr) {
        return smr.getDisplayName();
    }
}

