/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level3;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.io.sif.InteractionSet;
import org.biopax.paxtools.io.sif.SimpleInteraction;
import org.biopax.paxtools.io.sif.level3.Group;
import org.biopax.paxtools.io.sif.level3.GroupMap;
import org.biopax.paxtools.io.sif.level3.InteractionRuleL3;
import org.biopax.paxtools.io.sif.level3.InteractionSetL3;
import org.biopax.paxtools.io.sif.level3.ParticipatesRule;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.PhysicalEntity;

public abstract class InteractionRuleL3Adaptor
implements InteractionRuleL3 {
    private final Log log = LogFactory.getLog(ParticipatesRule.class);

    @Override
    public final void inferInteractions(InteractionSet interactionSet, BioPAXElement entity2, Model model) {
        if (entity2 instanceof PhysicalEntity) {
            this.inferInteractionsFromPE((InteractionSetL3)interactionSet, (PhysicalEntity)entity2, model);
        } else if (this.log.isInfoEnabled()) {
            this.log.info("Not a PE Skipping." + entity2.getRDFId());
        }
    }

    @Override
    public void initOptions(Map options) {
        if (options == null) {
            options = new HashMap();
        }
        this.initOptionsNotNull(options);
    }

    protected void initOptionsNotNull(Map options) {
    }

    protected boolean checkOption(Object key, Object value, Map options) {
        return options.containsKey(key) && options.get(key).equals(value);
    }

    protected Set<BioPAXElement> collectEntities(Set<PhysicalEntity> pes, InteractionSetL3 set) {
        HashSet<BioPAXElement> entities = new HashSet<BioPAXElement>();
        for (PhysicalEntity pe : pes) {
            BioPAXElement entity2 = set.getGroupMap().getEntityReferenceOrGroup(pe);
            if (entity2 != null) {
                entities.add(entity2);
            }
            if (!(entity2 instanceof Group)) continue;
            this.getMembersRecursively(entities, (Group)entity2);
        }
        return entities;
    }

    private void getMembersRecursively(Set<BioPAXElement> entities, Group group) {
        entities.addAll(group.members);
        for (Group subgroup : group.subgroups) {
            this.getMembersRecursively(entities, subgroup);
        }
    }

    protected void createClique(InteractionSetL3 interactionSet, List<BioPAXElement> components, BinaryInteractionType type, BioPAXElement ... mediators) {
        GroupMap groupMap = interactionSet.getGroupMap();
        for (int j = 0; j < components.size(); ++j) {
            for (int i = 0; i < j; ++i) {
                this.createAndAdd(groupMap.getEntityReferenceOrGroup(components.get(i)), groupMap.getEntityReferenceOrGroup(components.get(j)), interactionSet, type, mediators);
            }
        }
    }

    protected void createAndAdd(BioPAXElement source, BioPAXElement target, InteractionSetL3 is3, BinaryInteractionType type, BioPAXElement ... mediators) {
        if (source != null && target != null && !source.equals(target)) {
            SimpleInteraction sc = new SimpleInteraction(source, target, type);
            for (BioPAXElement mediator : mediators) {
                sc.addMediator(mediator);
            }
            is3.add(sc);
        }
    }
}

