/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level3;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.io.sif.level3.Group;
import org.biopax.paxtools.io.sif.level3.InteractionRuleL3Adaptor;
import org.biopax.paxtools.io.sif.level3.InteractionSetL3;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.PhysicalEntity;

public class ComponentRule
extends InteractionRuleL3Adaptor {
    private static List<BinaryInteractionType> binaryInteractionTypes = Arrays.asList(BinaryInteractionType.IN_SAME_COMPONENT);
    private boolean inSameComponent;
    private boolean componentOf;

    @Override
    public void inferInteractionsFromPE(InteractionSetL3 interactionSet, PhysicalEntity pe, Model model) {
        Group group;
        if (pe instanceof Complex && (group = interactionSet.getGroupMap().getMap().get(pe)) != null) {
            Set<EntityReference> members = group.members;
            Set<Group> subGroups = group.subgroups;
            ArrayList<BioPAXElement> components = new ArrayList<BioPAXElement>(members.size() + subGroups.size());
            components.addAll(members);
            components.addAll(subGroups);
            if (this.inSameComponent) {
                BioPAXElement[] sources = group.sources.toArray((BioPAXElement[])Array.newInstance(BioPAXElement.class, group.sources.size()));
                this.createClique(interactionSet, components, BinaryInteractionType.IN_SAME_COMPONENT, sources);
            }
            if (this.componentOf) {
                for (BioPAXElement component : components) {
                    this.addComponent(component, group, interactionSet);
                }
            }
        }
    }

    private void addComponent(BioPAXElement component, Group group, InteractionSetL3 interactionSet) {
        this.createAndAdd(interactionSet.getGroupMap().getEntityReferenceOrGroup(component), group, interactionSet, BinaryInteractionType.COMPONENT_OF, new BioPAXElement[0]);
    }

    @Override
    public void initOptionsNotNull(Map options) {
        this.inSameComponent = !this.checkOption((Object)BinaryInteractionType.IN_SAME_COMPONENT, Boolean.FALSE, options);
        this.componentOf = !this.checkOption((Object)BinaryInteractionType.COMPONENT_OF, Boolean.FALSE, options);
    }

    @Override
    public List<BinaryInteractionType> getRuleTypes() {
        return binaryInteractionTypes;
    }
}

