/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level2;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.io.sif.InteractionSet;
import org.biopax.paxtools.io.sif.SimpleInteraction;
import org.biopax.paxtools.io.sif.level2.InteractionRuleL2Adaptor;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.Direction;
import org.biopax.paxtools.model.level2.catalysis;
import org.biopax.paxtools.model.level2.complex;
import org.biopax.paxtools.model.level2.control;
import org.biopax.paxtools.model.level2.conversion;
import org.biopax.paxtools.model.level2.interaction;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;
import org.biopax.paxtools.model.level2.process;
import org.biopax.paxtools.model.level2.sequenceFeature;
import org.biopax.paxtools.model.level2.sequenceParticipant;

public class AffectsRule
extends InteractionRuleL2Adaptor {
    private static List<BinaryInteractionType> binaryInteractionTypes = Arrays.asList(BinaryInteractionType.ACTIVATES, BinaryInteractionType.INACTIVATES);

    @Override
    public void inferInteractionsFromPE(InteractionSet interactionSet, physicalEntity pe, Model model) {
        for (control cont : pe.getAllInteractions(control.class)) {
            for (process prcs : cont.getCONTROLLED()) {
                if (!(prcs instanceof conversion)) continue;
                this.createInteractions(interactionSet, pe, (conversion)prcs, cont);
            }
        }
    }

    @Override
    public List<BinaryInteractionType> getRuleTypes() {
        return binaryInteractionTypes;
    }

    private boolean isActive(physicalEntityParticipant pep) {
        if (!(!this.affectsSomething(pep) || this.isAnnotatedInactive(pep) || pep.getPHYSICAL_ENTITY() instanceof complex && this.complexHasInactiveMember((complex)pep.getPHYSICAL_ENTITY()))) {
            return true;
        }
        if (this.isAnnotatedActive(pep)) {
            return true;
        }
        return pep.getPHYSICAL_ENTITY() instanceof complex && this.complexHasActiveMember((complex)pep.getPHYSICAL_ENTITY()) && !this.complexHasInactiveMember((complex)pep.getPHYSICAL_ENTITY());
    }

    private boolean isInactive(physicalEntityParticipant pep) {
        if (this.isAnnotatedInactive(pep)) {
            return true;
        }
        return pep.getPHYSICAL_ENTITY() instanceof complex && this.complexHasInactiveMember((complex)pep.getPHYSICAL_ENTITY()) && !this.complexHasActiveMember((complex)pep.getPHYSICAL_ENTITY());
    }

    private boolean isAnnotatedActive(physicalEntityParticipant pep) {
        if (pep instanceof sequenceParticipant) {
            for (sequenceFeature sf : ((sequenceParticipant)pep).getSEQUENCE_FEATURE_LIST()) {
                if (sf.getFEATURE_TYPE() == null) continue;
                for (String term : sf.getFEATURE_TYPE().getTERM()) {
                    if (!term.startsWith("active")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isAnnotatedInactive(physicalEntityParticipant pep) {
        if (pep instanceof sequenceParticipant) {
            for (sequenceFeature sf : ((sequenceParticipant)pep).getSEQUENCE_FEATURE_LIST()) {
                if (sf.getFEATURE_TYPE() == null) continue;
                for (String term : sf.getFEATURE_TYPE().getTERM()) {
                    if (!term.startsWith("inactive") && !term.startsWith("ubiquitin")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean affectsSomething(physicalEntityParticipant pep) {
        physicalEntity pe = pep.getPHYSICAL_ENTITY();
        for (physicalEntityParticipant par : pe.isPHYSICAL_ENTITYof()) {
            if (par == pep || !par.isInEquivalentState(pep)) continue;
            for (interaction inter : par.isPARTICIPANTSof()) {
                if (!(inter instanceof control)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean complexHasActiveMember(complex cmp) {
        for (physicalEntityParticipant pep : cmp.getCOMPONENTS()) {
            if (this.isAnnotatedActive(pep)) {
                return true;
            }
            if (!(pep.getPHYSICAL_ENTITY() instanceof complex) || !this.complexHasActiveMember((complex)pep.getPHYSICAL_ENTITY())) continue;
            return true;
        }
        return false;
    }

    private boolean complexHasInactiveMember(complex cmp) {
        for (physicalEntityParticipant pep : cmp.getCOMPONENTS()) {
            if (this.isAnnotatedInactive(pep)) {
                return true;
            }
            if (!(pep.getPHYSICAL_ENTITY() instanceof complex) || !this.complexHasInactiveMember((complex)pep.getPHYSICAL_ENTITY())) continue;
            return true;
        }
        return false;
    }

    private Set<physicalEntity> getMembers(complex cmp, boolean active, Set<physicalEntity> set) {
        if (set == null) {
            set = new HashSet<physicalEntity>();
        }
        for (physicalEntityParticipant pep : cmp.getCOMPONENTS()) {
            if (!(pep.getPHYSICAL_ENTITY() instanceof complex) && (active && this.isAnnotatedActive(pep) || !active && this.isAnnotatedInactive(pep))) {
                set.add(pep.getPHYSICAL_ENTITY());
                continue;
            }
            if (!(pep.getPHYSICAL_ENTITY() instanceof complex)) continue;
            this.getMembers((complex)pep.getPHYSICAL_ENTITY(), active, set);
        }
        return set;
    }

    private Set<physicalEntityParticipant> getMembers(complex cmp, Set<physicalEntityParticipant> set) {
        if (set == null) {
            set = new HashSet<physicalEntityParticipant>();
        }
        for (physicalEntityParticipant pep : cmp.getCOMPONENTS()) {
            if (pep.getPHYSICAL_ENTITY() instanceof complex) {
                this.getMembers((complex)pep.getPHYSICAL_ENTITY(), set);
                continue;
            }
            set.add(pep);
        }
        return set;
    }

    private void createInteractions(InteractionSet interactionSet, physicalEntity A, conversion conv, control cont) {
        Direction dir;
        boolean l2r = true;
        if (cont instanceof catalysis && (dir = ((catalysis)cont).getDIRECTION()) != null) {
            if (dir == Direction.REVERSIBLE) {
                return;
            }
            if (dir == Direction.IRREVERSIBLE_RIGHT_TO_LEFT || dir == Direction.PHYSIOL_RIGHT_TO_LEFT) {
                l2r = false;
            }
        }
        int effect = 1;
        if (cont != null && cont.getCONTROL_TYPE() != null) {
            effect = cont.getCONTROL_TYPE().toString().startsWith("ACT") ? 1 : -1;
        }
        Set<physicalEntityParticipant> input = l2r ? conv.getLEFT() : conv.getRIGHT();
        Set<physicalEntityParticipant> output = !l2r ? conv.getLEFT() : conv.getRIGHT();
        this.enrichWithMembers(input);
        this.enrichWithMembers(output);
        Set<physicalEntityParticipant[]> matching = this.getEntityMatching(input, output);
        for (physicalEntityParticipant[] tuple : matching) {
            int inp;
            int n = this.isActive(tuple[0]) ? 1 : (inp = this.isInactive(tuple[0]) ? -1 : 0);
            int oup = this.isActive(tuple[1]) ? 1 : (this.isInactive(tuple[1]) ? -1 : 0);
            if (oup == 0 || inp == oup) continue;
            int sign = oup * effect;
            assert (sign != 0);
            if (sign == 1) {
                interactionSet.add(new SimpleInteraction(A, tuple[1].getPHYSICAL_ENTITY(), BinaryInteractionType.ACTIVATES));
                continue;
            }
            assert (sign == -1);
            interactionSet.add(new SimpleInteraction(A, tuple[1].getPHYSICAL_ENTITY(), BinaryInteractionType.INACTIVATES));
        }
        for (physicalEntityParticipant pep : output) {
            if (!(pep.getPHYSICAL_ENTITY() instanceof complex)) continue;
            int eff = this.isActive(pep) ? 1 : (this.isInactive(pep) ? -1 : 0);
            int sign = eff * effect;
            if (sign == 1) {
                interactionSet.add(new SimpleInteraction(A, pep.getPHYSICAL_ENTITY(), BinaryInteractionType.ACTIVATES));
            } else if (sign == -1) {
                interactionSet.add(new SimpleInteraction(A, pep.getPHYSICAL_ENTITY(), BinaryInteractionType.INACTIVATES));
            }
            if (sign == 0) continue;
            for (physicalEntity pe : eff == 1 ? this.getMembers((complex)pep.getPHYSICAL_ENTITY(), true, null) : this.getMembers((complex)pep.getPHYSICAL_ENTITY(), false, null)) {
                interactionSet.add(new SimpleInteraction(pe, pep.getPHYSICAL_ENTITY(), BinaryInteractionType.ACTIVATES));
            }
        }
    }

    private void enrichWithMembers(Set<physicalEntityParticipant> set) {
        for (physicalEntityParticipant pep : new HashSet<physicalEntityParticipant>(set)) {
            if (!(pep.getPHYSICAL_ENTITY() instanceof complex)) continue;
            set.addAll(this.getMembers((complex)pep.getPHYSICAL_ENTITY(), null));
        }
    }

    private Set<physicalEntityParticipant[]> getEntityMatching(Set<physicalEntityParticipant> set1, Set<physicalEntityParticipant> set2) {
        HashSet<physicalEntityParticipant[]> tuples = new HashSet<physicalEntityParticipant[]>();
        for (physicalEntityParticipant pep1 : set1) {
            for (physicalEntityParticipant pep2 : set2) {
                if (pep1.getPHYSICAL_ENTITY() != pep2.getPHYSICAL_ENTITY()) continue;
                tuples.add(new physicalEntityParticipant[]{pep1, pep2});
            }
        }
        return tuples;
    }
}

