/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.EnumeratedPropertyEditor;
import org.biopax.paxtools.controller.ObjectPropertyEditor;
import org.biopax.paxtools.controller.PrimitivePropertyEditor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimplePropertyAccessor;
import org.biopax.paxtools.controller.StringPropertyEditor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;

public abstract class AbstractPropertyEditor<D extends BioPAXElement, R>
extends SimplePropertyAccessor<D, R>
implements PropertyEditor<D, R> {
    protected static final Log log = LogFactory.getLog(AbstractPropertyEditor.class);
    protected Method setMethod;
    protected Method addMethod;
    protected Method removeMethod;
    protected final String property;
    private final Map<Class, Integer> maxCardinalities = new HashMap<Class, Integer>();
    public static ThreadLocal<Boolean> checkRestrictions = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };

    public AbstractPropertyEditor(String property, Method getMethod, Class<D> domain, Class<R> range, boolean multipleCardinality) {
        super(domain, range, multipleCardinality, getMethod);
        this.property = property;
        try {
            this.detectMethods();
        }
        catch (NoSuchMethodException e2) {
            log.error("Failed at reflection, no method: " + e2.getMessage());
        }
    }

    @Override
    public String toString() {
        String def = this.domain.getSimpleName() + " " + this.property + " " + this.range.getSimpleName();
        for (Class aClass : this.maxCardinalities.keySet()) {
            Integer cardinality = this.maxCardinalities.get(aClass);
            def = def + " C:" + aClass.getSimpleName() + ":" + cardinality;
        }
        return def;
    }

    public static <D extends BioPAXElement, R> PropertyEditor<D, R> createPropertyEditor(Class<D> domain, String property) {
        AbstractPropertyEditor editor;
        block2: {
            editor = null;
            try {
                Method getMethod = AbstractPropertyEditor.detectGetMethod(domain, property);
                boolean multipleCardinality = AbstractPropertyEditor.isMultipleCardinality(getMethod);
                Class range = AbstractPropertyEditor.detectRange(getMethod);
                editor = range.isPrimitive() || range.equals(Boolean.class) ? new PrimitivePropertyEditor(property, getMethod, domain, range, multipleCardinality) : (range.isEnum() ? new EnumeratedPropertyEditor(property, getMethod, domain, range, multipleCardinality) : (range.equals(String.class) ? new StringPropertyEditor<D>(property, getMethod, domain, multipleCardinality) : new ObjectPropertyEditor(property, getMethod, domain, range, multipleCardinality)));
            }
            catch (NoSuchMethodException e2) {
                if (!log.isWarnEnabled()) break block2;
                log.warn("Failed creating the controller for " + property + " on " + domain);
            }
        }
        return editor;
    }

    private static Method detectGetMethod(Class beanClass, String property) throws NoSuchMethodException {
        String javaMethodName = AbstractPropertyEditor.getJavaName(property);
        if (log.isTraceEnabled()) {
            log.trace("javaMethodName = get" + javaMethodName);
        }
        return beanClass.getMethod("get" + javaMethodName, new Class[0]);
    }

    private static String getJavaName(String owlName) {
        String s = owlName.replaceAll("-", "_");
        s = s.substring(0, 1).toUpperCase() + s.substring(1);
        return s;
    }

    protected static Class detectRange(Method getMethod) {
        Class<Number> range = getMethod.getReturnType();
        if (Collection.class.isAssignableFrom(range)) {
            range = Object.class;
            Type genericReturnType = getMethod.getGenericReturnType();
            if (genericReturnType instanceof ParameterizedType) {
                try {
                    range = (Class<Double>)((ParameterizedType)genericReturnType).getActualTypeArguments()[0];
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                if (range == Double.class) {
                    range = Double.TYPE;
                }
                if (range == Float.class) {
                    range = Float.TYPE;
                }
                if (range == Integer.class) {
                    range = Integer.TYPE;
                }
            }
            if (log.isTraceEnabled()) {
                log.trace(range);
            }
        }
        return range;
    }

    private void detectMethods() throws NoSuchMethodException {
        String javaName = AbstractPropertyEditor.getJavaName(this.property);
        if (this.multipleCardinality) {
            this.addMethod = this.domain.getMethod("add" + javaName, this.range);
            this.removeMethod = this.domain.getMethod("remove" + javaName, this.range);
        } else {
            this.setMethod = this.domain.getMethod("set" + javaName, this.range);
        }
    }

    @Override
    public Method getAddMethod() {
        return this.addMethod;
    }

    @Override
    public Method getGetMethod() {
        return this.getMethod;
    }

    @Override
    public String getProperty() {
        return this.property;
    }

    @Override
    public Method getRemoveMethod() {
        return this.removeMethod;
    }

    @Override
    public Method getSetMethod() {
        return this.setMethod;
    }

    @Override
    public void addMaxCardinalityRestriction(Class<? extends D> domain, int max2) {
        if (this.multipleCardinality) {
            this.maxCardinalities.put(domain, max2);
        } else if (max2 == 1) {
            if (log.isInfoEnabled()) {
                log.info("unnecessary use of cardinality restriction. Maybe you want to use functional instead?");
            }
        } else if (max2 == 0) {
            this.maxCardinalities.put(domain, max2);
        } else assert (false);
    }

    @Override
    public Integer getMaxCardinality(Class<? extends D> restrictedDomain) {
        return this.maxCardinalities.get(restrictedDomain);
    }

    protected boolean isInstanceOfAtLeastOne(Set<Class<? extends BioPAXElement>> classes, Object value) {
        boolean check = false;
        for (Class<? extends BioPAXElement> aClass : classes) {
            if (!aClass.isInstance(value)) continue;
            check = true;
            break;
        }
        return check;
    }

    @Override
    public R getUnknown() {
        return null;
    }

    @Override
    public void removeValueFromBean(R value, D bean) {
        try {
            if (this.removeMethod != null) {
                this.invokeMethod(this.removeMethod, bean, value);
            } else {
                assert (!this.isMultipleCardinality()) : "removeMethod is not defined for the multiple cardinality property: " + this.property + ". Here, this might add 'unknown' value while keeping exisiting one as well!";
                if (this.getValueFromBean(bean).contains(value)) {
                    this.setValueToBean(this.getUnknown(), bean);
                } else {
                    log.error("Given value :" + value + " is not equal to the existing value. " + "remove value is ignored");
                    assert (this.getRange().isInstance(value)) : "Range violation!";
                    assert (this.getDomain().isInstance(bean)) : "Domain violation!";
                }
            }
        }
        catch (Exception e2) {
            log.error(e2);
        }
    }

    @Override
    public void removeValueFromBean(Set<R> values, D bean) {
        for (R r : values) {
            this.removeValueFromBean(r, bean);
        }
    }

    protected void invokeMethod(Method method, D bean, R value) {
        assert (bean != null);
        try {
            method.invoke(this.domain.cast(bean), value);
        }
        catch (ClassCastException e2) {
            String message = "Failed to set property: " + this.property;
            if (!this.domain.isAssignableFrom(bean.getClass())) {
                message = message + "  Invalid domain bean: " + this.domain.getSimpleName() + " is not assignable from " + bean.getClass();
            }
            if (!this.range.isAssignableFrom(value.getClass())) {
                message = message + " Invalid range value: " + this.range + " is not assignable from " + value.getClass();
            }
            throw new IllegalBioPAXArgumentException(message, e2);
        }
        catch (Exception e3) {
            String valInfo = value == null ? null : value.getClass().getSimpleName() + ", " + value;
            String message = "Failed to set " + this.property + " with " + method.getName() + " on " + this.domain.getSimpleName() + " (" + bean.getClass().getSimpleName() + ", " + bean + ")" + " with range: " + this.range.getSimpleName() + " (" + valInfo + ")";
            throw new IllegalBioPAXArgumentException(message, e3);
        }
    }

    protected R parseValueFromString(String value) {
        throw new IllegalBioPAXArgumentException();
    }

    @Override
    public void setValueToBean(R value, D bean) {
        if (this.getPrimarySetMethod() != null) {
            if (log.isTraceEnabled()) {
                log.trace(this.getPrimarySetMethod().getName() + " bean:" + bean + " val:" + value);
            }
        } else {
            log.error("setMethod is null;  bean:" + bean + " (" + bean.getRDFId() + ") val:" + value);
        }
        if (value == null && !this.isMultipleCardinality()) {
            value = this.getUnknown();
        }
        if (value instanceof String) {
            value = this.parseValueFromString((String)value);
        }
        try {
            if (value != null && checkRestrictions.get().booleanValue()) {
                this.checkRestrictions(value, bean);
            }
            this.invokeMethod(this.getPrimarySetMethod(), bean, value);
        }
        catch (Exception e2) {
            log.error("Failed to set value: " + value + " to bean " + bean + "; bean class: " + bean.getClass().getSimpleName() + "; primary set method: " + this.getPrimarySetMethod() + (value != null ? "; value class: " + value.getClass().getSimpleName() : "") + ". Error: " + e2 + ", Cause: " + e2.getCause());
        }
    }

    @Override
    public void setValueToBean(Set<R> values, D bean) {
        if (values == null) {
            this.setValueToBean((Object)null, bean);
        } else if (this.isMultipleCardinality() || values.size() < 2) {
            for (R r : values) {
                this.setValueToBean(r, bean);
            }
        } else {
            throw new IllegalBioPAXArgumentException(this.getProperty() + " is single cardinality. Can not set" + "it with a set of size larger than" + " 1");
        }
    }

    protected void checkRestrictions(R value, D bean) {
        Integer max2 = this.maxCardinalities.get(value.getClass());
        if (max2 != null) {
            if (max2 == 0) {
                throw new IllegalBioPAXArgumentException("Cardinality 0 restriction violated");
            }
            assert (this.multipleCardinality);
            Set values = this.getValueFromBean(bean);
            if (values.size() >= max2) {
                throw new IllegalBioPAXArgumentException("Cardinality " + max2 + " restriction violated");
            }
        }
    }

    @Override
    public Method getPrimarySetMethod() {
        return this.multipleCardinality ? this.addMethod : this.setMethod;
    }
}

