/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Platform;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.Tokenize;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.ListIterator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.UnionPattern;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.sort.LocalOrderComparer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class KeyManager
implements Serializable {
    private IntHashMap keyList = new IntHashMap(10);
    private transient WeakHashMap docIndexes = new WeakHashMap(10);

    public KeyManager(Configuration configuration) {
        this.registerIdrefKey(configuration);
    }

    private void registerIdrefKey(Configuration configuration) {
        SchemaType schemaType = BuiltInSchemaFactory.getSchemaType(561);
        SchemaType schemaType2 = BuiltInSchemaFactory.getSchemaType(562);
        ContentTypeTest contentTypeTest = new ContentTypeTest(2, schemaType, configuration);
        contentTypeTest.setMatchDTDTypes(true);
        NodeTestPattern nodeTestPattern = new NodeTestPattern(contentTypeTest);
        ContentTypeTest contentTypeTest2 = new ContentTypeTest(2, schemaType2, configuration);
        contentTypeTest2.setMatchDTDTypes(true);
        NodeTestPattern nodeTestPattern2 = new NodeTestPattern(contentTypeTest2);
        NodeTestPattern nodeTestPattern3 = new NodeTestPattern(new ContentTypeTest(1, schemaType, configuration));
        NodeTestPattern nodeTestPattern4 = new NodeTestPattern(new ContentTypeTest(1, schemaType2, configuration));
        UnionPattern unionPattern = new UnionPattern(nodeTestPattern, nodeTestPattern2);
        UnionPattern unionPattern2 = new UnionPattern(nodeTestPattern3, nodeTestPattern4);
        UnionPattern unionPattern3 = new UnionPattern(unionPattern, unionPattern2);
        Atomizer atomizer = new Atomizer(new ContextItemExpression(), configuration);
        Tokenize tokenize = (Tokenize)SystemFunction.makeSystemFunction("tokenize", 2, configuration.getNamePool());
        StringValue stringValue = new StringValue("\\s");
        Expression[] expressionArray = new Expression[]{atomizer, stringValue};
        tokenize.setArguments(expressionArray);
        KeyDefinition keyDefinition = new KeyDefinition(unionPattern3, tokenize, null, null);
        try {
            this.addKeyDefinition(562, keyDefinition, configuration.getNamePool());
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new AssertionError((Object)transformerConfigurationException);
        }
    }

    public void addKeyDefinition(int n, KeyDefinition keyDefinition, NamePool namePool) throws TransformerConfigurationException {
        int n2;
        ArrayList<KeyDefinition> arrayList = (ArrayList<KeyDefinition>)this.keyList.get(n);
        if (arrayList == null) {
            arrayList = new ArrayList<KeyDefinition>(3);
            this.keyList.put(n, arrayList);
        } else {
            String string = keyDefinition.getCollationName();
            if (string == null) {
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    if (((KeyDefinition)arrayList.get(n2)).getCollationName() == null) continue;
                    throw new TransformerConfigurationException("All keys with the same name must use the same collation");
                }
            } else {
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    if (string.equals(((KeyDefinition)arrayList.get(n2)).getCollationName())) continue;
                    throw new TransformerConfigurationException("All keys with the same name must use the same collation");
                }
            }
        }
        arrayList.add(keyDefinition);
        boolean bl = false;
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            if (!((KeyDefinition)arrayList.get(n2)).isBackwardsCompatible()) continue;
            bl = true;
            break;
        }
        if (bl) {
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                KeyDefinition keyDefinition2 = (KeyDefinition)arrayList.get(n2);
                keyDefinition2.setBackwardsCompatible(true);
                if (keyDefinition2.getBody().getItemType(namePool.getTypeHierarchy()) == Type.STRING_TYPE) continue;
                AtomicSequenceConverter atomicSequenceConverter = new AtomicSequenceConverter(keyDefinition2.getBody(), Type.STRING_TYPE);
                keyDefinition2.setBody(atomicSequenceConverter);
            }
        }
    }

    public List getKeyDefinitions(int n) {
        return (List)this.keyList.get(n);
    }

    private synchronized HashMap buildIndex(int n, int n2, DocumentInfo documentInfo, XPathContext xPathContext) throws XPathException {
        List list = this.getKeyDefinitions(n);
        if (list == null) {
            DynamicError dynamicError = new DynamicError("Key " + xPathContext.getNamePool().getDisplayName(n) + " has not been defined");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("XTDE1260");
            throw dynamicError;
        }
        HashMap hashMap = new HashMap(100);
        for (int i = 0; i < list.size(); ++i) {
            this.constructIndex(documentInfo, hashMap, (KeyDefinition)list.get(i), n2, xPathContext, i == 0);
        }
        return hashMap;
    }

    private void constructIndex(DocumentInfo documentInfo, HashMap hashMap, KeyDefinition keyDefinition, int n, XPathContext xPathContext, boolean bl) throws XPathException {
        int n2;
        Pattern pattern = keyDefinition.getMatch();
        Expression expression = keyDefinition.getUse();
        Comparator comparator = keyDefinition.getCollation();
        XPathContextMajor xPathContextMajor = xPathContext.newContext();
        xPathContextMajor.setOrigin(keyDefinition);
        SlotManager slotManager = keyDefinition.getStackFrameMap();
        if (slotManager != null) {
            xPathContextMajor.openStackFrame(slotManager);
        }
        if ((n2 = pattern.getNodeKind()) == 2 || n2 == 0 || n2 == 9) {
            NodeInfo nodeInfo;
            AxisIterator axisIterator = documentInfo.iterateAxis((byte)5);
            while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
                if (nodeInfo.getNodeKind() == 1) {
                    NodeInfo nodeInfo2;
                    AxisIterator axisIterator2 = nodeInfo.iterateAxis((byte)2);
                    while ((nodeInfo2 = (NodeInfo)axisIterator2.next()) != null) {
                        if (!pattern.matches(nodeInfo2, xPathContextMajor)) continue;
                        this.processKeyNode(nodeInfo2, expression, n, comparator, hashMap, xPathContextMajor, bl);
                    }
                    if (n2 != 0 || !pattern.matches(nodeInfo, xPathContextMajor)) continue;
                    this.processKeyNode(nodeInfo, expression, n, comparator, hashMap, xPathContextMajor, bl);
                    continue;
                }
                if (!pattern.matches(nodeInfo, xPathContextMajor)) continue;
                this.processKeyNode(nodeInfo, expression, n, comparator, hashMap, xPathContextMajor, bl);
            }
        } else {
            NodeInfo nodeInfo;
            AxisIterator axisIterator = documentInfo.iterateAxis((byte)4, pattern.getNodeTest());
            while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
                if (!(pattern instanceof NodeTestPattern) && !pattern.matches(nodeInfo, xPathContextMajor)) continue;
                this.processKeyNode(nodeInfo, expression, n, comparator, hashMap, xPathContextMajor, bl);
            }
        }
    }

    private void processKeyNode(NodeInfo nodeInfo, Expression expression, int n, Comparator comparator, HashMap hashMap, XPathContext xPathContext, boolean bl) throws XPathException {
        int n2;
        AtomicValue atomicValue;
        AxisIterator axisIterator = SingletonIterator.makeIterator(nodeInfo);
        axisIterator.next();
        xPathContext.setCurrentIterator(axisIterator);
        Platform platform = null;
        if (comparator != null) {
            platform = xPathContext.getConfiguration().getPlatform();
        }
        SequenceIterator sequenceIterator = expression.iterate(xPathContext);
        while ((atomicValue = (AtomicValue)sequenceIterator.next()) != null && Type.isComparable(n2 = atomicValue.getItemType(null).getPrimitiveType(), n, false)) {
            Object object;
            if (n == 642) {
                object = comparator == null ? atomicValue.getStringValue() : platform.getCollationKey(comparator, atomicValue.getStringValue());
            } else if (n == 513) {
                object = comparator == null ? atomicValue.getStringValue() : platform.getCollationKey(comparator, atomicValue.getStringValue());
            } else {
                if (atomicValue instanceof NumericValue && ((NumericValue)atomicValue).isNaN()) break;
                try {
                    object = atomicValue.convert(n, xPathContext);
                }
                catch (XPathException xPathException) {
                    break;
                }
            }
            ArrayList<NodeInfo> arrayList = (ArrayList<NodeInfo>)hashMap.get(object);
            if (arrayList == null) {
                arrayList = new ArrayList<NodeInfo>(4);
                hashMap.put(object, arrayList);
                arrayList.add(nodeInfo);
                continue;
            }
            if (bl) {
                if (arrayList.get(arrayList.size() - 1) == nodeInfo) continue;
                arrayList.add(nodeInfo);
                continue;
            }
            LocalOrderComparer localOrderComparer = LocalOrderComparer.getInstance();
            for (int i = 0; i < arrayList.size(); ++i) {
                int n4 = localOrderComparer.compare(nodeInfo, (NodeInfo)arrayList.get(i));
                if (n4 > 0) continue;
                if (n4 != 0) {
                    arrayList.add(i, nodeInfo);
                }
                return;
            }
            arrayList.add(nodeInfo);
        }
    }

    public SequenceIterator selectByKey(int n, DocumentInfo documentInfo, AtomicValue atomicValue, XPathContext xPathContext) throws XPathException {
        Object object;
        int n2;
        boolean bl;
        KeyDefinition keyDefinition = (KeyDefinition)this.getKeyDefinitions(n).get(0);
        Comparator comparator = keyDefinition.getCollation();
        Platform platform = null;
        if (comparator != null) {
            platform = xPathContext.getConfiguration().getPlatform();
        }
        if (bl = keyDefinition.isBackwardsCompatible()) {
            atomicValue = atomicValue.convert(513, xPathContext);
        }
        if ((n2 = atomicValue.getItemType(null).getPrimitiveType()) == 532 || n2 == 515 || n2 == 516) {
            n2 = 517;
            atomicValue = atomicValue.convert(n2, xPathContext);
        }
        if ((object = this.getIndex(documentInfo, n, n2)) instanceof String) {
            DynamicError dynamicError = new DynamicError("Key definition is circular");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("XTDE0640");
            throw dynamicError;
        }
        HashMap hashMap = (HashMap)object;
        if (hashMap == null) {
            this.putIndex(documentInfo, n, n2, "Under Construction", xPathContext);
            hashMap = this.buildIndex(n, n2, documentInfo, xPathContext);
            this.putIndex(documentInfo, n, n2, hashMap, xPathContext);
        }
        Object object2 = n2 == 513 || n2 == 642 ? (comparator == null ? atomicValue.getStringValue() : platform.getCollationKey(comparator, atomicValue.getStringValue())) : atomicValue;
        ArrayList arrayList = (ArrayList)hashMap.get(object2);
        if (arrayList == null) {
            return EmptyIterator.getInstance();
        }
        return new ListIterator(arrayList);
    }

    private synchronized void putIndex(DocumentInfo documentInfo, int n, int n2, Object object, XPathContext xPathContext) {
        HashMap hashMap;
        WeakReference weakReference;
        if (this.docIndexes == null) {
            this.docIndexes = new WeakHashMap(10);
        }
        if ((weakReference = (WeakReference)this.docIndexes.get(documentInfo)) == null || weakReference.get() == null) {
            hashMap = new HashMap(10);
            xPathContext.getController().setUserData(documentInfo, "key-index-list", hashMap);
            this.docIndexes.put(documentInfo, new WeakReference<HashMap>(hashMap));
        } else {
            hashMap = (HashMap)weakReference.get();
        }
        hashMap.put(new Long((long)n << 32 | (long)n2), object);
    }

    private synchronized Object getIndex(DocumentInfo documentInfo, int n, int n2) {
        WeakReference weakReference;
        if (this.docIndexes == null) {
            this.docIndexes = new WeakHashMap(10);
        }
        if ((weakReference = (WeakReference)this.docIndexes.get(documentInfo)) == null) {
            return null;
        }
        HashMap hashMap = (HashMap)weakReference.get();
        if (hashMap == null) {
            return null;
        }
        return hashMap.get(new Long((long)n << 32 | (long)n2));
    }
}

