/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.tinytree.TinyTree;

public class SubstitutionGroupTest
extends NodeTest {
    private int fingerprint;
    private IntHashSet group;

    public SubstitutionGroupTest(int n, IntHashSet intHashSet) {
        this.group = intHashSet;
        this.fingerprint = n;
    }

    public boolean matches(int n, int n2, int n4) {
        return n == 1 && this.group.contains(n2 & 0xFFFFF);
    }

    public boolean matches(TinyTree tinyTree, int n) {
        return tinyTree.getNodeKind(n) == 1 && this.group.contains(tinyTree.getNameCode(n) & 0xFFFFF);
    }

    public boolean matches(NodeInfo nodeInfo) {
        return nodeInfo.getNodeKind() == 1 && this.group.contains(nodeInfo.getFingerprint());
    }

    public final double getDefaultPriority() {
        return 0.0;
    }

    public int getPrimitiveType() {
        return 1;
    }

    public int getNodeKindMask() {
        return 2;
    }

    public IntHashSet getRequiredNodeNames() {
        return this.group;
    }

    public int getHeadFingerprint() {
        return this.fingerprint;
    }

    public String toString(NamePool namePool) {
        return "schema-element(" + namePool.getDisplayName(this.fingerprint) + ')';
    }

    public int hashCode() {
        return this.fingerprint;
    }

    public boolean equals(Object object) {
        return object instanceof SubstitutionGroupTest && ((SubstitutionGroupTest)object).fingerprint == this.fingerprint;
    }
}

