/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.om.ArrayIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public class PositionIterator
implements SequenceIterator,
LookaheadIterator {
    private SequenceIterator base;
    private int position = 0;
    private int min = 1;
    private int max = Integer.MAX_VALUE;
    private Item nextItem = null;
    private Item current = null;

    public static SequenceIterator make(SequenceIterator sequenceIterator, int n, int n2) throws XPathException {
        if (sequenceIterator instanceof ArrayIterator) {
            return ((ArrayIterator)sequenceIterator).makeSliceIterator(n, n2);
        }
        return new PositionIterator(sequenceIterator, n, n2);
    }

    private PositionIterator(SequenceIterator sequenceIterator, int n, int n2) throws XPathException {
        this.base = sequenceIterator;
        this.min = n;
        if (n < 1) {
            n = 1;
        }
        this.max = n2;
        if (n2 < n) {
            this.nextItem = null;
            return;
        }
        int n4 = 1;
        while (n4++ <= n) {
            this.nextItem = sequenceIterator.next();
            if (this.nextItem != null) continue;
        }
        this.current = this.nextItem;
    }

    public boolean hasNext() {
        return this.nextItem != null;
    }

    public Item next() throws XPathException {
        if (this.nextItem == null) {
            this.current = null;
            this.position = -1;
            return null;
        }
        this.current = this.nextItem;
        ++this.position;
        this.nextItem = this.base.position() < this.max ? this.base.next() : null;
        return this.current;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() throws XPathException {
        return new PositionIterator(this.base.getAnother(), this.min, this.max);
    }

    public int getProperties() {
        return 4;
    }
}

