/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang.rdql;

import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.sparql.lang.rdql.ExprBoolean;
import com.hp.hpl.jena.sparql.lang.rdql.ExprNode;
import com.hp.hpl.jena.sparql.lang.rdql.ExprRDQL;
import com.hp.hpl.jena.sparql.lang.rdql.Q_PatternLiteral;
import com.hp.hpl.jena.sparql.lang.rdql.RDQLEvalFailureException;
import com.hp.hpl.jena.sparql.lang.rdql.RDQLParser;
import com.hp.hpl.jena.sparql.lang.rdql.RDQLQueryPrintUtils;
import com.hp.hpl.jena.sparql.lang.rdql.RDQL_NodeValue;
import com.hp.hpl.jena.sparql.lang.rdql.WorkingVar;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Q_StringMatch
extends ExprNode
implements ExprRDQL,
ExprBoolean {
    ExprRDQL left;
    ExprRDQL right;
    Q_PatternLiteral regex = null;
    private String printName = "strMatch";
    private String opSymbol = "=~";
    Pattern pattern = null;

    Q_StringMatch(int id) {
        super(id);
    }

    Q_StringMatch(RDQLParser p, int id) {
        super(p, id);
    }

    public RDQL_NodeValue evalRDQL(Query q, IndexValues env) {
        RDQL_NodeValue x = this.left.evalRDQL(q, env);
        String xx = x.valueString();
        boolean b = this.pattern.matcher(xx).find();
        WorkingVar result = new WorkingVar();
        result.setBoolean(b);
        return result;
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 2) {
            throw new QueryException("Q_StringMatch: Wrong number of children: " + n);
        }
        this.left = (ExprRDQL)((Object)this.jjtGetChild(0));
        this.right = (ExprRDQL)((Object)this.jjtGetChild(1));
        if (!(this.right instanceof Q_PatternLiteral)) {
            throw new RDQLEvalFailureException("Q_StringMatch: Pattern error");
        }
        this.regex = (Q_PatternLiteral)this.right;
        try {
            this.pattern = Pattern.compile(this.regex.patternString, this.regex.mask);
        }
        catch (PatternSyntaxException pEx) {
            throw new RDQLEvalFailureException("Q_StringMatch: Pattern exception: " + pEx);
        }
    }

    public boolean isApply() {
        return true;
    }

    public String getFun() {
        return super.constructURI(this.getClass().getName());
    }

    public int argCount() {
        return 2;
    }

    public Expression getArg(int i) {
        if (i == 0 && this.left instanceof Expression) {
            return (Expression)((Object)this.left);
        }
        if (i == 1 && this.right instanceof Expression) {
            return (Expression)((Object)this.right);
        }
        return null;
    }

    public String asInfixString() {
        return RDQLQueryPrintUtils.asInfixString2(this.left, this.right, this.printName, this.opSymbol);
    }

    public String asPrefixString() {
        return RDQLQueryPrintUtils.asPrefixString(this.left, this.right, this.printName, this.opSymbol);
    }

    public void format(IndentedWriter w) {
        RDQLQueryPrintUtils.format(w, this.left, this.right, this.printName, this.opSymbol);
    }

    public String toString() {
        return this.asInfixString();
    }
}

