/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIter;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.Utils;

public abstract class QueryIter2
extends QueryIter {
    private QueryIterator leftInput;
    private QueryIterator rightInput;

    public QueryIter2(QueryIterator left, QueryIterator right, ExecutionContext execCxt) {
        super(execCxt);
        this.leftInput = left;
        this.rightInput = right;
    }

    protected QueryIterator getLeft() {
        return this.leftInput;
    }

    protected QueryIterator getRight() {
        return this.rightInput;
    }

    protected final void closeIterator() {
        this.releaseResources();
        if (this.leftInput != null) {
            this.leftInput.close();
        }
        if (this.rightInput != null) {
            this.rightInput.close();
        }
        this.leftInput = null;
        this.rightInput = null;
    }

    protected abstract void releaseResources();

    public void output(IndentedWriter out, SerializationContext sCxt) {
        out.println(Utils.className(this));
        out.incIndent();
        out.print("(");
        out.incIndent();
        this.getLeft().output(out, sCxt);
        out.decIndent();
        out.println(")");
        out.print("(");
        out.incIndent();
        this.getRight().output(out, sCxt);
        out.decIndent();
        out.println(")");
        out.decIndent();
    }
}

