## ----env, include=FALSE, echo=FALSE, cache=FALSE-----
library("knitr")
opts_chunk$set(fig.align = 'center', 
               fig.show = 'hold', 
               par = TRUE,
               prompt = TRUE,
               eval = TRUE,
               comment = NA)
options(replace.assign = TRUE, 
        width = 55)

suppressPackageStartupMessages(library("MSnbase"))
suppressWarnings(suppressPackageStartupMessages(library("pRoloc")))
suppressPackageStartupMessages(library("pRolocdata"))
## suppressPackageStartupMessages(library("class"))
suppressPackageStartupMessages(library("xtable"))

## ----pRolocdata--------------------------------------
library("pRolocdata")
data(tan2009r1)
tan2009r1

## ----svmParamOptim, cache = TRUE, warning = FALSE, message = FALSE----
params <- svmOptimisation(tan2009r1, times = 10, xval = 5, verbose = FALSE)
params

## ----svmRes, warning=FALSE, tidy=FALSE, eval=TRUE----
tan2009r1 <- svmClassification(tan2009r1, params)
tan2009r1

## ----weigths, eval=FALSE-----------------------------
#  w <- table(fData(dunkley2006)$markers)
#  w <- 1/w[-5]
#  wpar <- svmOptimisation(dunkley2006, class.weights = w)
#  wres <- svmClassification(dunkley2006, pw, class.weights = w)

## ----getmlfunction, echo=FALSE-----------------------
## Add chi^2.
tab <- data.frame('parameter optimisation' = grep("Optimisation", ls("package:pRoloc"), value = TRUE), 
                  'classification' = grep("Classification", ls("package:pRoloc"), value = TRUE))
tab$algorithm <- c("nearest neighbour", "support vector machine", "naive bayes",
                   "neural networks", "PerTurbo", "partial least square", 
                   "random forest", "support vector machine")
tab$package <- c("class", "kernlab", "e1071",
                 "nnet", "pRoloc", "caret",
                 "randomForest", "e1071")
colnames(tab)[1] <- c("parameter optimisation")

## ----comptab, results='asis', echo=FALSE-------------
xt <- xtable(tab, label = "tab:algo",
             caption = "Supervised ML algorithm available in \\Rpackage{pRoloc}.")
print(xt, include.rownames = FALSE, size = "small")

## ----sessioninfo, results='asis', echo=FALSE---------
toLatex(sessionInfo())

