### R code from vignette source 'Vignette.Rnw'

###################################################
### code chunk number 1: Vignette.Rnw:68-71
###################################################
library(oposSOM)
env <- opossom.new(list(dataset.name="Tissues",
                        dim.1stLvlSom=20))


###################################################
### code chunk number 2: Vignette.Rnw:78-82
###################################################
data(opossom.tissues)
str(opossom.tissues, vec.len=3)

env$indata <- opossom.tissues


###################################################
### code chunk number 3: Vignette.Rnw:88-95
###################################################
data(opossom.tissues)

library(Biobase)
opossom.tissues.eset = ExpressionSet(assayData=opossom.tissues)
opossom.tissues.eset

env$indata <- opossom.tissues.eset


###################################################
### code chunk number 4: Vignette.Rnw:105-114
###################################################
env$group.labels <- c(rep("Homeostasis", 2),
                          "Endocrine",
                          "Digestion",
                          "Exocrine",
                          "Epithelium",
                          "Reproduction",
                          "Muscle",
                      rep("Immune System", 2),
                      rep("Nervous System", 2) )


###################################################
### code chunk number 5: Vignette.Rnw:116-125
###################################################
env$group.colors <- c(rep("gold", 2),
                          "red2",
                          "brown",
                          "purple",
                          "cyan",
                          "pink",
                          "green2",
                      rep("blue2", 2),
                      rep("gray", 2) )


###################################################
### code chunk number 6: Vignette.Rnw:131-153
###################################################
group.info <- data.frame( 
                  group.labels = c(rep("Homeostasis", 2),
                                       "Endocrine",
                                       "Digestion",
                                       "Exocrine",
                                       "Epithelium",
                                       "Reproduction",
                                       "Muscle",
                                   rep("Immune System", 2),
                                   rep("Nervous System", 2) ),

                  group.colors = c(rep("gold", 2),
                                       "red2",
                                       "brown",
                                       "purple",
                                       "cyan",
                                       "pink",
                                       "green2",
                                   rep("blue2", 2),
                                   rep("gray", 2) ),
													
                  row.names=colnames(opossom.tissues))


###################################################
### code chunk number 7: Vignette.Rnw:155-160
###################################################
opossom.tissues.eset = ExpressionSet(assayData=opossom.tissues,
                                     phenoData=AnnotatedDataFrame(group.info) )
opossom.tissues.eset

env$indata <- opossom.tissues.eset


###################################################
### code chunk number 8: Vignette.Rnw:170-171
###################################################
# opossom.run(env)


###################################################
### code chunk number 9: Vignette.Rnw:304-309
###################################################
env$preferences$pairwise.comparison.list <-
    list(list(c("liver","kidney cortex"),
              c("accumbens","cerebral cortex")),
         list(c("tongue"),
              c("accumbens","cerebral cortex")))


###################################################
### code chunk number 10: Vignette.Rnw:324-325
###################################################
sessionInfo()


