/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import uk.ac.manchester.cs.owl.owlapi.Internals;

public class ChangeAxiomVisitor
implements OWLAxiomVisitor {
    private final boolean addAxiom;
    private final Internals oi;

    public ChangeAxiomVisitor(Internals oi, boolean add) {
        this.oi = oi;
        this.addAxiom = add;
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.SUBCLASS_OF, axiom);
            if (!axiom.getSubClass().isAnonymous()) {
                OWLClass subClass = (OWLClass)axiom.getSubClass();
                this.oi.addToIndexedSet(subClass, this.oi.getSubClassAxiomsByLHS(), axiom);
                this.oi.addToIndexedSet(subClass, this.oi.getClassAxiomsByClass(), axiom);
            } else {
                this.oi.addGeneralClassAxioms(axiom);
            }
            if (!axiom.getSuperClass().isAnonymous()) {
                this.oi.addToIndexedSet((OWLClass)axiom.getSuperClass(), this.oi.getSubClassAxiomsByRHS(), axiom);
            }
        } else {
            this.oi.removeAxiomsByType(AxiomType.SUBCLASS_OF, axiom);
            if (!axiom.getSubClass().isAnonymous()) {
                OWLClass subClass = (OWLClass)axiom.getSubClass();
                this.oi.removeAxiomFromSet(subClass, this.oi.getSubClassAxiomsByLHS(), axiom, true);
                this.oi.removeAxiomFromSet(subClass, this.oi.getClassAxiomsByClass(), axiom, true);
            } else {
                this.oi.removeGeneralClassAxioms(axiom);
            }
            if (!axiom.getSuperClass().isAnonymous()) {
                this.oi.removeAxiomFromSet(axiom.getSuperClass().asOWLClass(), this.oi.getSubClassAxiomsByRHS(), axiom, true);
            }
        }
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addToIndexedSet(axiom.getSubject(), this.oi.getNegativeObjectPropertyAssertionAxiomsByIndividual(), axiom);
            this.oi.addAxiomsByType(AxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION, axiom);
        } else {
            this.oi.removeAxiomsByType(AxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION, axiom);
            this.oi.removeAxiomFromSet(axiom.getSubject(), this.oi.getNegativeObjectPropertyAssertionAxiomsByIndividual(), axiom, true);
        }
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addToIndexedSet(axiom.getProperty(), this.oi.getAsymmetricPropertyAxiomsByProperty(), axiom);
            this.oi.addAxiomsByType(AxiomType.ASYMMETRIC_OBJECT_PROPERTY, axiom);
        } else {
            this.oi.removeAxiomsByType(AxiomType.ASYMMETRIC_OBJECT_PROPERTY, axiom);
            this.oi.removeAxiomFromSet(axiom.getProperty(), this.oi.getAsymmetricPropertyAxiomsByProperty(), axiom, true);
        }
    }

    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addToIndexedSet(axiom.getProperty(), this.oi.getReflexivePropertyAxiomsByProperty(), axiom);
            this.oi.addAxiomsByType(AxiomType.REFLEXIVE_OBJECT_PROPERTY, axiom);
        } else {
            this.oi.removeAxiomsByType(AxiomType.REFLEXIVE_OBJECT_PROPERTY, axiom);
            this.oi.removeAxiomFromSet(axiom.getProperty(), this.oi.getReflexivePropertyAxiomsByProperty(), axiom, true);
        }
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.DISJOINT_CLASSES, axiom);
            boolean allAnon = true;
            for (OWLClassExpression desc : axiom.getClassExpressions()) {
                if (desc.isAnonymous()) continue;
                OWLClass cls = (OWLClass)desc;
                this.oi.addToIndexedSet(cls, this.oi.getDisjointClassesAxiomsByClass(), axiom);
                this.oi.addToIndexedSet(cls, this.oi.getClassAxiomsByClass(), axiom);
                allAnon = false;
            }
            if (allAnon) {
                this.oi.addGeneralClassAxioms(axiom);
            }
        } else {
            this.oi.removeAxiomsByType(AxiomType.DISJOINT_CLASSES, axiom);
            boolean allAnon = true;
            for (OWLClassExpression desc : axiom.getClassExpressions()) {
                if (desc.isAnonymous()) continue;
                OWLClass cls = (OWLClass)desc;
                this.oi.removeAxiomFromSet(cls, this.oi.getDisjointClassesAxiomsByClass(), axiom, true);
                this.oi.removeAxiomFromSet(cls, this.oi.getClassAxiomsByClass(), axiom, true);
                allAnon = false;
            }
            if (allAnon) {
                this.oi.removeGeneralClassAxioms(axiom);
            }
        }
    }

    public void visit(OWLDataPropertyDomainAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.DATA_PROPERTY_DOMAIN, axiom);
            this.oi.addToIndexedSet(axiom.getProperty(), this.oi.getDataPropertyDomainAxiomsByProperty(), axiom);
        } else {
            this.oi.removeAxiomsByType(AxiomType.DATA_PROPERTY_DOMAIN, axiom);
            this.oi.removeAxiomFromSet(axiom.getProperty(), this.oi.getDataPropertyDomainAxiomsByProperty(), axiom, true);
        }
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.OBJECT_PROPERTY_DOMAIN, axiom);
            if (axiom.getProperty() instanceof OWLObjectProperty) {
                this.oi.addToIndexedSet(axiom.getProperty(), this.oi.getObjectPropertyDomainAxiomsByProperty(), axiom);
            }
        } else {
            this.oi.removeAxiomsByType(AxiomType.OBJECT_PROPERTY_DOMAIN, axiom);
            if (axiom.getProperty() instanceof OWLObjectProperty) {
                this.oi.removeAxiomFromSet(axiom.getProperty(), this.oi.getObjectPropertyDomainAxiomsByProperty(), axiom, true);
            }
        }
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.EQUIVALENT_OBJECT_PROPERTIES, axiom);
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                this.oi.addToIndexedSet(prop, this.oi.getEquivalentObjectPropertyAxiomsByProperty(), axiom);
            }
        } else {
            this.oi.removeAxiomsByType(AxiomType.EQUIVALENT_OBJECT_PROPERTIES, axiom);
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                this.oi.removeAxiomFromSet(prop, this.oi.getEquivalentObjectPropertyAxiomsByProperty(), axiom, true);
            }
        }
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.INVERSE_OBJECT_PROPERTIES, axiom);
            this.oi.addToIndexedSet(axiom.getFirstProperty(), this.oi.getInversePropertyAxiomsByProperty(), axiom);
            this.oi.addToIndexedSet(axiom.getSecondProperty(), this.oi.getInversePropertyAxiomsByProperty(), axiom);
        } else {
            this.oi.removeAxiomsByType(AxiomType.INVERSE_OBJECT_PROPERTIES, axiom);
            this.oi.removeAxiomFromSet(axiom.getFirstProperty(), this.oi.getInversePropertyAxiomsByProperty(), axiom, false);
            this.oi.removeAxiomFromSet(axiom.getSecondProperty(), this.oi.getInversePropertyAxiomsByProperty(), axiom, false);
        }
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addToIndexedSet(axiom.getSubject(), this.oi.getNegativeDataPropertyAssertionAxiomsByIndividual(), axiom);
            this.oi.addAxiomsByType(AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION, axiom);
        } else {
            this.oi.removeAxiomsByType(AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION, axiom);
            this.oi.removeAxiomFromSet(axiom.getSubject(), this.oi.getNegativeDataPropertyAssertionAxiomsByIndividual(), axiom, true);
        }
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        if (this.addAxiom) {
            for (OWLIndividual ind : axiom.getIndividuals()) {
                this.oi.addToIndexedSet(ind, this.oi.getDifferentIndividualsAxiomsByIndividual(), axiom);
                this.oi.addAxiomsByType(AxiomType.DIFFERENT_INDIVIDUALS, axiom);
            }
        } else {
            this.oi.removeAxiomsByType(AxiomType.DIFFERENT_INDIVIDUALS, axiom);
            for (OWLIndividual ind : axiom.getIndividuals()) {
                this.oi.removeAxiomFromSet(ind, this.oi.getDifferentIndividualsAxiomsByIndividual(), axiom, true);
            }
        }
    }

    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.DISJOINT_DATA_PROPERTIES, axiom);
            for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                this.oi.addToIndexedSet(prop, this.oi.getDisjointDataPropertyAxiomsByProperty(), axiom);
            }
        } else {
            this.oi.removeAxiomsByType(AxiomType.DISJOINT_DATA_PROPERTIES, axiom);
            for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                this.oi.removeAxiomFromSet(prop, this.oi.getDisjointDataPropertyAxiomsByProperty(), axiom, true);
            }
        }
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.DISJOINT_OBJECT_PROPERTIES, axiom);
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                this.oi.addToIndexedSet(prop, this.oi.getDisjointObjectPropertyAxiomsByProperty(), axiom);
            }
        } else {
            this.oi.removeAxiomsByType(AxiomType.DISJOINT_OBJECT_PROPERTIES, axiom);
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                this.oi.removeAxiomFromSet(prop, this.oi.getDisjointObjectPropertyAxiomsByProperty(), axiom, true);
            }
        }
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.OBJECT_PROPERTY_RANGE, axiom);
            this.oi.addToIndexedSet(axiom.getProperty(), this.oi.getObjectPropertyRangeAxiomsByProperty(), axiom);
        } else {
            this.oi.removeAxiomsByType(AxiomType.OBJECT_PROPERTY_RANGE, axiom);
            this.oi.removeAxiomFromSet(axiom.getProperty(), this.oi.getObjectPropertyRangeAxiomsByProperty(), axiom, true);
        }
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.OBJECT_PROPERTY_ASSERTION, axiom);
            this.oi.addToIndexedSet(axiom.getSubject(), this.oi.getObjectPropertyAssertionsByIndividual(), axiom);
        } else {
            this.oi.removeAxiomsByType(AxiomType.OBJECT_PROPERTY_ASSERTION, axiom);
            this.oi.removeAxiomFromSet(axiom.getSubject(), this.oi.getObjectPropertyAssertionsByIndividual(), axiom, true);
        }
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.FUNCTIONAL_OBJECT_PROPERTY, axiom);
            this.oi.addToIndexedSet(axiom.getProperty(), this.oi.getFunctionalObjectPropertyAxiomsByProperty(), axiom);
        } else {
            this.oi.removeAxiomsByType(AxiomType.FUNCTIONAL_OBJECT_PROPERTY, axiom);
            this.oi.removeAxiomFromSet(axiom.getProperty(), this.oi.getFunctionalObjectPropertyAxiomsByProperty(), axiom, true);
        }
    }

    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.SUB_OBJECT_PROPERTY, axiom);
            this.oi.addToIndexedSet(axiom.getSubProperty(), this.oi.getObjectSubPropertyAxiomsByLHS(), axiom);
            this.oi.addToIndexedSet(axiom.getSuperProperty(), this.oi.getObjectSubPropertyAxiomsByRHS(), axiom);
        } else {
            this.oi.removeAxiomsByType(AxiomType.SUB_OBJECT_PROPERTY, axiom);
            this.oi.removeAxiomFromSet(axiom.getSubProperty(), this.oi.getObjectSubPropertyAxiomsByLHS(), axiom, true);
            this.oi.removeAxiomFromSet(axiom.getSuperProperty(), this.oi.getObjectSubPropertyAxiomsByRHS(), axiom, true);
        }
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.DISJOINT_UNION, axiom);
            this.oi.addToIndexedSet(axiom.getOWLClass(), this.oi.getDisjointUnionAxiomsByClass(), axiom);
            this.oi.addToIndexedSet(axiom.getOWLClass(), this.oi.getClassAxiomsByClass(), axiom);
        } else {
            this.oi.removeAxiomsByType(AxiomType.DISJOINT_UNION, axiom);
            this.oi.removeAxiomFromSet(axiom.getOWLClass(), this.oi.getDisjointUnionAxiomsByClass(), axiom, true);
            this.oi.removeAxiomFromSet(axiom.getOWLClass(), this.oi.getClassAxiomsByClass(), axiom, true);
        }
    }

    public void visit(OWLDeclarationAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.DECLARATION, axiom);
            this.oi.addDeclarationsByEntity(axiom.getEntity(), axiom);
        } else {
            this.oi.removeAxiomsByType(AxiomType.DECLARATION, axiom);
            this.oi.removeDeclarationsByEntity(axiom.getEntity(), axiom);
        }
    }

    public void visit(OWLAnnotationAssertionAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.ANNOTATION_ASSERTION, axiom);
            this.oi.addToIndexedSet(axiom.getSubject(), this.oi.getAnnotationAssertionAxiomsBySubject(), axiom);
        } else {
            this.oi.removeAxiomsByType(AxiomType.ANNOTATION_ASSERTION, axiom);
            this.oi.removeAxiomFromSet(axiom.getSubject(), this.oi.getAnnotationAssertionAxiomsBySubject(), axiom, true);
        }
    }

    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.ANNOTATION_PROPERTY_DOMAIN, axiom);
        } else {
            this.oi.removeAxiomsByType(AxiomType.ANNOTATION_PROPERTY_DOMAIN, axiom);
        }
    }

    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.ANNOTATION_PROPERTY_RANGE, axiom);
        } else {
            this.oi.removeAxiomsByType(AxiomType.ANNOTATION_PROPERTY_RANGE, axiom);
        }
    }

    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.SUB_ANNOTATION_PROPERTY_OF, axiom);
        } else {
            this.oi.removeAxiomsByType(AxiomType.SUB_ANNOTATION_PROPERTY_OF, axiom);
        }
    }

    public void visit(OWLHasKeyAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.HAS_KEY, axiom);
            if (!axiom.getClassExpression().isAnonymous()) {
                this.oi.addToIndexedSet(axiom.getClassExpression().asOWLClass(), this.oi.getHasKeyAxiomsByClass(), axiom);
            }
        } else {
            this.oi.removeAxiomsByType(AxiomType.HAS_KEY, axiom);
            if (!axiom.getClassExpression().isAnonymous()) {
                this.oi.removeAxiomFromSet(axiom.getClassExpression().asOWLClass(), this.oi.getHasKeyAxiomsByClass(), axiom, true);
            }
        }
    }

    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.SYMMETRIC_OBJECT_PROPERTY, axiom);
            this.oi.addToIndexedSet(axiom.getProperty(), this.oi.getSymmetricPropertyAxiomsByProperty(), axiom);
        } else {
            this.oi.removeAxiomsByType(AxiomType.SYMMETRIC_OBJECT_PROPERTY, axiom);
            this.oi.removeAxiomFromSet(axiom.getProperty(), this.oi.getSymmetricPropertyAxiomsByProperty(), axiom, true);
        }
    }

    public void visit(OWLDataPropertyRangeAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.DATA_PROPERTY_RANGE, axiom);
            this.oi.addToIndexedSet(axiom.getProperty(), this.oi.getDataPropertyRangeAxiomsByProperty(), axiom);
        } else {
            this.oi.removeAxiomsByType(AxiomType.DATA_PROPERTY_RANGE, axiom);
            this.oi.removeAxiomFromSet(axiom.getProperty(), this.oi.getDataPropertyRangeAxiomsByProperty(), axiom, true);
        }
    }

    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.FUNCTIONAL_DATA_PROPERTY, axiom);
            this.oi.addToIndexedSet(axiom.getProperty(), this.oi.getFunctionalDataPropertyAxiomsByProperty(), axiom);
        } else {
            this.oi.removeAxiomsByType(AxiomType.FUNCTIONAL_DATA_PROPERTY, axiom);
            this.oi.removeAxiomFromSet(axiom.getProperty(), this.oi.getFunctionalDataPropertyAxiomsByProperty(), axiom, true);
        }
    }

    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.EQUIVALENT_DATA_PROPERTIES, axiom);
            for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                this.oi.addToIndexedSet(prop, this.oi.getEquivalentDataPropertyAxiomsByProperty(), axiom);
            }
        } else {
            this.oi.removeAxiomsByType(AxiomType.EQUIVALENT_DATA_PROPERTIES, axiom);
            for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                this.oi.removeAxiomFromSet(prop, this.oi.getEquivalentDataPropertyAxiomsByProperty(), axiom, true);
            }
        }
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addToIndexedSet(axiom.getIndividual(), this.oi.getClassAssertionAxiomsByIndividual(), axiom);
            this.oi.addAxiomsByType(AxiomType.CLASS_ASSERTION, axiom);
            if (!axiom.getClassExpression().isAnonymous()) {
                this.oi.addToIndexedSet((OWLClass)axiom.getClassExpression(), this.oi.getClassAssertionAxiomsByClass(), axiom);
            }
        } else {
            this.oi.removeAxiomsByType(AxiomType.CLASS_ASSERTION, axiom);
            this.oi.removeAxiomFromSet(axiom.getIndividual(), this.oi.getClassAssertionAxiomsByIndividual(), axiom, true);
            if (!axiom.getClassExpression().isAnonymous()) {
                this.oi.removeAxiomFromSet((OWLClass)axiom.getClassExpression(), this.oi.getClassAssertionAxiomsByClass(), axiom, true);
            }
        }
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.EQUIVALENT_CLASSES, axiom);
            boolean allAnon = true;
            for (OWLClassExpression desc : axiom.getClassExpressions()) {
                if (desc.isAnonymous()) continue;
                this.oi.addToIndexedSet((OWLClass)desc, this.oi.getEquivalentClassesAxiomsByClass(), axiom);
                this.oi.addToIndexedSet((OWLClass)desc, this.oi.getClassAxiomsByClass(), axiom);
                allAnon = false;
            }
            if (allAnon) {
                this.oi.addGeneralClassAxioms(axiom);
            }
        } else {
            this.oi.removeAxiomsByType(AxiomType.EQUIVALENT_CLASSES, axiom);
            boolean allAnon = true;
            for (OWLClassExpression desc : axiom.getClassExpressions()) {
                if (desc.isAnonymous()) continue;
                this.oi.removeAxiomFromSet((OWLClass)desc, this.oi.getEquivalentClassesAxiomsByClass(), axiom, true);
                this.oi.removeAxiomFromSet((OWLClass)desc, this.oi.getClassAxiomsByClass(), axiom, true);
                allAnon = false;
            }
            if (allAnon) {
                this.oi.removeGeneralClassAxioms(axiom);
            }
        }
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.DATA_PROPERTY_ASSERTION, axiom);
            this.oi.addToIndexedSet(axiom.getSubject(), this.oi.getDataPropertyAssertionsByIndividual(), axiom);
        } else {
            this.oi.removeAxiomsByType(AxiomType.DATA_PROPERTY_ASSERTION, axiom);
            this.oi.removeAxiomFromSet(axiom.getSubject(), this.oi.getDataPropertyAssertionsByIndividual(), axiom, true);
        }
    }

    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.TRANSITIVE_OBJECT_PROPERTY, axiom);
            this.oi.addToIndexedSet(axiom.getProperty(), this.oi.getTransitivePropertyAxiomsByProperty(), axiom);
        } else {
            this.oi.removeAxiomsByType(AxiomType.TRANSITIVE_OBJECT_PROPERTY, axiom);
            this.oi.removeAxiomFromSet(axiom.getProperty(), this.oi.getTransitivePropertyAxiomsByProperty(), axiom, true);
        }
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.IRREFLEXIVE_OBJECT_PROPERTY, axiom);
            this.oi.addToIndexedSet(axiom.getProperty(), this.oi.getIrreflexivePropertyAxiomsByProperty(), axiom);
        } else {
            this.oi.removeAxiomsByType(AxiomType.IRREFLEXIVE_OBJECT_PROPERTY, axiom);
            this.oi.removeAxiomFromSet(axiom.getProperty(), this.oi.getIrreflexivePropertyAxiomsByProperty(), axiom, true);
        }
    }

    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.SUB_DATA_PROPERTY, axiom);
            this.oi.addToIndexedSet(axiom.getSubProperty(), this.oi.getDataSubPropertyAxiomsByLHS(), axiom);
            this.oi.addToIndexedSet(axiom.getSuperProperty(), this.oi.getDataSubPropertyAxiomsByRHS(), axiom);
        } else {
            this.oi.removeAxiomsByType(AxiomType.SUB_DATA_PROPERTY, axiom);
            this.oi.removeAxiomFromSet(axiom.getSubProperty(), this.oi.getDataSubPropertyAxiomsByLHS(), axiom, true);
            this.oi.removeAxiomFromSet(axiom.getSuperProperty(), this.oi.getDataSubPropertyAxiomsByRHS(), axiom, true);
        }
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY, axiom);
            this.oi.addToIndexedSet(axiom.getProperty(), this.oi.getInverseFunctionalPropertyAxiomsByProperty(), axiom);
        } else {
            this.oi.removeAxiomsByType(AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY, axiom);
            this.oi.removeAxiomFromSet(axiom.getProperty(), this.oi.getInverseFunctionalPropertyAxiomsByProperty(), axiom, true);
        }
    }

    public void visit(OWLSameIndividualAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.SAME_INDIVIDUAL, axiom);
            for (OWLIndividual ind : axiom.getIndividuals()) {
                this.oi.addToIndexedSet(ind, this.oi.getSameIndividualsAxiomsByIndividual(), axiom);
            }
        } else {
            this.oi.removeAxiomsByType(AxiomType.SAME_INDIVIDUAL, axiom);
            for (OWLIndividual ind : axiom.getIndividuals()) {
                this.oi.removeAxiomFromSet(ind, this.oi.getSameIndividualsAxiomsByIndividual(), axiom, true);
            }
        }
    }

    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.SUB_PROPERTY_CHAIN_OF, axiom);
            this.oi.addPropertyChainSubPropertyAxioms(axiom);
        } else {
            this.oi.removeAxiomsByType(AxiomType.SUB_PROPERTY_CHAIN_OF, axiom);
            this.oi.removePropertyChainSubPropertyAxioms(axiom);
        }
    }

    public void visit(SWRLRule rule) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.SWRL_RULE, rule);
        } else {
            this.oi.removeAxiomsByType(AxiomType.SWRL_RULE, rule);
        }
    }

    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        if (this.addAxiom) {
            this.oi.addAxiomsByType(AxiomType.DATATYPE_DEFINITION, axiom);
        } else {
            this.oi.removeAxiomsByType(AxiomType.DATATYPE_DEFINITION, axiom);
        }
    }
}

