/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ontocat.virtual;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import uk.ac.ebi.ontocat.OntologyService;
import uk.ac.ebi.ontocat.OntologyServiceException;
import uk.ac.ebi.ontocat.OntologyTerm;
import uk.ac.ebi.ontocat.ols.OlsOntologyService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeServiceNoThreads
implements InvocationHandler {
    private List<OntologyService> ontoServices;
    private static final Logger log = Logger.getLogger(CompositeServiceNoThreads.class);

    private CompositeServiceNoThreads(List<OntologyService> ontoServices) {
        this.ontoServices = ontoServices;
    }

    private static Object createProxy(Object obj, List list) throws OntologyServiceException {
        try {
            obj.getClass().getMethod("searchAll", String.class, OntologyService.SearchOptions[].class);
            obj.getClass().getMethod("getOntologies", new Class[0]);
            obj.getClass().getMethod("getTermPath", String.class, String.class);
            obj.getClass().getMethod("getTermPath", OntologyTerm.class);
        }
        catch (Exception e) {
            log.fatal("Signature has changed in proxy pattern!");
            throw new OntologyServiceException(e);
        }
        return Proxy.newProxyInstance(obj.getClass().getClassLoader(), obj.getClass().getInterfaces(), (InvocationHandler)new CompositeServiceNoThreads(list));
    }

    public static OntologyService getService(List list) throws OntologyServiceException {
        return (OntologyService)CompositeServiceNoThreads.createProxy(new OlsOntologyService(), list);
    }

    public static OntologyService getService(OntologyService ... list) throws OntologyServiceException {
        return (OntologyService)CompositeServiceNoThreads.createProxy(new OlsOntologyService(), Arrays.asList(list));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Cloneable result = null;
        if (method.getReturnType() == List.class) {
            result = new ArrayList();
        }
        if (method.getReturnType() == Map.class) {
            result = new HashMap();
        }
        if (method.getReturnType() == Set.class) {
            result = new HashSet();
        }
        for (OntologyService os : this.ontoServices) {
            Object singleResult = method.invoke((Object)os, args);
            if (method.getName().equalsIgnoreCase("searchAll") || method.getName().equalsIgnoreCase("getOntologies")) {
                ((ArrayList)result).addAll((Collection)singleResult);
                continue;
            }
            if (!this.isValidResult(method, singleResult).booleanValue()) continue;
            return singleResult;
        }
        if (method.getName().equalsIgnoreCase("searchAll")) {
            Collections.sort((List)((Object)result));
        }
        return result;
    }

    private Boolean isValidResult(Method method, Object result) {
        if (result == null) {
            return false;
        }
        if (result instanceof Map && ((Map)result).size() == 0) {
            return false;
        }
        if (result instanceof Set && ((Set)result).size() == 0) {
            return false;
        }
        if (result instanceof List) {
            Integer listSize = ((List)result).size();
            String methodName = method.getName();
            if (listSize == 0 || methodName.equalsIgnoreCase("getTermPath") && listSize == 1) {
                return false;
            }
        }
        return true;
    }
}

